/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.Util;
import hudson.util.Secret;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArgumentListBuilder
implements Serializable,
Cloneable {
    private final List<String> args = new ArrayList<String>();
    private BitSet mask = new BitSet();
    private static final long serialVersionUID = 1L;

    public ArgumentListBuilder() {
    }

    public ArgumentListBuilder(String ... args) {
        this.add(args);
    }

    public ArgumentListBuilder add(Object a) {
        return this.add(a.toString(), false);
    }

    public ArgumentListBuilder add(Object a, boolean mask) {
        return this.add(a.toString(), mask);
    }

    public ArgumentListBuilder add(File f) {
        return this.add(f.getAbsolutePath(), false);
    }

    public ArgumentListBuilder add(String a) {
        return this.add(a, false);
    }

    public ArgumentListBuilder add(String a, boolean mask) {
        if (a != null) {
            if (mask) {
                this.mask.set(this.args.size());
            }
            this.args.add(a);
        }
        return this;
    }

    public ArgumentListBuilder prepend(String ... args) {
        BitSet nm = new BitSet(this.args.size() + args.length);
        for (int i = 0; i < this.args.size(); ++i) {
            nm.set(i + args.length, this.mask.get(i));
        }
        this.mask = nm;
        this.args.addAll(0, Arrays.asList(args));
        return this;
    }

    public ArgumentListBuilder addQuoted(String a) {
        return this.add('\"' + a + '\"', false);
    }

    public ArgumentListBuilder addQuoted(String a, boolean mask) {
        return this.add('\"' + a + '\"', mask);
    }

    public ArgumentListBuilder add(String ... args) {
        for (String arg : args) {
            this.add(arg);
        }
        return this;
    }

    public ArgumentListBuilder addTokenized(String s) {
        if (s == null) {
            return this;
        }
        this.add(Util.tokenize(s));
        return this;
    }

    public ArgumentListBuilder addKeyValuePair(String prefix, String key, String value, boolean mask) {
        if (key == null) {
            return this;
        }
        this.add((prefix == null ? "-D" : prefix) + key + '=' + value, mask);
        return this;
    }

    public ArgumentListBuilder addKeyValuePairs(String prefix, Map<String, String> props) {
        for (Map.Entry<String, String> e : props.entrySet()) {
            this.addKeyValuePair(prefix, e.getKey(), e.getValue(), false);
        }
        return this;
    }

    public ArgumentListBuilder addKeyValuePairs(String prefix, Map<String, String> props, Set<String> propsToMask) {
        for (Map.Entry<String, String> e : props.entrySet()) {
            this.addKeyValuePair(prefix, e.getKey(), e.getValue(), propsToMask == null ? false : propsToMask.contains(e.getKey()));
        }
        return this;
    }

    public ArgumentListBuilder addKeyValuePairsFromPropertyString(String prefix, String properties, VariableResolver<String> vr) throws IOException {
        return this.addKeyValuePairsFromPropertyString(prefix, properties, vr, null);
    }

    public ArgumentListBuilder addKeyValuePairsFromPropertyString(String prefix, String properties, VariableResolver<String> vr, Set<String> propsToMask) throws IOException {
        if (properties == null) {
            return this;
        }
        properties = Util.replaceMacro(properties, ArgumentListBuilder.propertiesGeneratingResolver(vr));
        for (Map.Entry<Object, Object> entry : Util.loadProperties(properties).entrySet()) {
            this.addKeyValuePair(prefix, (String)entry.getKey(), entry.getValue().toString(), propsToMask == null ? false : propsToMask.contains(entry.getKey()));
        }
        return this;
    }

    private static VariableResolver<String> propertiesGeneratingResolver(final VariableResolver<String> original) {
        return new VariableResolver<String>(){

            @Override
            public String resolve(String name) {
                String value = (String)original.resolve(name);
                if (value == null) {
                    return null;
                }
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
        };
    }

    public String[] toCommandArray() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public ArgumentListBuilder clone() {
        ArgumentListBuilder r = new ArgumentListBuilder();
        r.args.addAll(this.args);
        r.mask = (BitSet)this.mask.clone();
        return r;
    }

    public void clear() {
        this.args.clear();
        this.mask.clear();
    }

    public List<String> toList() {
        return this.args;
    }

    public String toStringWithQuote() {
        StringBuilder buf = new StringBuilder();
        for (String arg : this.args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (arg.indexOf(32) >= 0 || arg.length() == 0) {
                buf.append('\"').append(arg).append('\"');
                continue;
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public ArgumentListBuilder toWindowsCommand(boolean escapeVars) {
        ArgumentListBuilder windowsCommand = new ArgumentListBuilder().add("cmd.exe", "/C");
        for (int i = 0; i < this.args.size(); ++i) {
            StringBuilder quotedArgs = new StringBuilder();
            String arg = this.args.get(i);
            boolean percent = false;
            boolean quoted = false;
            for (int j = 0; j < arg.length(); ++j) {
                int c = arg.charAt(j);
                if (!(quoted || c != 32 && c != 42 && c != 63 && c != 44 && c != 59)) {
                    quoted = ArgumentListBuilder.startQuoting(quotedArgs, arg, j);
                } else if (c == 94 || c == 38 || c == 60 || c == 62 || c == 124) {
                    if (!quoted) {
                        quoted = ArgumentListBuilder.startQuoting(quotedArgs, arg, j);
                    }
                } else if (c == 34) {
                    if (!quoted) {
                        quoted = ArgumentListBuilder.startQuoting(quotedArgs, arg, j);
                    }
                    quotedArgs.append('\"');
                } else if (percent && escapeVars && (c >= 65 && c <= 90 || c >= 97 && c <= 122)) {
                    if (!quoted) {
                        quoted = ArgumentListBuilder.startQuoting(quotedArgs, arg, j);
                    }
                    quotedArgs.append('\"').append((char)c);
                    c = 34;
                }
                boolean bl = percent = c == 37;
                if (!quoted) continue;
                quotedArgs.append((char)c);
            }
            if (i == 0 && quoted) {
                quotedArgs.insert(0, '\"');
            } else if (i == 0 && !quoted) {
                quotedArgs.append('\"');
            }
            if (quoted) {
                quotedArgs.append('\"');
            } else {
                quotedArgs.append(arg);
            }
            windowsCommand.add(quotedArgs, this.mask.get(i));
        }
        windowsCommand.add("&&").add("exit").add("%%ERRORLEVEL%%\"");
        return windowsCommand;
    }

    public ArgumentListBuilder toWindowsCommand() {
        return this.toWindowsCommand(false);
    }

    private static boolean startQuoting(StringBuilder buf, String arg, int atIndex) {
        buf.append('\"').append(arg.substring(0, atIndex));
        return true;
    }

    public boolean hasMaskedArguments() {
        return this.mask.length() > 0;
    }

    public boolean[] toMaskArray() {
        boolean[] mask = new boolean[this.args.size()];
        for (int i = 0; i < mask.length; ++i) {
            mask[i] = this.mask.get(i);
        }
        return mask;
    }

    public void addMasked(String string) {
        this.add(string, true);
    }

    public ArgumentListBuilder addMasked(Secret s) {
        return this.add(Secret.toString(s), true);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.args.size(); ++i) {
            String arg = this.args.get(i);
            if (this.mask.get(i)) {
                arg = "******";
            }
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (arg.indexOf(32) >= 0 || arg.length() == 0) {
                buf.append('\"').append(arg).append('\"');
                continue;
            }
            buf.append(arg);
        }
        return buf.toString();
    }
}

