/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.jcraft.jzlib.GZIPInputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import hudson.Util;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.IOUtils;
import hudson.util.NamingThreadFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompressedFile {
    private final File file;
    private final File gz;
    private static final ExecutorService compressionThread = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ExceptionCatchingThreadFactory(new NamingThreadFactory(new DaemonThreadFactory(), "CompressedFile")));
    private static final Logger LOGGER = Logger.getLogger(CompressedFile.class.getName());

    public CompressedFile(File file) {
        this.file = file;
        this.gz = new File(file.getParentFile(), file.getName() + ".gz");
    }

    public OutputStream write() throws FileNotFoundException {
        if (this.gz.exists()) {
            this.gz.delete();
        }
        return new FileOutputStream(this.file);
    }

    public InputStream read() throws IOException {
        if (this.file.exists()) {
            return new FileInputStream(this.file);
        }
        if (this.gz.exists()) {
            return new GZIPInputStream((InputStream)new FileInputStream(this.gz));
        }
        throw new FileNotFoundException(this.file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadAsString() throws IOException {
        long sizeGuess;
        if (this.file.exists()) {
            sizeGuess = this.file.length();
        } else if (this.gz.exists()) {
            sizeGuess = this.gz.length() * 2L;
        } else {
            return "";
        }
        StringBuilder str = new StringBuilder((int)sizeGuess);
        InputStreamReader r = new InputStreamReader(this.read());
        try {
            int len;
            char[] buf = new char[8192];
            while ((len = ((Reader)r).read(buf, 0, buf.length)) > 0) {
                str.append(buf, 0, len);
            }
        }
        finally {
            IOUtils.closeQuietly(r);
        }
        return str.toString();
    }

    public void compress() {
        compressionThread.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InputStream in = CompressedFile.this.read();
                    GZIPOutputStream out = new GZIPOutputStream((OutputStream)new FileOutputStream(CompressedFile.this.gz));
                    try {
                        Util.copyStream(in, (OutputStream)out);
                    }
                    finally {
                        in.close();
                        out.close();
                    }
                    CompressedFile.this.file.delete();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to compress " + CompressedFile.this.file, e);
                    CompressedFile.this.gz.delete();
                }
            }
        });
    }
}

