/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Deprecated
public abstract class FormFieldValidator {
    public static final Permission CHECK = Jenkins.ADMINISTER;
    protected final StaplerRequest request;
    protected final StaplerResponse response;
    protected final Permission permission;
    protected final AccessControlled subject;

    protected FormFieldValidator(StaplerRequest request, StaplerResponse response, boolean adminOnly) {
        this(request, response, adminOnly ? Jenkins.getInstance() : null, adminOnly ? CHECK : null);
    }

    @Deprecated
    protected FormFieldValidator(StaplerRequest request, StaplerResponse response, Permission permission) {
        this(request, response, Jenkins.getInstance(), permission);
    }

    protected FormFieldValidator(Permission permission) {
        this(Stapler.getCurrentRequest(), Stapler.getCurrentResponse(), permission);
    }

    @Deprecated
    protected FormFieldValidator(StaplerRequest request, StaplerResponse response, AccessControlled subject, Permission permission) {
        this.request = request;
        this.response = response;
        this.subject = subject;
        this.permission = permission;
    }

    protected FormFieldValidator(AccessControlled subject, Permission permission) {
        this(Stapler.getCurrentRequest(), Stapler.getCurrentResponse(), subject, permission);
    }

    public final void process() throws IOException, ServletException {
        block4: {
            if (this.permission != null) {
                try {
                    if (this.subject == null) {
                        throw new AccessDeniedException("No subject");
                    }
                    this.subject.checkPermission(this.permission);
                }
                catch (AccessDeniedException e) {
                    if (Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) break block4;
                    throw e;
                }
            }
        }
        this.check();
    }

    protected abstract void check() throws IOException, ServletException;

    protected final File getFileParameter(String paramName) {
        return new File(Util.fixNull(this.request.getParameter(paramName)));
    }

    public void ok() throws IOException, ServletException {
        this.respond("<div/>");
    }

    public void respond(String html) throws IOException, ServletException {
        this.response.setContentType("text/html");
        this.response.getWriter().print(html);
    }

    public void error(String message) throws IOException, ServletException {
        this.errorWithMarkup(message == null ? null : Util.escape(message));
    }

    public void warning(String message) throws IOException, ServletException {
        this.warningWithMarkup(message == null ? null : Util.escape(message));
    }

    public void ok(String message) throws IOException, ServletException {
        this.okWithMarkup(message == null ? null : Util.escape(message));
    }

    public void error(String format, Object ... args) throws IOException, ServletException {
        this.error(String.format(format, args));
    }

    public void warning(String format, Object ... args) throws IOException, ServletException {
        this.warning(String.format(format, args));
    }

    public void ok(String format, Object ... args) throws IOException, ServletException {
        this.ok(String.format(format, args));
    }

    public void errorWithMarkup(String message) throws IOException, ServletException {
        this._errorWithMarkup(message, "error");
    }

    public void warningWithMarkup(String message) throws IOException, ServletException {
        this._errorWithMarkup(message, "warning");
    }

    public void okWithMarkup(String message) throws IOException, ServletException {
        this._errorWithMarkup(message, "ok");
    }

    private void _errorWithMarkup(String message, String cssClass) throws IOException, ServletException {
        if (message == null) {
            this.ok();
        } else {
            this.response.setContentType("text/html;charset=UTF-8");
            this.response.getWriter().print("<div class=" + cssClass + "><img src='" + this.request.getContextPath() + Jenkins.RESOURCE_PATH + "/images/none.gif' height=16 width=1>" + message + "</div>");
        }
    }

    @Deprecated
    public static class NonNegativeInteger
    extends FormFieldValidator {
        public NonNegativeInteger() {
            super(null);
        }

        @Override
        protected void check() throws IOException, ServletException {
            try {
                String value = this.request.getParameter("value");
                if (Integer.parseInt(value) < 0) {
                    this.error(hudson.model.Messages.Hudson_NotAPositiveNumber());
                } else {
                    this.ok();
                }
            }
            catch (NumberFormatException e) {
                this.error(hudson.model.Messages.Hudson_NotANumber());
            }
        }
    }

    @Deprecated
    public static class Base64
    extends FormFieldValidator {
        private final boolean allowWhitespace;
        private final boolean allowEmpty;
        private final String errorMessage;

        public Base64(StaplerRequest request, StaplerResponse response, boolean allowWhitespace, boolean allowEmpty, String errorMessage) {
            super(request, response, false);
            this.allowWhitespace = allowWhitespace;
            this.allowEmpty = allowEmpty;
            this.errorMessage = errorMessage;
        }

        @Override
        protected void check() throws IOException, ServletException {
            try {
                String v = this.request.getParameter("value");
                if (!(this.allowWhitespace || v.indexOf(32) < 0 && v.indexOf(10) < 0)) {
                    this.fail();
                    return;
                }
                v = v.trim();
                if (!this.allowEmpty && v.length() == 0) {
                    this.fail();
                    return;
                }
                com.trilead.ssh2.crypto.Base64.decode((char[])v.toCharArray());
                this.ok();
            }
            catch (IOException e) {
                this.fail();
            }
        }

        protected void fail() throws IOException, ServletException {
            this.error(this.errorMessage);
        }
    }

    @Deprecated
    public static class Executable
    extends FormFieldValidator {
        public Executable(StaplerRequest request, StaplerResponse response) {
            super(request, response, true);
        }

        @Override
        protected void check() throws IOException, ServletException {
            String exe = Util.fixEmpty(this.request.getParameter("value"));
            if (exe == null) {
                this.ok();
                return;
            }
            if (exe.indexOf(File.separatorChar) >= 0) {
                File f = new File(exe);
                if (f.exists()) {
                    this.checkExecutable(f);
                    return;
                }
                File fexe = new File(exe + ".exe");
                if (fexe.exists()) {
                    this.checkExecutable(fexe);
                    return;
                }
                this.error("There's no such file: " + exe);
            } else {
                String path = EnvVars.masterEnvVars.get("PATH");
                String tokenizedPath = "";
                String delimiter = null;
                if (path != null) {
                    for (String _dir : Util.tokenize(path.replace("\\", "\\\\"), File.pathSeparator)) {
                        if (delimiter == null) {
                            delimiter = ", ";
                        } else {
                            tokenizedPath = tokenizedPath + delimiter;
                        }
                        tokenizedPath = tokenizedPath + _dir.replace('\\', '/');
                        File dir = new File(_dir);
                        File f = new File(dir, exe);
                        if (f.exists()) {
                            this.checkExecutable(f);
                            return;
                        }
                        File fexe = new File(dir, exe + ".exe");
                        if (!fexe.exists()) continue;
                        this.checkExecutable(fexe);
                        return;
                    }
                    tokenizedPath = tokenizedPath + ".";
                } else {
                    tokenizedPath = "unavailable.";
                }
                this.error("There's no such executable " + exe + " in PATH: " + tokenizedPath);
            }
        }

        protected void checkExecutable(File exe) throws IOException, ServletException {
            this.ok();
        }
    }

    @Deprecated
    public static class WorkspaceFilePath
    extends FormFieldValidator {
        private final boolean errorIfNotExist;
        private final boolean expectingFile;

        public WorkspaceFilePath(StaplerRequest request, StaplerResponse response, boolean errorIfNotExist, boolean expectingFile) {
            super(request, response, (AccessControlled)request.findAncestorObject(AbstractProject.class), Item.CONFIGURE);
            this.errorIfNotExist = errorIfNotExist;
            this.expectingFile = expectingFile;
        }

        @Override
        protected void check() throws IOException, ServletException {
            String value = Util.fixEmpty(this.request.getParameter("value"));
            AbstractProject p = (AbstractProject)this.subject;
            if (value == null || p == null) {
                this.ok();
                return;
            }
            if (value.contains("*")) {
                this.error("Wildcard is not allowed here");
                return;
            }
            try {
                FilePath ws = this.getBaseDirectory(p);
                if (ws == null) {
                    this.ok();
                    return;
                }
                if (!ws.exists()) {
                    this.ok();
                    return;
                }
                if (ws.child(value).exists()) {
                    if (this.expectingFile) {
                        if (!ws.child(value).isDirectory()) {
                            this.ok();
                        } else {
                            this.error(value + " is not a file");
                        }
                    } else if (ws.child(value).isDirectory()) {
                        this.ok();
                    } else {
                        this.error(value + " is not a directory");
                    }
                } else {
                    String msg = "No such " + (this.expectingFile ? "file" : "directory") + ": " + value;
                    if (this.errorIfNotExist) {
                        this.error(msg);
                    } else {
                        this.warning(msg);
                    }
                }
            }
            catch (InterruptedException e) {
                this.ok();
            }
        }

        protected FilePath getBaseDirectory(AbstractProject<?, ?> p) {
            return p.getSomeWorkspace();
        }
    }

    @Deprecated
    public static class WorkspaceDirectory
    extends WorkspaceFilePath {
        public WorkspaceDirectory(StaplerRequest request, StaplerResponse response, boolean errorIfNotExist) {
            super(request, response, errorIfNotExist, false);
        }

        public WorkspaceDirectory(StaplerRequest request, StaplerResponse response) {
            this(request, response, true);
        }
    }

    @Deprecated
    public static class WorkspaceFileMask
    extends FormFieldValidator {
        private final boolean errorIfNotExist;

        public WorkspaceFileMask(StaplerRequest request, StaplerResponse response) {
            this(request, response, true);
        }

        public WorkspaceFileMask(StaplerRequest request, StaplerResponse response, boolean errorIfNotExist) {
            super(request, response, (AccessControlled)request.findAncestorObject(AbstractProject.class), Item.CONFIGURE);
            this.errorIfNotExist = errorIfNotExist;
        }

        @Override
        protected void check() throws IOException, ServletException {
            String value = Util.fixEmpty(this.request.getParameter("value"));
            AbstractProject p = (AbstractProject)this.subject;
            if (value == null || p == null) {
                this.ok();
                return;
            }
            try {
                FilePath ws = this.getBaseDirectory(p);
                if (ws == null || !ws.exists()) {
                    this.ok();
                    return;
                }
                String msg = ws.validateAntFileMask(value, FilePath.VALIDATE_ANT_FILE_MASK_BOUND);
                if (this.errorIfNotExist) {
                    this.error(msg);
                } else {
                    this.warning(msg);
                }
            }
            catch (InterruptedException e) {
                this.ok(Messages.FormFieldValidator_did_not_manage_to_validate_may_be_too_sl(value));
            }
        }

        protected FilePath getBaseDirectory(AbstractProject<?, ?> p) {
            return p.getSomeWorkspace();
        }
    }

    public static class HudsonURL
    extends URLCheck {
        public HudsonURL(StaplerRequest request, StaplerResponse response) {
            super(request, response);
        }

        @Override
        protected void check() throws IOException, ServletException {
            String value = Util.fixEmpty(this.request.getParameter("value"));
            if (value == null) {
                this.ok();
                return;
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
            try {
                URL url = new URL(value);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.connect();
                if (con.getResponseCode() != 200 || con.getHeaderField("X-Hudson") == null) {
                    this.error(value + " is not Hudson (" + con.getResponseMessage() + ")");
                    return;
                }
                this.ok();
            }
            catch (IOException e) {
                this.handleIOException(value, e);
            }
        }
    }

    @Deprecated
    public static abstract class URLCheck
    extends FormFieldValidator {
        public URLCheck(StaplerRequest request, StaplerResponse response) {
            super(request, response, true);
        }

        protected BufferedReader open(URL url) throws IOException {
            URLConnection con = ProxyConfiguration.open(url);
            if (con == null) {
                throw new IOException(url.toExternalForm());
            }
            return new BufferedReader(new InputStreamReader(con.getInputStream(), this.getCharset(con)));
        }

        protected boolean findText(BufferedReader in, String literal) throws IOException {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(literal) == -1) continue;
                return true;
            }
            return false;
        }

        protected void handleIOException(String url, IOException e) throws IOException, ServletException {
            if (e.getMessage().equals(url)) {
                this.error("Unable to connect " + url);
            } else {
                this.error(e.getMessage());
            }
        }

        private String getCharset(URLConnection con) {
            for (String t : con.getContentType().split(";")) {
                if (!(t = t.trim().toLowerCase(Locale.ENGLISH)).startsWith("charset=")) continue;
                return t.substring(8);
            }
            return "UTF-8";
        }
    }
}

