/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MultipartFormDataParser {
    private final ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
    private final Map<String, FileItem> byName = new HashMap<String, FileItem>();

    public MultipartFormDataParser(HttpServletRequest request) throws ServletException {
        try {
            for (FileItem fi : this.upload.parseRequest(request)) {
                this.byName.put(fi.getFieldName(), fi);
            }
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String get(String key) {
        FileItem fi = this.byName.get(key);
        if (fi == null) {
            return null;
        }
        return fi.getString();
    }

    public FileItem getFileItem(String key) {
        return this.byName.get(key);
    }

    public void cleanUp() {
        for (FileItem item : this.byName.values()) {
            item.delete();
        }
    }

    public static boolean isMultiPartForm(@CheckForNull String contentType) {
        if (contentType == null) {
            return false;
        }
        String[] parts = contentType.split(";");
        if (parts.length == 0) {
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            if (!"multipart/form-data".equals(parts[i])) continue;
            return true;
        }
        return false;
    }
}

