/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import hudson.util.RobustReflectionConverter;
import java.util.Map;
import jenkins.util.xstream.CriticalXStreamException;

final class RobustMapConverter
extends MapConverter {
    private static final Object ERROR = new Object();

    RobustMapConverter(Mapper mapper) {
        super(mapper);
    }

    protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        Object key = this.read(reader, context, map);
        Object value = this.read(reader, context, map);
        if (key != ERROR && value != ERROR) {
            target.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        reader.moveDown();
        try {
            Object object = this.readItem(reader, context, map);
            return object;
        }
        catch (CriticalXStreamException x) {
            throw x;
        }
        catch (XStreamException x) {
            RobustReflectionConverter.addErrorInContext(context, x);
            Object object = ERROR;
            return object;
        }
        catch (LinkageError x) {
            RobustReflectionConverter.addErrorInContext(context, x);
            Object object = ERROR;
            return object;
        }
        finally {
            reader.moveUp();
        }
    }
}

