/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.util.io.ReopenableFileOutputStream;
import java.io.File;
import java.io.IOException;

public class ReopenableRotatingFileOutputStream
extends ReopenableFileOutputStream {
    private final int size;

    public ReopenableRotatingFileOutputStream(File out, int size) {
        super(out);
        this.size = size;
    }

    protected File getNumberedFileName(int n) {
        if (n == 0) {
            return this.out;
        }
        return new File(this.out.getPath() + "." + n);
    }

    @Override
    public void rewind() throws IOException {
        super.rewind();
        for (int i = this.size - 1; i >= 0; --i) {
            File fi = this.getNumberedFileName(i);
            if (!fi.exists()) continue;
            File next = this.getNumberedFileName(i + 1);
            next.delete();
            fi.renameTo(next);
        }
    }

    public void deleteAll() {
        for (int i = 0; i <= this.size; ++i) {
            this.getNumberedFileName(i).delete();
        }
    }
}

