/*
 * Decompiled with CFR 0.152.
 */
package jenkins.install;

import hudson.BulkChange;
import hudson.Extension;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.PageDecorator;
import hudson.model.UpdateCenter;
import hudson.model.UpdateSite;
import hudson.model.User;
import hudson.security.FullControlOnceLoggedInAuthorizationStrategy;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.security.csrf.DefaultCrumbIssuer;
import hudson.util.HttpResponses;
import hudson.util.PluginServletFilter;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jenkins.install.InstallState;
import jenkins.install.InstallUtil;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public class SetupWizard
extends PageDecorator {
    public static String initialSetupAdminUserName = "admin";
    private static final Logger LOGGER = Logger.getLogger(SetupWizard.class.getName());
    private static boolean isUsingSecurityToken = false;
    private final Filter FORCE_SETUP_WIZARD_FILTER = new Filter(){

        public void init(FilterConfig cfg) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req;
            if (request instanceof HttpServletRequest && ((req = (HttpServletRequest)request).getContextPath() + "/").equals(req.getRequestURI())) {
                Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
                chain.doFilter((ServletRequest)new HttpServletRequestWrapper(req){

                    public String getRequestURI() {
                        return this.getContextPath() + "/setupWizard/";
                    }
                }, response);
                return;
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(boolean newInstall) throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.getInstance();
        if (newInstall) {
            this.setCurrentLevel(Jenkins.getVersion());
            FilePath iapf = this.getInitialAdminPasswordFile();
            if (jenkins.getSecurityRealm() == null || jenkins.getSecurityRealm() == SecurityRealm.NO_AUTHENTICATION) {
                BulkChange bc = new BulkChange(jenkins);
                try {
                    HudsonPrivateSecurityRealm securityRealm = new HudsonPrivateSecurityRealm(false, false, null);
                    jenkins.setSecurityRealm(securityRealm);
                    String randomUUID = UUID.randomUUID().toString().replace("-", "").toLowerCase(Locale.ENGLISH);
                    securityRealm.createAccount(initialSetupAdminUserName, randomUUID);
                    iapf.touch(System.currentTimeMillis());
                    iapf.chmod(416);
                    iapf.write(randomUUID + System.lineSeparator(), "UTF-8");
                    FullControlOnceLoggedInAuthorizationStrategy authStrategy = new FullControlOnceLoggedInAuthorizationStrategy();
                    authStrategy.setAllowAnonymousRead(false);
                    jenkins.setAuthorizationStrategy(authStrategy);
                    jenkins.setSlaveAgentPort(-1);
                    jenkins.setCrumbIssuer(new DefaultCrumbIssuer(false));
                    ((AdminWhitelistRule)jenkins.getInjector().getInstance(AdminWhitelistRule.class)).setMasterKillSwitch(false);
                    jenkins.save();
                    bc.commit();
                }
                finally {
                    bc.abort();
                }
            }
            if (iapf.exists()) {
                String setupKey = iapf.readToString().trim();
                String ls = System.lineSeparator();
                LOGGER.info(ls + ls + "*************************************************************" + ls + "*************************************************************" + ls + "*************************************************************" + ls + ls + "Jenkins initial setup is required. An admin user has been created and " + "a password generated." + ls + "Please use the following password to proceed to installation:" + ls + ls + setupKey + ls + ls + "This may also be found at: " + iapf.getRemote() + ls + ls + "*************************************************************" + ls + "*************************************************************" + ls + "*************************************************************" + ls);
            }
            try {
                PluginServletFilter.addFilter(this.FORCE_SETUP_WIZARD_FILTER);
                isUsingSecurityToken = this.isUsingSecurityDefaults();
            }
            catch (ServletException e) {
                throw new RuntimeException("Unable to add PluginServletFilter for the SetupWizard", e);
            }
        }
        try {
            UpdateCenter.updateDefaultSite();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public boolean isUsingSecurityToken() {
        try {
            return isUsingSecurityToken && !Jenkins.getInstance().getInstallState().isSetupComplete() && this.isUsingSecurityDefaults();
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isUsingSecurityDefaults() {
        Jenkins j = Jenkins.getInstance();
        if (j.getSecurityRealm() instanceof HudsonPrivateSecurityRealm) {
            HudsonPrivateSecurityRealm securityRealm = (HudsonPrivateSecurityRealm)j.getSecurityRealm();
            try {
                if (securityRealm.getAllUsers().size() == 1) {
                    HudsonPrivateSecurityRealm.Details details = securityRealm.loadUserByUsername(initialSetupAdminUserName);
                    FilePath iapf = this.getInitialAdminPasswordFile();
                    if (iapf.exists() && details.isPasswordCorrect(iapf.readToString().trim())) {
                        return true;
                    }
                }
            }
            catch (IOException | InterruptedException | UsernameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateAdminUser(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        block8: {
            Jenkins j = Jenkins.getInstance();
            j.checkPermission(Jenkins.ADMINISTER);
            HudsonPrivateSecurityRealm securityRealm = (HudsonPrivateSecurityRealm)j.getSecurityRealm();
            User admin = securityRealm.getUser(initialSetupAdminUserName);
            try {
                User u;
                if (admin != null) {
                    admin.delete();
                }
                if ((u = securityRealm.createAccountByAdmin(req, rsp, "/jenkins/install/SetupWizard/setupWizardFirstUser.jelly", req.getContextPath() + "/")) == null) break block8;
                if (admin != null) {
                    admin = null;
                }
                try {
                    this.getInitialAdminPasswordFile().delete();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                InstallUtil.proceedToNextStateFrom(InstallState.CREATE_ADMIN_USER);
                UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)u.getId(), (Object)req.getParameter("password1"));
                a = securityRealm.getSecurityComponents().manager.authenticate((Authentication)a);
                SecurityContextHolder.getContext().setAuthentication((Authentication)a);
            }
            finally {
                if (admin != null) {
                    admin.save();
                }
            }
        }
    }

    void setCurrentLevel(VersionNumber v) throws IOException {
        FileUtils.writeStringToFile((File)SetupWizard.getUpdateStateFile(), (String)v.toString());
    }

    static File getUpdateStateFile() {
        return new File(Jenkins.getInstance().getRootDir(), "jenkins.install.UpgradeWizard.state");
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public VersionNumber getCurrentLevel() {
        VersionNumber from = new VersionNumber("1.0");
        File state = SetupWizard.getUpdateStateFile();
        if (state.exists()) {
            try {
                from = new VersionNumber(StringUtils.defaultIfBlank((String)FileUtils.readFileToString((File)state), (String)"1.0").trim());
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Cannot read the current version file", ex);
                return null;
            }
        }
        return from;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doPlatformPluginList() throws IOException {
        SetupWizard setupWizard = Jenkins.getInstance().getSetupWizard();
        if (setupWizard != null) {
            if (InstallState.UPGRADE.equals(Jenkins.getInstance().getInstallState())) {
                JSONArray initialPluginData = this.getPlatformPluginUpdates();
                if (initialPluginData != null) {
                    return HttpResponses.okJSON(initialPluginData);
                }
            } else {
                JSONArray initialPluginData = this.getPlatformPluginList();
                if (initialPluginData != null) {
                    return HttpResponses.okJSON(initialPluginData);
                }
            }
        }
        return HttpResponses.okJSON();
    }

    @CheckForNull
    public JSONArray getPlatformPluginUpdates() {
        VersionNumber version = this.getCurrentLevel();
        if (version == null) {
            return null;
        }
        return this.getPlatformPluginsForUpdate(version, Jenkins.getVersion());
    }

    @CheckForNull
    JSONArray getPlatformPluginList() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        JSONArray initialPluginList = null;
        for (UpdateSite updateSite : Jenkins.getInstance().getUpdateCenter().getSiteList()) {
            String updateCenterJsonUrl = updateSite.getUrl();
            String suggestedPluginUrl = updateCenterJsonUrl.replace("/update-center.json", "/platform-plugins.json");
            try {
                URLConnection connection = ProxyConfiguration.open(new URL(suggestedPluginUrl));
                try {
                    int responseCode;
                    if (connection instanceof HttpURLConnection && 200 != (responseCode = ((HttpURLConnection)connection).getResponseCode())) {
                        throw new HttpRetryException("Invalid response code (" + responseCode + ") from URL: " + suggestedPluginUrl, responseCode);
                    }
                    String initialPluginJson = IOUtils.toString((InputStream)connection.getInputStream(), (String)"utf-8");
                    initialPluginList = JSONArray.fromObject((Object)initialPluginJson);
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (initialPluginList == null) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                URL localPluginData = cl.getResource("jenkins/install/platform-plugins.json");
                String initialPluginJson = IOUtils.toString((InputStream)localPluginData.openStream(), (String)"utf-8");
                initialPluginList = JSONArray.fromObject((Object)initialPluginJson);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return initialPluginList;
    }

    JSONArray getPlatformPluginsForUpdate(VersionNumber from, VersionNumber to) {
        Jenkins jenkins = Jenkins.getInstance();
        JSONArray pluginCategories = JSONArray.fromObject((Object)this.getPlatformPluginList().toString());
        Iterator categoryIterator = pluginCategories.iterator();
        while (categoryIterator.hasNext()) {
            Object category = categoryIterator.next();
            if (!(category instanceof JSONObject)) continue;
            JSONObject cat = (JSONObject)category;
            JSONArray plugins = cat.getJSONArray("plugins");
            Iterator pluginIterator = plugins.iterator();
            while (pluginIterator.hasNext()) {
                VersionNumber v;
                String sinceVersion;
                JSONObject plugin;
                Object pluginData = pluginIterator.next();
                if (pluginData instanceof JSONObject && (plugin = (JSONObject)pluginData).has("added") && (sinceVersion = plugin.getString("added")) != null && (v = new VersionNumber(sinceVersion)).compareTo(to) <= 0 && v.compareTo(from) > 0) {
                    String pluginName = plugin.getString("name");
                    if (null == jenkins.getPluginManager().getPlugin(pluginName)) {
                        boolean foundCompatibleVersion = false;
                        for (UpdateSite site : jenkins.getUpdateCenter().getSiteList()) {
                            UpdateSite.Plugin sitePlug = site.getPlugin(pluginName);
                            if (sitePlug == null || sitePlug.isForNewerHudson() || sitePlug.isNeededDependenciesForNewerJenkins()) continue;
                            foundCompatibleVersion = true;
                            break;
                        }
                        if (foundCompatibleVersion) continue;
                    }
                }
                pluginIterator.remove();
            }
            if (!plugins.isEmpty()) continue;
            categoryIterator.remove();
        }
        return pluginCategories;
    }

    public FilePath getInitialAdminPasswordFile() {
        return Jenkins.getInstance().getRootPath().child("secrets/initialAdminPassword");
    }

    public HttpResponse doCompleteInstall() throws IOException, ServletException {
        this.completeSetup();
        return HttpResponses.okJSON();
    }

    void completeSetup() throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        InstallUtil.saveLastExecVersion();
        this.setCurrentLevel(Jenkins.getVersion());
        PluginServletFilter.removeFilter(this.FORCE_SETUP_WIZARD_FILTER);
        isUsingSecurityToken = false;
        InstallUtil.proceedToNextStateFrom(InstallState.INITIAL_SETUP_COMPLETED);
    }

    public List<InstallState> getInstallStates() {
        return InstallState.all();
    }

    public InstallState getInstallState(String name) {
        if (name == null) {
            return null;
        }
        return InstallState.valueOf(name);
    }
}

