/*
 * Decompiled with CFR 0.152.
 */
package jenkins.install;

import hudson.Extension;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;
import javax.servlet.http.HttpSession;
import jenkins.install.InstallState;
import jenkins.install.InstallStateFilter;
import jenkins.install.SetupWizard;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.apache.commons.io.FileUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public class UpgradeWizard
extends InstallState {
    private volatile boolean isUpToDate = true;
    private static final String SHOW_UPGRADE_WIZARD_FLAG = UpgradeWizard.class.getName() + ".show";
    private static final Logger LOGGER = Logger.getLogger(UpgradeWizard.class.getName());

    UpgradeWizard() {
        super("UPGRADE", false);
    }

    public static UpgradeWizard get() {
        return (UpgradeWizard)InstallState.UPGRADE;
    }

    @Override
    public void initializeState() {
        this.updateUpToDate();
        if (this.isUpToDate && Jenkins.getInstance().getSetupWizard().getPlatformPluginUpdates().isEmpty()) {
            Jenkins.getInstance().setInstallState(InstallState.RUNNING);
        }
    }

    @Override
    public boolean isSetupComplete() {
        return !this.isDue();
    }

    private void updateUpToDate() {
        try {
            JSONArray platformPlugins = Jenkins.getInstance().getSetupWizard().getPlatformPluginUpdates();
            this.isUpToDate = platformPlugins.isEmpty();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to get the platform plugin update list.", e);
        }
    }

    public boolean isDue() {
        if (this.isUpToDate) {
            return false;
        }
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return false;
        }
        WebApp wa = WebApp.getCurrent();
        if (wa == null || !(wa.getApp() instanceof Jenkins)) {
            return false;
        }
        return System.currentTimeMillis() > SetupWizard.getUpdateStateFile().lastModified();
    }

    public boolean isShowUpgradeWizard() {
        HttpSession session = Stapler.getCurrentRequest().getSession(false);
        if (session != null) {
            return Boolean.TRUE.equals(session.getAttribute(SHOW_UPGRADE_WIZARD_FLAG));
        }
        return false;
    }

    public HttpResponse doShowUpgradeWizard() throws Exception {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        HttpSession session = Stapler.getCurrentRequest().getSession(true);
        session.setAttribute(SHOW_UPGRADE_WIZARD_FLAG, (Object)true);
        return HttpResponses.redirectToContextRoot();
    }

    public HttpResponse doHideUpgradeWizard() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        HttpSession session = Stapler.getCurrentRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(SHOW_UPGRADE_WIZARD_FLAG);
        }
        return HttpResponses.redirectToContextRoot();
    }

    @RequirePOST
    public HttpResponse doSnooze() throws IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        File f = SetupWizard.getUpdateStateFile();
        FileUtils.touch((File)f);
        f.setLastModified(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L));
        LOGGER.log(Level.FINE, "Snoozed the upgrade wizard notice");
        return HttpResponses.redirectToContextRoot();
    }

    @Extension
    public static class ListenForInstallComplete
    extends InstallStateFilter {
        @Override
        public InstallState getNextInstallState(InstallState current, Provider<InstallState> proceed) {
            InstallState next = (InstallState)proceed.get();
            if (InstallState.INITIAL_SETUP_COMPLETED.equals(current)) {
                UpgradeWizard.get().isUpToDate = true;
            }
            return next;
        }
    }
}

