/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.Main;
import hudson.model.AdministrativeMonitor;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Descriptor;
import hudson.model.DownloadService;
import hudson.model.TaskListener;
import hudson.model.UpdateSite;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"downloadSettings"})
@Restricted(value={NoExternalUse.class})
public final class DownloadSettings
extends GlobalConfiguration {
    private boolean useBrowser = false;

    public static DownloadSettings get() {
        return (DownloadSettings)Jenkins.getInstance().getInjector().getInstance(DownloadSettings.class);
    }

    public DownloadSettings() {
        this.load();
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    public boolean isUseBrowser() {
        return this.useBrowser;
    }

    public void setUseBrowser(boolean useBrowser) {
        this.useBrowser = useBrowser;
        this.save();
    }

    @Override
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public static boolean usePostBack() {
        return DownloadSettings.get().isUseBrowser() && Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER);
    }

    public static void checkPostBackAccess() throws AccessDeniedException {
        if (!DownloadSettings.get().isUseBrowser()) {
            throw new AccessDeniedException("browser-based download disabled");
        }
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
    }

    @Extension
    public static final class Warning
    extends AdministrativeMonitor {
        @Override
        public boolean isActivated() {
            return DownloadSettings.get().isUseBrowser();
        }
    }

    @Extension
    @Symbol(value={"updateCenterCheck"})
    public static final class DailyCheck
    extends AsyncPeriodicWork {
        private static final Logger LOGGER = Logger.getLogger(DailyCheck.class.getName());

        public DailyCheck() {
            super("Download metadata");
        }

        @Override
        public long getRecurrencePeriod() {
            return 86400000L;
        }

        @Override
        public long getInitialDelay() {
            return Main.isUnitTest ? 86400000L : 0L;
        }

        @Override
        protected void execute(TaskListener listener) throws IOException, InterruptedException {
            if (DownloadSettings.get().isUseBrowser()) {
                return;
            }
            boolean due = false;
            for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSites()) {
                if (!site.isDue()) continue;
                due = true;
                break;
            }
            if (!due) {
                long now = System.currentTimeMillis();
                for (DownloadService.Downloadable d : DownloadService.Downloadable.all()) {
                    if (d.getDue() > now) continue;
                    try {
                        d.updateNow();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, String.format("Unable to update downloadable [%s]", d.getId()), e);
                    }
                }
                return;
            }
            HttpResponse rsp = Jenkins.getInstance().getPluginManager().doCheckUpdatesServer();
            if (rsp instanceof FormValidation) {
                listener.error(((FormValidation)rsp).renderHtml());
            }
        }
    }
}

