/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

enum Boundary {
    LOWER(-1, -1),
    HIGHER(1, 0),
    FLOOR(0, -1),
    CEIL(0, 0);

    private final int offsetOfExactMatch;
    private final int offsetOfInsertionPoint;

    private Boundary(int offsetOfExactMatch, int offsetOfInsertionPoint) {
        this.offsetOfExactMatch = offsetOfExactMatch;
        this.offsetOfInsertionPoint = offsetOfInsertionPoint;
    }

    public int apply(int binarySearchOutput) {
        int r = binarySearchOutput;
        if (r >= 0) {
            return r + this.offsetOfExactMatch;
        }
        int ip = -(r + 1);
        return ip + this.offsetOfInsertionPoint;
    }
}

