/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class BuildReference<R> {
    private static final Logger LOGGER = Logger.getLogger(BuildReference.class.getName());
    final String id;
    private volatile Holder<R> holder;

    public BuildReference(String id, R referent) {
        this.id = id;
        this.holder = BuildReference.findHolder(referent);
    }

    @CheckForNull
    public R get() {
        Holder<R> h = this.holder;
        return h != null ? (R)h.get() : null;
    }

    void clear() {
        this.holder = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildReference that = (BuildReference)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        R r = this.get();
        return r != null ? r.toString() : this.id;
    }

    private static <R> Holder<R> findHolder(R referent) {
        if (referent == null) {
            return new DefaultHolderFactory.NoHolder();
        }
        for (HolderFactory f : ExtensionList.lookup(HolderFactory.class)) {
            Holder<R> h = f.make(referent);
            if (h == null) continue;
            LOGGER.log(Level.FINE, "created build reference for {0} using {1}", new Object[]{referent, f});
            return h;
        }
        return new DefaultHolderFactory().make(referent);
    }

    @Extension(ordinal=-Infinity)
    @Restricted(value={NoExternalUse.class})
    public static final class DefaultHolderFactory
    implements HolderFactory {
        public static final String MODE_PROPERTY = "jenkins.model.lazy.BuildReference.MODE";
        private static final String mode = SystemProperties.getString("jenkins.model.lazy.BuildReference.MODE");

        @Override
        public <R> Holder<R> make(R referent) {
            if (mode == null || mode.equals("soft")) {
                return new SoftHolder<R>(referent);
            }
            if (mode.equals("weak")) {
                return new WeakHolder<R>(referent);
            }
            if (mode.equals("strong")) {
                return new StrongHolder<R>(referent);
            }
            if (mode.equals("none")) {
                return new NoHolder();
            }
            throw new IllegalStateException("unrecognized value of jenkins.model.lazy.BuildReference.MODE: " + mode);
        }

        private static final class NoHolder<R>
        implements Holder<R> {
            private NoHolder() {
            }

            @Override
            public R get() {
                return null;
            }
        }

        private static final class StrongHolder<R>
        implements Holder<R> {
            private final R referent;

            StrongHolder(R referent) {
                this.referent = referent;
            }

            @Override
            public R get() {
                return this.referent;
            }
        }

        private static final class WeakHolder<R>
        extends WeakReference<R>
        implements Holder<R> {
            WeakHolder(R referent) {
                super(referent);
            }
        }

        private static final class SoftHolder<R>
        extends SoftReference<R>
        implements Holder<R> {
            SoftHolder(R referent) {
                super(referent);
            }
        }
    }

    public static interface HolderFactory
    extends ExtensionPoint {
        @CheckForNull
        public <R> Holder<R> make(@Nonnull R var1);
    }

    public static interface Holder<R> {
        @CheckForNull
        public R get();
    }
}

