/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UserDetails;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;

public class LastGrantedAuthoritiesProperty
extends UserProperty {
    private volatile String[] roles;
    private long timestamp;
    private static final Logger LOGGER = Logger.getLogger(LastGrantedAuthoritiesProperty.class.getName());

    @Override
    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        req.bindJSON((Object)this, form);
        return this;
    }

    public GrantedAuthority[] getAuthorities() {
        String[] roles = this.roles;
        GrantedAuthority[] r = new GrantedAuthority[roles == null ? 1 : roles.length + 1];
        r[0] = SecurityRealm.AUTHENTICATED_AUTHORITY;
        if (roles != null) {
            for (int i = 1; i < r.length; ++i) {
                r[i] = new GrantedAuthorityImpl(roles[i - 1]);
            }
        }
        return r;
    }

    public void update(@Nonnull Authentication auth) throws IOException {
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority ga : auth.getAuthorities()) {
            roles.add(ga.getAuthority());
        }
        Object[] a = roles.toArray(new String[roles.size()]);
        if (!Arrays.equals(this.roles, a)) {
            this.roles = a;
            this.timestamp = System.currentTimeMillis();
            this.user.save();
        }
    }

    public void invalidate() throws IOException {
        if (this.roles != null) {
            this.roles = null;
            this.timestamp = System.currentTimeMillis();
            this.user.save();
        }
    }

    @Extension
    @Symbol(value={"lastGrantedAuthorities"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public UserProperty newInstance(User user) {
            return null;
        }
    }

    @Extension
    public static class SecurityListenerImpl
    extends SecurityListener {
        @Override
        protected void authenticated(@Nonnull UserDetails details) {
        }

        @Override
        protected void failedToAuthenticate(@Nonnull String username) {
        }

        @Override
        protected void loggedIn(@Nonnull String username) {
            try {
                Authentication a;
                User u = User.getById(username, true);
                LastGrantedAuthoritiesProperty o = u.getProperty(LastGrantedAuthoritiesProperty.class);
                if (o == null) {
                    o = new LastGrantedAuthoritiesProperty();
                    u.addProperty(o);
                }
                if ((a = Jenkins.getAuthentication()) != null && a.getName().equals(username)) {
                    o.update(a);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to record granted authorities", e);
            }
        }

        @Override
        protected void failedToLogIn(@Nonnull String username) {
        }

        @Override
        protected void loggedOut(@Nonnull String username) {
        }
    }
}

