/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Queue;
import java.util.Calendar;
import java.util.Collections;
import javax.annotation.CheckForNull;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import org.acegisecurity.Authentication;

public abstract class QueueItemAuthenticator
extends AbstractDescribableImpl<QueueItemAuthenticator>
implements ExtensionPoint {
    @CheckForNull
    public Authentication authenticate(Queue.Item item) {
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Task.class)) {
            return this.authenticate(item.task);
        }
        throw new AbstractMethodError("you must override at least one of the QueueItemAuthenticator.authenticate methods");
    }

    @CheckForNull
    public Authentication authenticate(Queue.Task task) {
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Item.class)) {
            return this.authenticate(new Queue.WaitingItem(Calendar.getInstance(), task, Collections.emptyList()));
        }
        throw new AbstractMethodError("you must override at least one of the QueueItemAuthenticator.authenticate methods");
    }

    public QueueItemAuthenticatorDescriptor getDescriptor() {
        return (QueueItemAuthenticatorDescriptor)super.getDescriptor();
    }
}

