/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.apache.commons.beanutils.Converter;

public class TimeDuration {
    private final long millis;

    public TimeDuration(long millis) {
        this.millis = millis;
    }

    public int getTime() {
        return (int)this.millis;
    }

    public long getTimeInMillis() {
        return this.millis;
    }

    public long as(TimeUnit t) {
        return t.convert(this.millis, TimeUnit.MILLISECONDS);
    }

    @CheckForNull
    public static TimeDuration fromString(@CheckForNull String delay) {
        if (delay == null) {
            return null;
        }
        try {
            if (delay.endsWith("sec")) {
                delay = delay.substring(0, delay.length() - 3);
            }
            if (delay.endsWith("secs")) {
                delay = delay.substring(0, delay.length() - 4);
            }
            return new TimeDuration(Long.parseLong(delay));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid time duration value: " + delay);
        }
    }

    public static class StaplerConverterImpl
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return TimeDuration.fromString((String)value);
            }
            throw new UnsupportedOperationException();
        }
    }
}

