/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.slave_installer.impl;

import hudson.FilePath;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.Engine;
import hudson.remoting.jnlp.MainDialog;
import hudson.remoting.jnlp.MainMenu;
import hudson.slaves.SlaveComputer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;
import org.jenkinsci.modules.slave_installer.impl.InfiniteProgressPanel;
import org.jenkinsci.modules.slave_installer.impl.JnlpLaunchConfiguration;
import org.jenkinsci.modules.slave_installer.impl.SwingPrompter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerGui
implements Callable<Void, IOException> {
    private final SlaveInstaller installer;
    private final FilePath slaveRoot;
    private final String jnlpMac;
    protected transient Engine engine;
    protected transient MainDialog dialog;
    private static final long serialVersionUID = 1L;
    public static LaunchConfiguration LAUNCH_CONFIG;

    public InstallerGui(SlaveInstaller installer, SlaveComputer sc) {
        this.installer = installer;
        this.slaveRoot = sc.getNode().getRootPath();
        this.jnlpMac = sc.getJnlpMac();
    }

    public InstallerGui(SlaveInstaller installer, FilePath slaveRoot, String jnlpMac) {
        this.installer = installer;
        this.slaveRoot = slaveRoot;
        this.jnlpMac = jnlpMac;
    }

    public Void call() throws IOException {
        this.dialog = MainDialog.get();
        if (this.dialog == null) {
            return null;
        }
        this.engine = Engine.current();
        if (this.engine == null) {
            return null;
        }
        final URL jarUrl = new URL(this.engine.getHudsonUrl(), "jnlpJars/slave.jar");
        final URL jnlpUrl = this.getJnlpUrl();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainMenu mainMenu = InstallerGui.this.dialog.getMainMenu();
                JMenu m = mainMenu.getFileMenu();
                JMenuItem menu = new JMenuItem(InstallerGui.this.installer.getDisplayName());
                final InfiniteProgressPanel glassPane = new InfiniteProgressPanel();
                InstallerGui.this.dialog.setGlassPane((Component)glassPane);
                menu.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        int r = JOptionPane.showConfirmDialog((Component)InstallerGui.this.dialog, InstallerGui.this.installer.getConfirmationText(), InstallerGui.this.installer.getDisplayName(), 2);
                        if (r != 0) {
                            return;
                        }
                        glassPane.start();
                        InstallerGui.this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                        Thread t = new Thread("installer"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    LaunchConfiguration config = LAUNCH_CONFIG;
                                    if (config == null) {
                                        assert (!InstallerGui.this.slaveRoot.isRemote());
                                        config = new JnlpLaunchConfiguration(jarUrl, jnlpUrl, new File(InstallerGui.this.slaveRoot.getRemote()), InstallerGui.this.jnlpMac);
                                    }
                                    InstallerGui.this.installer.install(config, new SwingPrompter());
                                }
                                catch (InstallationException t) {
                                    this.error(t.getMessage());
                                }
                                catch (Throwable t) {
                                    StringWriter sw = new StringWriter();
                                    t.printStackTrace(new PrintWriter(sw));
                                    this.error(sw.toString());
                                }
                                finally {
                                    glassPane.stop();
                                    InstallerGui.this.dialog.setCursor(null);
                                }
                            }

                            private void error(final String msg) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JOptionPane.showMessageDialog((Component)InstallerGui.this.dialog, msg, "Error", 0);
                                    }
                                });
                            }
                        };
                        t.start();
                    }
                });
                m.add(menu);
                mainMenu.commit();
            }
        });
        return null;
    }

    protected URL getJnlpUrl() throws MalformedURLException {
        return new URL(this.engine.getHudsonUrl(), "computer/" + Util.rawEncode((String)this.engine.slaveName) + "/slave-agent.jnlp");
    }
}

