/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.sftp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.FileSystemAware;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpSubsystem
implements Command,
Runnable,
SessionAware,
FileSystemAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 3;
    public static final String ALL_SFTP_IMPL = "3";
    public static final int MAX_PACKET_LENGTH = 16384;
    public static final int SSH_FXP_INIT = 1;
    public static final int SSH_FXP_VERSION = 2;
    public static final int SSH_FXP_OPEN = 3;
    public static final int SSH_FXP_CLOSE = 4;
    public static final int SSH_FXP_READ = 5;
    public static final int SSH_FXP_WRITE = 6;
    public static final int SSH_FXP_LSTAT = 7;
    public static final int SSH_FXP_FSTAT = 8;
    public static final int SSH_FXP_SETSTAT = 9;
    public static final int SSH_FXP_FSETSTAT = 10;
    public static final int SSH_FXP_OPENDIR = 11;
    public static final int SSH_FXP_READDIR = 12;
    public static final int SSH_FXP_REMOVE = 13;
    public static final int SSH_FXP_MKDIR = 14;
    public static final int SSH_FXP_RMDIR = 15;
    public static final int SSH_FXP_REALPATH = 16;
    public static final int SSH_FXP_STAT = 17;
    public static final int SSH_FXP_RENAME = 18;
    public static final int SSH_FXP_READLINK = 19;
    public static final int SSH_FXP_LINK = 21;
    public static final int SSH_FXP_BLOCK = 22;
    public static final int SSH_FXP_UNBLOCK = 23;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FX_INVALID_HANDLE = 9;
    public static final int SSH_FX_NO_SUCH_PATH = 10;
    public static final int SSH_FX_FILE_ALREADY_EXISTS = 11;
    public static final int SSH_FX_WRITE_PROTECT = 12;
    public static final int SSH_FX_NO_MEDIA = 13;
    public static final int SSH_FX_NO_SPACE_ON_FILESYSTEM = 14;
    public static final int SSH_FX_QUOTA_EXCEEDED = 15;
    public static final int SSH_FX_UNKNOWN_PRINCIPAL = 16;
    public static final int SSH_FX_LOCK_CONFLICT = 17;
    public static final int SSH_FX_DIR_NOT_EMPTY = 18;
    public static final int SSH_FX_NOT_A_DIRECTORY = 19;
    public static final int SSH_FX_INVALID_FILENAME = 20;
    public static final int SSH_FX_LINK_LOOP = 21;
    public static final int SSH_FX_CANNOT_DELETE = 22;
    public static final int SSH_FX_INVALID_PARAMETER = 23;
    public static final int SSH_FX_FILE_IS_A_DIRECTORY = 24;
    public static final int SSH_FX_BYTE_RANGE_LOCK_CONFLICT = 25;
    public static final int SSH_FX_BYTE_RANGE_LOCK_REFUSED = 26;
    public static final int SSH_FX_DELETE_PENDING = 27;
    public static final int SSH_FX_FILE_CORRUPT = 28;
    public static final int SSH_FX_OWNER_INVALID = 29;
    public static final int SSH_FX_GROUP_INVALID = 30;
    public static final int SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK = 31;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_ACCESSTIME = 8;
    public static final int SSH_FILEXFER_ATTR_CREATETIME = 16;
    public static final int SSH_FILEXFER_ATTR_MODIFYTIME = 32;
    public static final int SSH_FILEXFER_ATTR_ACL = 64;
    public static final int SSH_FILEXFER_ATTR_OWNERGROUP = 128;
    public static final int SSH_FILEXFER_ATTR_SUBSECOND_TIMES = 256;
    public static final int SSH_FILEXFER_ATTR_BITS = 512;
    public static final int SSH_FILEXFER_ATTR_ALLOCATION_SIZE = 1024;
    public static final int SSH_FILEXFER_ATTR_TEXT_HINT = 2048;
    public static final int SSH_FILEXFER_ATTR_MIME_TYPE = 4096;
    public static final int SSH_FILEXFER_ATTR_LINK_COUNT = 8192;
    public static final int SSH_FILEXFER_ATTR_UNTRANSLATED_NAME = 16384;
    public static final int SSH_FILEXFER_ATTR_CTIME = 32768;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    public static final int SSH_FILEXFER_TYPE_SOCKET = 6;
    public static final int SSH_FILEXFER_TYPE_CHAR_DEVICE = 7;
    public static final int SSH_FILEXFER_TYPE_BLOCK_DEVICE = 8;
    public static final int SSH_FILEXFER_TYPE_FIFO = 9;
    public static final int SSH_FXF_ACCESS_DISPOSITION = 7;
    public static final int SSH_FXF_CREATE_NEW = 0;
    public static final int SSH_FXF_CREATE_TRUNCATE = 1;
    public static final int SSH_FXF_OPEN_EXISTING = 2;
    public static final int SSH_FXF_OPEN_OR_CREATE = 3;
    public static final int SSH_FXF_TRUNCATE_EXISTING = 4;
    public static final int SSH_FXF_APPEND_DATA = 8;
    public static final int SSH_FXF_APPEND_DATA_ATOMIC = 16;
    public static final int SSH_FXF_TEXT_MODE = 32;
    public static final int SSH_FXF_BLOCK_READ = 64;
    public static final int SSH_FXF_BLOCK_WRITE = 128;
    public static final int SSH_FXF_BLOCK_DELETE = 256;
    public static final int SSH_FXF_BLOCK_ADVISORY = 512;
    public static final int SSH_FXF_NOFOLLOW = 1024;
    public static final int SSH_FXF_DELETE_ON_CLOSE = 2048;
    public static final int SSH_FXF_ACCESS_AUDIT_ALARM_INFO = 4096;
    public static final int SSH_FXF_ACCESS_BACKUP = 8192;
    public static final int SSH_FXF_BACKUP_STREAM = 16384;
    public static final int SSH_FXF_OVERRIDE_OWNER = 32768;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    public static final int SSH_FXF_TEXT = 64;
    public static final int ACE4_READ_DATA = 1;
    public static final int ACE4_LIST_DIRECTORY = 1;
    public static final int ACE4_WRITE_DATA = 2;
    public static final int ACE4_ADD_FILE = 2;
    public static final int ACE4_APPEND_DATA = 4;
    public static final int ACE4_ADD_SUBDIRECTORY = 4;
    public static final int ACE4_READ_NAMED_ATTRS = 8;
    public static final int ACE4_WRITE_NAMED_ATTRS = 16;
    public static final int ACE4_EXECUTE = 32;
    public static final int ACE4_DELETE_CHILD = 64;
    public static final int ACE4_READ_ATTRIBUTES = 128;
    public static final int ACE4_WRITE_ATTRIBUTES = 256;
    public static final int ACE4_DELETE = 65536;
    public static final int ACE4_READ_ACL = 131072;
    public static final int ACE4_WRITE_ACL = 262144;
    public static final int ACE4_WRITE_OWNER = 524288;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    private ExitCallback callback;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private Environment env;
    private ServerSession session;
    private boolean closed = false;
    private FileSystemView root;
    private int version;
    private Map<String, Handle> handles = new HashMap<String, Handle>();
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    protected static int mapV4ToV3(int code) {
        switch (code) {
            case 9: {
                return 4;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapV5ToV4(int code) {
        switch (code) {
            case 14: {
                return 4;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapV6ToV5(int code) {
        switch (code) {
            case 18: {
                return 4;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 2;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 3;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 4;
            }
            case 26: {
                return 4;
            }
            case 27: {
                return 4;
            }
            case 28: {
                return 4;
            }
            case 29: {
                return 3;
            }
            case 30: {
                return 3;
            }
            case 31: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapToVersion(int code, int version) {
        int mappedCode = code;
        if (version < 6) {
            mappedCode = SftpSubsystem.mapV6ToV5(mappedCode);
        }
        if (version < 5) {
            mappedCode = SftpSubsystem.mapV5ToV4(mappedCode);
        }
        if (version < 4) {
            mappedCode = SftpSubsystem.mapV4ToV3(mappedCode);
        }
        return mappedCode;
    }

    protected int mapToVersion(int code) {
        return SftpSubsystem.mapToVersion(code, this.version);
    }

    @Override
    public void setSession(ServerSession session) {
        this.session = session;
    }

    @Override
    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void start(Environment env) throws IOException {
        this.env = env;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(this.in);
                while (true) {
                    int l;
                    int length;
                    if ((length = dis.readInt()) < 5) {
                        throw new IllegalArgumentException();
                    }
                    Buffer buffer = new Buffer(length + 4);
                    buffer.putInt(length);
                    for (int nb = length; nb > 0; nb -= l) {
                        l = dis.read(buffer.array(), buffer.wpos(), nb);
                        if (l < 0) {
                            throw new IllegalArgumentException();
                        }
                        buffer.wpos(buffer.wpos() + l);
                    }
                    this.process(buffer);
                }
            }
            catch (Throwable t) {
                if (!this.closed && !(t instanceof EOFException)) {
                    this.log.error("Exception caught in SFTP subsystem", t);
                }
                Object var7_7 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Could not close DataInputStream", (Throwable)ioe);
                    }
                }
                if (this.handles != null) {
                    for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                        Handle handle = entry.getValue();
                        try {
                            handle.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Could not close open handle: " + entry.getKey(), (Throwable)ioe);
                        }
                    }
                }
                dis = null;
                this.callback.onExit(0);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    this.log.error("Could not close DataInputStream", (Throwable)ioe);
                }
            }
            if (this.handles != null) {
                for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                    Handle handle = entry.getValue();
                    try {
                        handle.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Could not close open handle: " + entry.getKey(), (Throwable)ioe);
                    }
                }
            }
            dis = null;
            this.callback.onExit(0);
            throw throwable;
        }
    }

    protected void process(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        switch (type) {
            case 1: {
                if (length != 5) {
                    throw new IllegalArgumentException();
                }
                this.version = id;
                if (this.version >= 3) {
                    this.version = Math.min(this.version, 3);
                    buffer.clear();
                    buffer.putByte((byte)2);
                    buffer.putInt(this.version);
                    this.send(buffer);
                    break;
                }
                this.sendStatus(id, 8, "SFTP server only support versions 3");
                break;
            }
            case 3: {
                String path;
                String maxHandlesString;
                if (this.session.getFactoryManager().getProperties() != null && (maxHandlesString = this.session.getFactoryManager().getProperties().get(MAX_OPEN_HANDLES_PER_SESSION)) != null) {
                    int maxHandleCount = Integer.parseInt(maxHandlesString);
                    if (this.handles.size() > maxHandleCount) {
                        this.sendStatus(id, 4, "Too many open handles");
                        break;
                    }
                }
                if (this.version <= 4) {
                    path = buffer.getString();
                    int pflags = buffer.getInt();
                    try {
                        SshFile file = this.resolveFile(path);
                        if (file.doesExist()) {
                            if ((pflags & 8) != 0 && (pflags & 0x20) != 0) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                        } else if ((pflags & 8) != 0) {
                            if (!file.isWritable()) {
                                this.sendStatus(id, 3, "Can not create " + path);
                                return;
                            }
                            file.create();
                        }
                        String acc = ((pflags & 3) != 0 ? "r" : "") + ((pflags & 2) != 0 ? "w" : "");
                        if ((pflags & 0x10) != 0) {
                            file.truncate();
                        }
                        String handle = UUID.randomUUID().toString();
                        this.handles.put(handle, new FileHandle(file, pflags));
                        this.sendHandle(id, handle);
                    }
                    catch (IOException e) {
                        this.sendStatus(id, 4, e.getMessage());
                    }
                    break;
                }
                path = buffer.getString();
                int acc = buffer.getInt();
                int flags = buffer.getInt();
                try {
                    SshFile file = this.resolveFile(path);
                    switch (flags & 7) {
                        case 0: {
                            if (file.doesExist()) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                            if (!file.isWritable()) {
                                this.sendStatus(id, 3, "Can not create " + path);
                            }
                            file.create();
                            break;
                        }
                        case 1: {
                            if (file.doesExist()) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                            if (!file.isWritable()) {
                                this.sendStatus(id, 3, "Can not create " + path);
                            }
                            file.truncate();
                            break;
                        }
                        case 2: {
                            if (file.doesExist()) break;
                            if (!file.getParentFile().doesExist()) {
                                this.sendStatus(id, 10, path);
                            } else {
                                this.sendStatus(id, 2, path);
                            }
                            return;
                        }
                        case 3: {
                            if (file.doesExist()) break;
                            file.create();
                            break;
                        }
                        case 4: {
                            if (!file.doesExist()) {
                                if (!file.getParentFile().doesExist()) {
                                    this.sendStatus(id, 10, path);
                                } else {
                                    this.sendStatus(id, 2, path);
                                }
                                return;
                            }
                            file.truncate();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported open mode: " + flags);
                        }
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new FileHandle(file, flags));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 4: {
                String handle = buffer.getString();
                try {
                    Handle h = this.handles.get(handle);
                    if (h == null) {
                        this.sendStatus(id, 9, handle, "");
                        break;
                    }
                    this.handles.remove(handle);
                    h.close();
                    this.sendStatus(id, 0, "", "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 5: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                int len = buffer.getInt();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    FileHandle fh = (FileHandle)p;
                    byte[] b = new byte[Math.min(len, 32768)];
                    if ((len = fh.read(b, offset)) >= 0) {
                        Buffer buf = new Buffer(len + 5);
                        buf.putByte((byte)103);
                        buf.putInt(id);
                        buf.putBytes(b, 0, len);
                        if (this.version >= 6) {
                            buf.putBoolean(len == 0);
                        }
                        this.send(buf);
                        break;
                    }
                    this.sendStatus(id, 1, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 6: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                byte[] data = buffer.getBytes();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    FileHandle fh = (FileHandle)p;
                    fh.write(data, offset);
                    SshFile sshFile = fh.getFile();
                    sshFile.setLastModified(new Date().getTime());
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 7: 
            case 17: {
                String path = buffer.getString();
                try {
                    SshFile p = this.resolveFile(path);
                    this.sendAttrs(id, p);
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 8: {
                String handle = buffer.getString();
                try {
                    Handle p = this.handles.get(handle);
                    if (p == null) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    this.sendAttrs(id, p.getFile());
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 11: {
                String path = buffer.getString();
                try {
                    SshFile p = this.resolveFile(path);
                    if (!p.doesExist()) {
                        this.sendStatus(id, 2, path);
                        break;
                    }
                    if (!p.isDirectory()) {
                        this.sendStatus(id, 19, path);
                        break;
                    }
                    if (!p.isReadable()) {
                        this.sendStatus(id, 3, path);
                        break;
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new DirectoryHandle(p));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 12: {
                String handle = buffer.getString();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof DirectoryHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    if (((DirectoryHandle)p).isDone()) {
                        this.sendStatus(id, 1, "", "");
                        break;
                    }
                    if (!p.getFile().doesExist()) {
                        this.sendStatus(id, 2, p.getFile().getAbsolutePath());
                        break;
                    }
                    if (!p.getFile().isDirectory()) {
                        this.sendStatus(id, 19, p.getFile().getAbsolutePath());
                        break;
                    }
                    if (!p.getFile().isReadable()) {
                        this.sendStatus(id, 3, p.getFile().getAbsolutePath());
                        break;
                    }
                    DirectoryHandle dh = (DirectoryHandle)p;
                    if (dh.hasNext()) {
                        this.sendName(id, dh);
                        if (dh.hasNext()) break;
                        dh.setDone(true);
                        dh.clearFileList();
                        break;
                    }
                    dh.setDone(true);
                    dh.clearFileList();
                    this.sendStatus(id, 1, "", "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 13: {
                String path = buffer.getString();
                try {
                    SshFile p = this.resolveFile(path);
                    if (!p.doesExist()) {
                        this.sendStatus(id, 2, p.getAbsolutePath());
                        break;
                    }
                    if (p.isDirectory()) {
                        this.sendStatus(id, 24, p.getAbsolutePath());
                        break;
                    }
                    if (!p.delete()) {
                        this.sendStatus(id, 4, "Failed to delete file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 14: {
                String path = buffer.getString();
                try {
                    SshFile p = this.resolveFile(path);
                    if (p.doesExist()) {
                        if (p.isDirectory()) {
                            this.sendStatus(id, 11, p.getAbsolutePath());
                            break;
                        }
                        this.sendStatus(id, 19, p.getAbsolutePath());
                        break;
                    }
                    if (!p.isWritable()) {
                        this.sendStatus(id, 3, p.getAbsolutePath());
                        break;
                    }
                    if (!p.mkdir()) {
                        throw new IOException("Error creating dir " + path);
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 15: {
                String path = buffer.getString();
                try {
                    SshFile p = this.resolveFile(path);
                    if (p.isDirectory()) {
                        if (p.doesExist()) {
                            if (p.listSshFiles().size() == 0) {
                                if (p.delete()) {
                                    this.sendStatus(id, 0, "");
                                    break;
                                }
                                this.sendStatus(id, 4, "Unable to delete directory " + path);
                                break;
                            }
                            this.sendStatus(id, 18, path);
                            break;
                        }
                        this.sendStatus(id, 10, path);
                        break;
                    }
                    this.sendStatus(id, 19, p.getAbsolutePath());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 16: {
                String path = buffer.getString();
                if (path.trim().length() == 0) {
                    path = ".";
                }
                try {
                    SshFile p = this.resolveFile(path);
                    this.sendPath(id, p);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 18: {
                String oldPath = buffer.getString();
                String newPath = buffer.getString();
                try {
                    SshFile o = this.resolveFile(oldPath);
                    SshFile n = this.resolveFile(newPath);
                    if (!o.doesExist()) {
                        this.sendStatus(id, 2, o.getAbsolutePath());
                        break;
                    }
                    if (n.doesExist()) {
                        this.sendStatus(id, 11, n.getAbsolutePath());
                        break;
                    }
                    if (!o.move(n)) {
                        this.sendStatus(id, 4, "Failed to rename file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 9: 
            case 10: {
                this.sendStatus(id, 0, "");
                break;
            }
            default: {
                this.log.error("Received: {}", (Object)type);
                this.sendStatus(id, 8, "Command " + type + " is unsupported or not implemented");
            }
        }
    }

    protected void sendHandle(int id, String handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(int id, SshFile file) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, file);
        this.send(buffer);
    }

    protected void sendAttrs(int id, SshFile file, int flags) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, file, flags);
        this.send(buffer);
    }

    protected void sendPath(int id, SshFile f) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        String normalizedPath = SelectorUtils.normalizePath(f.getAbsolutePath(), "/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        buffer.putString(normalizedPath);
        f = this.resolveFile(normalizedPath);
        if (f.getName().length() == 0) {
            f = this.resolveFile(".");
        }
        if (this.version <= 3) {
            buffer.putString(this.getLongName(f));
            buffer.putInt(0L);
        } else {
            buffer.putString(f.getName());
            this.writeAttrs(buffer, f);
        }
        this.send(buffer);
    }

    protected void sendName(int id, Iterator<SshFile> files) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        int wpos = buffer.wpos();
        buffer.putInt(0L);
        int nb = 0;
        while (files.hasNext() && buffer.wpos() < 16384) {
            SshFile f = files.next();
            buffer.putString(f.getName());
            if (this.version <= 3) {
                buffer.putString(this.getLongName(f));
            } else {
                buffer.putString(f.getName());
            }
            this.writeAttrs(buffer, f);
            ++nb;
        }
        int oldpos = buffer.wpos();
        buffer.wpos(wpos);
        buffer.putInt(nb);
        buffer.wpos(oldpos);
        this.send(buffer);
    }

    private String getLongName(SshFile f) {
        String username = f.getOwner();
        if (username.length() > 8) {
            username = username.substring(0, 8);
        } else {
            for (int i = username.length(); i < 8; ++i) {
                username = username + " ";
            }
        }
        long length = f.getSize();
        String lengthString = String.format("%1$8s", length);
        StringBuilder sb = new StringBuilder();
        sb.append(f.isDirectory() ? "d" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(" ");
        sb.append("  1");
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(lengthString);
        sb.append(" ");
        sb.append(SftpSubsystem.getUnixDate(f.getLastModified()));
        sb.append(" ");
        sb.append(f.getName());
        return sb.toString();
    }

    protected void writeAttrs(Buffer buffer, SshFile file) throws IOException {
        this.writeAttrs(buffer, file, 0);
    }

    protected void writeAttrs(Buffer buffer, SshFile file, int flags) throws IOException {
        if (!file.doesExist()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (this.version >= 4) {
            long size = file.getSize();
            String username = this.session.getUsername();
            long lastModif = file.getLastModified();
            int p = 0;
            if (file.isReadable()) {
                p |= 0x100;
            }
            if (file.isWritable()) {
                p |= 0x80;
            }
            if (file.isExecutable()) {
                p |= 0x40;
            }
            if (file.isFile()) {
                buffer.putInt(4L);
                buffer.putByte((byte)1);
                buffer.putInt(p);
            } else if (file.isDirectory()) {
                buffer.putInt(4L);
                buffer.putByte((byte)2);
                buffer.putInt(p);
            } else {
                buffer.putInt(0L);
                buffer.putByte((byte)5);
            }
        } else {
            int p = 0;
            if (file.isFile()) {
                p |= 0x8000;
            }
            if (file.isDirectory()) {
                p |= 0x4000;
            }
            if (file.isReadable()) {
                p |= 0x100;
            }
            if (file.isWritable()) {
                p |= 0x80;
            }
            if (file.isExecutable()) {
                p |= 0x40;
            }
            if (file.isFile()) {
                buffer.putInt(13L);
                buffer.putLong(file.getSize());
                buffer.putInt(p);
                buffer.putInt(file.getLastModified() / 1000L);
                buffer.putInt(file.getLastModified() / 1000L);
            } else if (file.isDirectory()) {
                buffer.putInt(12L);
                buffer.putInt(p);
                buffer.putInt(file.getLastModified() / 1000L);
                buffer.putInt(file.getLastModified() / 1000L);
            } else {
                buffer.putInt(0L);
            }
        }
    }

    protected void sendStatus(int id, int substatus, String msg) throws IOException {
        this.sendStatus(id, this.mapToVersion(substatus), msg, "");
    }

    protected void sendStatus(int id, int substatus, String msg, String lang) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected void send(Buffer buffer) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.out);
        dos.writeInt(buffer.available());
        dos.write(buffer.array(), buffer.rpos(), buffer.available());
        dos.flush();
    }

    @Override
    public void destroy() {
        this.closed = true;
    }

    private SshFile resolveFile(String path) {
        return this.root.getFile(path);
    }

    private static final String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuffer sb = new StringBuffer(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        int day = cal.get(5);
        if (day < 10) {
            sb.append(' ');
        }
        sb.append(day);
        sb.append(' ');
        long sixMonth = 15811200000L;
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > sixMonth) {
            int year = cal.get(1);
            sb.append(' ');
            sb.append(year);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm = cal.get(12);
            if (mm < 10) {
                sb.append('0');
            }
            sb.append(mm);
        }
        return sb.toString();
    }

    protected static class FileHandle
    extends Handle {
        int flags;
        OutputStream output;
        long outputPos;
        InputStream input;
        long inputPos;

        public FileHandle(SshFile sshFile, int flags) {
            super(sshFile);
            this.flags = flags;
        }

        public int getFlags() {
            return this.flags;
        }

        public int read(byte[] data, long offset) throws IOException {
            if (this.input != null && offset != this.inputPos) {
                IoUtils.closeQuietly(this.input);
                this.input = null;
            }
            if (this.input == null) {
                this.input = this.file.createInputStream(offset);
                this.inputPos = offset;
            }
            int read = this.input.read(data);
            this.inputPos += (long)read;
            return read;
        }

        public void write(byte[] data, long offset) throws IOException {
            if (this.output != null && offset != this.outputPos) {
                IoUtils.closeQuietly(this.output);
                this.output = null;
            }
            if (this.output == null) {
                this.output = this.file.createOutputStream(offset);
            }
            this.output.write(data);
            this.outputPos += (long)data.length;
        }

        public void close() throws IOException {
            IoUtils.closeQuietly(this.output, this.input);
            this.output = null;
            this.input = null;
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DirectoryHandle
    extends Handle
    implements Iterator<SshFile> {
        boolean done;
        List<SshFile> fileList = null;
        int fileIndex;

        public DirectoryHandle(SshFile file) {
            super(file);
            this.fileList = file.listSshFiles();
            this.fileIndex = 0;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        @Override
        public boolean hasNext() {
            return this.fileIndex < this.fileList.size();
        }

        @Override
        public SshFile next() {
            SshFile f = this.fileList.get(this.fileIndex);
            ++this.fileIndex;
            return f;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void clearFileList() {
            this.fileList = null;
        }
    }

    protected static abstract class Handle {
        SshFile file;

        public Handle(SshFile file) {
            this.file = file;
        }

        public SshFile getFile() {
            return this.file;
        }

        public void close() throws IOException {
            this.file.handleClose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Command> {
        @Override
        public Command create() {
            return new SftpSubsystem();
        }

        @Override
        public String getName() {
            return "sftp";
        }
    }
}

