/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris;

import com.sun.solaris.SuAuthenticationFailureException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedSu {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedSu.class.getName());

    private EmbeddedSu() {
    }

    public static Process startWithSu(String user, String pwd, ProcessBuilder pb) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder("exec ");
        for (String cmd : pb.command()) {
            buf.append(' ');
            buf.append('\'').append(cmd.replaceAll("'", "'''")).append('\'');
        }
        List<String> cmds = pb.command();
        cmds.clear();
        cmds.addAll(Arrays.asList("/usr/lib/embedded_su", user, "-c", buf.toString()));
        Process proc = pb.start();
        PrintWriter out = new PrintWriter(proc.getOutputStream(), true);
        InputStream in = proc.getInputStream();
        LOGGER.fine("Initiating embedded_su conversation");
        out.println(".");
        ArrayList<String> errorMessages = new ArrayList<String>();
        while ((line = EmbeddedSu.readLine(in)).startsWith("CONV")) {
            int n = Integer.parseInt(line.substring(5));
            for (int i = 0; i < n; ++i) {
                String header = EmbeddedSu.readLine(in);
                String textBlock = EmbeddedSu.readTextBlock(in);
                LOGGER.fine("Got " + header + " : " + textBlock);
                if (header.startsWith("PAM_PROMPT_ECHO_OFF")) {
                    out.println(pwd);
                    pwd = null;
                }
                if (header.startsWith("PAM_PROMPT_ECHO_ON")) {
                    out.println();
                }
                if (!header.startsWith("PAM_ERROR_MSG")) continue;
                errorMessages.add(textBlock);
            }
        }
        if (line.startsWith("SUCCESS")) {
            LOGGER.fine("Authentication successful: " + line);
            return proc;
        }
        if (line.startsWith("ERROR")) {
            LOGGER.fine("Authentication faied: " + line);
            throw new SuAuthenticationFailureException(EmbeddedSu.readTextBlock(in) + EmbeddedSu.join(errorMessages));
        }
        LOGGER.fine("Unrecognized response: " + line);
        throw new IOException("Unrecognized response from embedded_su " + line);
    }

    private static String join(Collection<String> col) {
        StringBuilder buf = new StringBuilder();
        for (String a : col) {
            buf.append(a);
        }
        return buf.toString();
    }

    private static String readLine(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            if (ch == 10) {
                return buf.toString();
            }
            buf.write(ch);
        }
        throw new EOFException();
    }

    private static String readTextBlock(InputStream in) throws IOException {
        StringBuilder buf = new StringBuilder();
        String line;
        while (!(line = EmbeddedSu.readLine(in)).equals(".")) {
            if (line.startsWith("..")) {
                buf.append(line.substring(1));
            } else {
                buf.append(line);
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

