/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Optional;
import org.kohsuke.stapler.ScriptLoadException;

public abstract class CachingScriptLoader<S, E extends Exception> {
    private final LoadingCache<String, Optional<S>> scripts = CacheBuilder.newBuilder().softValues().build(new CacheLoader<String, Optional<S>>(){

        public Optional<S> load(String from) {
            try {
                return Optional.create(CachingScriptLoader.this.loadScript(from));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScriptLoadException(e);
            }
        }
    });

    public S findScript(String name) throws E {
        if (MetaClass.NO_CACHE) {
            return this.loadScript(name);
        }
        return (S)((Optional)this.scripts.getUnchecked((Object)name)).get();
    }

    protected abstract S loadScript(String var1) throws E;

    public synchronized void clearScripts() {
        this.scripts.invalidateAll();
    }

    protected abstract URL getResource(String var1);
}

