/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.IndexDispatcher;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.NameBasedDispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.SingleLinkedList;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.TearOffSupport;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.MethodRef;

public class MetaClass
extends TearOffSupport {
    public final Class clazz;
    public final Klass<?> klass;
    public final MetaClassLoader classLoader;
    public final List<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
    public final MetaClass baseClass;
    public final WebApp webApp;
    private volatile SingleLinkedList<MethodRef> postConstructMethods;
    public static boolean NO_CACHE = false;
    private static final Object NONE;

    MetaClass(WebApp webApp, Klass<?> klass) {
        this.clazz = klass.toJavaClass();
        this.klass = klass;
        this.webApp = webApp;
        this.baseClass = webApp.getMetaClass(klass.getSuperClass());
        this.classLoader = MetaClassLoader.get(this.clazz.getClassLoader());
        this.buildDispatchers();
    }

    void buildDispatchers() {
        String name;
        String[] names;
        Annotation a;
        this.dispatchers.clear();
        ClassDescriptor node = new ClassDescriptor(this.clazz, null);
        for (final Function function : node.methods.webMethods()) {
            a = function.getAnnotation(WebMethod.class);
            names = a != null && a.name().length > 0 ? a.name() : new String[]{MetaClass.camelize(function.getName().substring(2))};
            for (String name2 : names) {
                if (name2.length() == 0) {
                    this.dispatchers.add(new IndexDispatcher(function));
                    continue;
                }
                this.dispatchers.add(new NameBasedDispatcher(name2){

                    @Override
                    public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                        if (1.traceable()) {
                            1.trace(req, rsp, "-> <%s>.%s(...)", node, function.getName());
                        }
                        return function.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                    }

                    @Override
                    public String toString() {
                        return function.getQualifiedName() + "(...) for url=/" + this.name + "/...";
                    }
                });
            }
        }
        for (Function function : node.methods.prefix("js")) {
            String name3 = MetaClass.camelize(function.getName().substring(2));
            this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name3, function));
        }
        for (Function function : node.methods.annotated(JavaScriptMethod.class)) {
            a = function.getAnnotation(JavaScriptMethod.class);
            names = a != null && a.name().length > 0 ? a.name() : new String[]{function.getName()};
            for (String name2 : names) {
                this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name2, function));
            }
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildViewDispatchers(this, this.dispatchers);
        }
        for (Function function : node.methods.name("doIndex")) {
            this.dispatchers.add(new IndexDispatcher(function));
        }
        for (final Field f : node.fields) {
            this.dispatchers.add(new NameBasedDispatcher(f.getName()){
                final String role;
                {
                    super(x0);
                    this.role = MetaClass.this.getProtectedRole(f);
                }

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException {
                    if (this.role != null && !req.isUserInRole(this.role)) {
                        throw new IllegalAccessException("Needs to be in role " + this.role);
                    }
                    if (2.traceable()) {
                        2.traceEval(req, rsp, node, f.getName());
                    }
                    req.getStapler().invoke(req, rsp, f.get(node));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s.%2$s for url=/%2$s/...", f.getDeclaringClass().getName(), f.getName());
                }
            });
        }
        FunctionList getMethods = node.methods.prefix("get");
        for (final Function f : getMethods.signature(new Class[0])) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (3.traceable()) {
                        3.traceEval(req, rsp, node, f.getName() + "()");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, rsp, node, new Object[0]));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s() for url=/%2$s/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(StaplerRequest.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (4.traceable()) {
                        4.traceEval(req, rsp, node, f.getName() + "(...)");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, rsp, node, req));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(StaplerRequest) for url=/%2$s/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(String.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    String token = req.tokens.next();
                    if (5.traceable()) {
                        5.traceEval(req, rsp, node, f.getName() + "(\"" + token + "\")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, rsp, node, token));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(String) for url=/%2$s/TOKEN/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(Integer.TYPE)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    int idx = req.tokens.nextAsInt();
                    if (6.traceable()) {
                        6.traceEval(req, rsp, node, f.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, rsp, node, idx));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(int) for url=/%2$s/N/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(Long.TYPE)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    long idx = req.tokens.nextAsLong();
                    if (7.traceable()) {
                        7.traceEval(req, rsp, node, f.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, rsp, node, idx));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(long) for url=/%2$s/N/...", f.getQualifiedName(), this.name);
                }
            });
        }
        if (node.clazz.isArray()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (8.traceable()) {
                            8.traceEval(req, rsp, node, "((Object[])", ")[" + index + "]");
                        }
                        req.getStapler().invoke(req, rsp, ((Object[])node)[index]);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Array look-up for url=/N/...";
                }
            });
        }
        if (List.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (9.traceable()) {
                            9.traceEval(req, rsp, node, "((List)", ").get(" + index + ")");
                        }
                        List list = (List)node;
                        if (0 <= index && index < list.size()) {
                            req.getStapler().invoke(req, rsp, list.get(index));
                        } else {
                            if (9.traceable()) {
                                9.trace(req, rsp, "-> IndexOutOfRange [0,%d)", list.size());
                            }
                            rsp.sendError(404);
                        }
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "List.get(int) look-up for url=/N/...";
                }
            });
        }
        if (Map.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        Object item;
                        String key = req.tokens.peek();
                        if (10.traceable()) {
                            10.traceEval(req, rsp, "((Map)", ").get(\"" + key + "\")");
                        }
                        if ((item = ((Map)node).get(key)) != null) {
                            req.tokens.next();
                            req.getStapler().invoke(req, rsp, item);
                            return true;
                        }
                        if (10.traceable()) {
                            10.trace(req, rsp, "Map.get(\"" + key + "\")==null. Back tracking.");
                        }
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Map.get(String) look-up for url=/TOKEN/...";
                }
            });
        }
        for (Facet f : this.webApp.facets) {
            f.buildFallbackDispatchers(this, this.dispatchers);
        }
        for (final Function f : getMethods.signatureStartsWith(String.class).name("getDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, IOException, ServletException {
                    Object target;
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    String token = req.tokens.next();
                    if (11.traceable()) {
                        11.traceEval(req, rsp, node, "getDynamic(\"" + token + "\",...)");
                    }
                    if ((target = f.bindAndInvoke(node, req, rsp, token)) != null) {
                        req.getStapler().invoke(req, rsp, target);
                        return true;
                    }
                    if (11.traceable()) {
                        11.trace(req, rsp, "            %s.getDynamic(\"%s\",...)==null. Back tracking.", node, token);
                    }
                    req.tokens.prev();
                    return false;
                }

                @Override
                public String toString() {
                    return String.format("%s(String,StaplerRequest,StaplerResponse) for url=/TOKEN/...", f.getQualifiedName());
                }
            });
        }
        for (final Function f : node.methods.name("doDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                    if (12.traceable()) {
                        12.trace(req, rsp, "-> <%s>.doDynamic(...)", node);
                    }
                    return f.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                }

                @Override
                public String toString() {
                    return String.format("%s(StaplerRequest,StaplerResponse) for any URL", f.getQualifiedName());
                }
            });
        }
    }

    public SingleLinkedList<MethodRef> getPostConstructMethods() {
        if (this.postConstructMethods == null) {
            SingleLinkedList<MethodRef> l = this.baseClass == null ? SingleLinkedList.empty() : this.baseClass.getPostConstructMethods();
            for (MethodRef mr : this.klass.getDeclaredMethods()) {
                if (!mr.hasAnnotation(PostConstruct.class)) continue;
                l = l.grow(mr);
            }
            this.postConstructMethods = l;
        }
        return this.postConstructMethods;
    }

    private String getProtectedRole(Field f) {
        try {
            LimitedTo a = f.getAnnotation(LimitedTo.class);
            return a != null ? a.value() : null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        try {
            NO_CACHE = Boolean.getBoolean("stapler.jelly.noCache");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        NONE = "none";
    }

    private static class JavaScriptProxyMethodDispatcher
    extends NameBasedDispatcher {
        private final Function f;

        public JavaScriptProxyMethodDispatcher(String name, Function f) {
            super(name, 0);
            this.f = f;
        }

        @Override
        public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
            if (!req.isJavaScriptProxyCall()) {
                return false;
            }
            req.stapler.getWebApp().getCrumbIssuer().validateCrumb(req, req.getHeader("Crumb"));
            if (JavaScriptProxyMethodDispatcher.traceable()) {
                JavaScriptProxyMethodDispatcher.trace(req, rsp, "-> <%s>.%s(...)", node, this.f.getName());
            }
            JSONArray jsargs = JSONArray.fromObject((Object)IOUtils.toString((Reader)req.getReader()));
            Object[] args = new Object[jsargs.size()];
            Class[] types = this.f.getParameterTypes();
            Object[] genericTypes = this.f.getGenericParameterTypes();
            if (args.length != types.length) {
                throw new IllegalArgumentException("argument count mismatch between " + jsargs + " and " + Arrays.toString(genericTypes));
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = req.bindJSON(genericTypes[i], types[i], jsargs.get(i));
            }
            return this.f.bindAndInvokeAndServeResponse(node, req, rsp, args);
        }

        @Override
        public String toString() {
            return this.f.getQualifiedName() + "(...) for url=/" + this.name + "/...";
        }
    }
}

