/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.json;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class JsonHttpResponse
extends HttpResponses.HttpResponseException {
    @Nullable
    private final JSONObject responseJson;
    private final int status;

    public JsonHttpResponse(JSONObject o) {
        this(o, o == null ? 204 : 200);
    }

    public JsonHttpResponse(JSONObject o, int status) {
        this.responseJson = o;
        this.status = status;
    }

    public JsonHttpResponse(Throwable t, int status) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        this.responseJson = new JSONObject().element("error", (Object)(t.getClass().getName() + ": " + t.getMessage())).element("stackTrace", (Object)sw.toString());
        this.status = status;
    }

    @Override
    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        if (this.status > 0) {
            rsp.setStatus(this.status);
        }
        if (this.responseJson != null) {
            rsp.setContentType("application/json;charset=UTF-8");
            this.responseJson.write(rsp.getCompressedWriter(req));
        }
    }
}

