/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.forward;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.forward.CopyThread;
import hudson.remoting.forward.Forwarder;
import hudson.remoting.forward.ListeningPort;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class PortForwarder
extends Thread
implements Closeable,
ListeningPort {
    private final Forwarder forwarder;
    private final ServerSocket socket;
    private static final Logger LOGGER = Logger.getLogger(PortForwarder.class.getName());
    public static final Role ROLE = new Role(PortForwarder.class);

    public PortForwarder(int localPort, Forwarder forwarder) throws IOException {
        super(String.format("Port forwarder %d", localPort));
        this.forwarder = forwarder;
        this.socket = new ServerSocket(localPort);
        this.setDaemon(true);
    }

    @Override
    public int getPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void run() {
        try {
            try {
                while (true) {
                    final Socket s = this.socket.accept();
                    new Thread("Port forwarding session from " + s.getRemoteSocketAddress()){

                        @Override
                        public void run() {
                            try {
                                OutputStream out = PortForwarder.this.forwarder.connect(new RemoteOutputStream(SocketChannelStream.out(s)));
                                new CopyThread("Copier for " + s.getRemoteSocketAddress(), SocketChannelStream.in(s), out).start();
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.FINE, "Port forwarding session was shut down abnormally", e);
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable throwable) {
                this.socket.close();
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Port forwarding was shut down abnormally", e);
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this.interrupt();
        this.socket.close();
    }

    public static ListeningPort create(VirtualChannel ch, final int acceptingPort, Forwarder forwarder) throws IOException, InterruptedException {
        final Forwarder proxy = ch.export(Forwarder.class, forwarder);
        return ch.call(new Callable<ListeningPort, IOException>(){

            @Override
            public ListeningPort call() throws IOException {
                PortForwarder t = new PortForwarder(acceptingPort, proxy);
                t.start();
                return Channel.current().export(ListeningPort.class, t);
            }

            @Override
            public void checkRoles(RoleChecker checker) throws SecurityException {
                checker.check((RoleSensitive)this, ROLE);
            }
        });
    }
}

