/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.MimicException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

abstract class Command
implements Serializable {
    public final Exception createdAt;
    private static final long serialVersionUID = 1L;

    protected Command() {
        this(true);
    }

    protected Command(Channel channel, Throwable cause) {
        this.createdAt = new Source(MimicException.make(channel, cause));
    }

    protected Command(boolean recordCreatedAt) {
        this.createdAt = recordCreatedAt ? new Source() : null;
    }

    protected abstract void execute(Channel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTo(Channel channel, ObjectOutputStream oos) throws IOException {
        Channel old = Channel.setCurrent(channel);
        try {
            oos.writeObject(this);
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Command readFrom(Channel channel, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel old = Channel.setCurrent(channel);
        try {
            Command command = (Command)ois.readObject();
            return command;
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    private final class Source
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Source() {
        }

        private Source(Throwable cause) {
            super(cause);
        }

        @Override
        public String toString() {
            return "Command " + Command.this.toString() + " created at";
        }
    }
}

