/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlIdentifierMessages;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JpqlCompletionProposalComputer<T> {
    int actualPosition;
    String actualQuery;
    ContentAssistProposals contentAssistProposals;
    String jpqlQuery;
    NamedQuery namedQuery;
    private String partialWord;
    int position;
    JpaJpqlQueryHelper queryHelper;
    int tokenEnd;
    int tokenStart;

    private void addClassNames(List<T> proposals, ResourceManager resourceManager) {
        ContentAssistProposals.ClassType classType = this.contentAssistProposals.getClassType();
        for (String className : this.sort(this.contentAssistProposals.classNames())) {
            proposals.add(this.buildClassNameProposal(className, classType, resourceManager));
        }
    }

    private void addColumnNames(List<T> proposals, ResourceManager resourceManager) {
        for (String columnName : this.sort(this.contentAssistProposals.columnNames())) {
            proposals.add(this.buildColumnNameProposal(columnName, resourceManager));
        }
    }

    private void addEntityNames(List<T> proposals, ResourceManager resourceManager) {
        for (IEntity entity : this.sortByNames(this.contentAssistProposals.abstractSchemaTypes())) {
            proposals.add(this.buildEntityNameProposal(entity, resourceManager));
        }
    }

    private void addEnumConstantNames(List<T> proposals, ResourceManager resourceManager) {
        for (ContentAssistProposals.EnumProposals enumProposal : this.contentAssistProposals.enumConstant()) {
            IType enumType = enumProposal.enumType();
            for (String enumConstant : this.sort(enumProposal.enumConstants())) {
                proposals.add(this.buildEnumConstantNameProposal(enumType, enumConstant, resourceManager));
            }
        }
    }

    private void addIdentificationVariables(List<T> proposals, ResourceManager resourceManager) {
        for (String variable : this.sort(this.contentAssistProposals.identificationVariables())) {
            proposals.add(this.buildIdentificationVariableProposal(variable, resourceManager));
        }
    }

    private void addIdentifiers(List<T> proposals, ResourceManager resourceManager) {
        for (String identifier : this.sort(this.contentAssistProposals.identifiers())) {
            proposals.add(this.buildIdentifierProposal(identifier, resourceManager));
        }
    }

    private String additionalInfo(String proposal) {
        return JpqlIdentifierMessages.localizedMessage(proposal);
    }

    private void addMappings(List<T> proposals, ResourceManager resourceManager) {
        for (IMapping mapping : this.sort(this.contentAssistProposals.mappings())) {
            proposals.add(this.buildMappingProposal(mapping, resourceManager));
        }
    }

    private void addTableNames(List<T> proposals, ResourceManager resourceManager) {
        for (String tableName : this.sort(this.contentAssistProposals.tableNames())) {
            proposals.add(this.buildTableNameProposal(tableName, resourceManager));
        }
    }

    private T buildClassNameProposal(String className, ContentAssistProposals.ClassType type, ResourceManager resourceManager) {
        String displayString = className;
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex > -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(className.substring(dotIndex + 1));
            sb.append(" - ");
            sb.append(className.substring(0, dotIndex));
            displayString = sb.toString();
        }
        Image image = type == ContentAssistProposals.ClassType.INSTANTIABLE ? resourceManager.createImage(JptJpaUiImages.CLASS_REF) : resourceManager.createImage(JptJpaUiImages.ENUM);
        return this.buildProposal(className, displayString, image);
    }

    private T buildColumnNameProposal(String columnName, ResourceManager resourceManager) {
        return this.buildProposal(columnName, columnName, resourceManager.createImage(JptJpaUiImages.COLUMN));
    }

    private Comparator<IEntity> buildEntityNameComparator() {
        return new Comparator<IEntity>(){

            @Override
            public int compare(IEntity entity1, IEntity entity2) {
                return entity1.getName().compareTo(entity2.getName());
            }
        };
    }

    private T buildEntityNameProposal(IEntity entity, ResourceManager resourceManager) {
        String proposal = entity.getName();
        return this.buildProposal(proposal, proposal, resourceManager.createImage(JptJpaUiImages.ENTITY));
    }

    private T buildEnumConstantNameProposal(IType enumType, String enumConstant, ResourceManager resourceManager) {
        StringBuilder sb = new StringBuilder();
        sb.append(enumConstant);
        sb.append(" : ");
        sb.append(enumType.getName());
        return this.buildProposal(enumConstant, sb.toString(), resourceManager.createImage(JptJpaUiImages.ENUM));
    }

    private String buildIdentificationVariableDisplayString(String identificationVariable) {
        IEntity entity = this.contentAssistProposals.getAbstractSchemaType(identificationVariable);
        if (entity != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(identificationVariable);
            sb.append(" : ");
            sb.append(entity.getName());
            identificationVariable = sb.toString();
        }
        return identificationVariable;
    }

    private T buildIdentificationVariableProposal(String proposal, ResourceManager resourceManager) {
        return this.buildProposal(proposal, this.buildIdentificationVariableDisplayString(proposal), resourceManager.createImage(JptJpaUiImages.JPQL_VARIABLE));
    }

    private T buildIdentifierProposal(String proposal, ResourceManager resourceManager) {
        String additionalInfo = this.additionalInfo(proposal);
        IdentifierRole role = this.queryHelper.getQueryContext().getExpressionRegistry().getIdentifierRole(proposal);
        boolean realFunction = role == IdentifierRole.FUNCTION && this.isRealFunction(proposal);
        int cursorOffset = 0;
        if (this.partialWord.length() > 0 && this.shouldMatchFirstCharacterCase()) {
            if (Character.isLowerCase(this.partialWord.charAt(0))) {
                proposal = proposal.toLowerCase();
            }
        } else if (this.shouldUseLowercaseIdentifiers()) {
            proposal = proposal.toLowerCase();
        }
        if (realFunction) {
            proposal = String.valueOf(proposal) + "()";
            --cursorOffset;
        }
        Image image = resourceManager.createImage(realFunction ? JptJpaUiImages.JPQL_FUNCTION : JptJpaUiImages.JPQL_IDENTIFIER);
        return this.buildProposal(proposal, proposal, additionalInfo, image, cursorOffset);
    }

    private T buildMappingProposal(IMapping mapping, ResourceManager resourceManager) {
        String proposal = mapping.getName();
        Image image = resourceManager.createImage(this.mappingImageDescriptor(mapping));
        return this.buildProposal(proposal, proposal, image);
    }

    private T buildProposal(String proposal, String displayString, Image image) {
        return this.buildProposal(proposal, displayString, null, image, 0);
    }

    abstract T buildProposal(String var1, String var2, String var3, Image var4, int var5);

    final List<T> buildProposals(NamedQuery namedQuery, String actualQuery, int tokenStart, int tokenEnd, int position, ResourceManager resourceManager) {
        try {
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
            this.actualQuery = actualQuery;
            this.actualPosition = position;
            this.namedQuery = namedQuery;
            int[] positions = new int[]{position};
            this.jpqlQuery = this.modifyJpqlQuery(actualQuery, positions);
            this.position = positions[0];
            this.partialWord = this.partialWord();
            if (this.queryHelper == null) {
                this.queryHelper = namedQuery.getPersistenceUnit().createJpqlQueryHelper();
            }
            this.queryHelper.setQuery(namedQuery, this.jpqlQuery);
            this.contentAssistProposals = this.queryHelper.buildContentAssistProposals(positions[0]);
            ArrayList proposals = new ArrayList();
            this.addMappings(proposals, resourceManager);
            this.addIdentificationVariables(proposals, resourceManager);
            this.addEntityNames(proposals, resourceManager);
            this.addTableNames(proposals, resourceManager);
            this.addColumnNames(proposals, resourceManager);
            this.addClassNames(proposals, resourceManager);
            this.addEnumConstantNames(proposals, resourceManager);
            this.addIdentifiers(proposals, resourceManager);
            ArrayList arrayList = proposals;
            return arrayList;
        }
        finally {
            if (this.queryHelper != null) {
                this.queryHelper.dispose();
            }
            this.clearInformation();
        }
    }

    private T buildTableNameProposal(String tableName, ResourceManager resourceManager) {
        String proposal = StringTools.delimit((String)tableName, (char)'\'');
        return this.buildProposal(proposal, proposal, resourceManager.createImage(JptJpaUiImages.TABLE));
    }

    final void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    final void clearInformation() {
        this.namedQuery = null;
        this.tokenStart = -1;
        this.tokenEnd = -1;
        this.position = -1;
        this.actualQuery = null;
        this.namedQuery = null;
        this.partialWord = null;
        this.contentAssistProposals = null;
    }

    public String getErrorMessage() {
        return null;
    }

    JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }

    ResourceManager getResourceManager(Control control) {
        return this.getJpaWorkbench().getResourceManager(control);
    }

    private boolean isRealFunction(String identifier) {
        return identifier != "TRUE" && identifier != "FALSE" && identifier != "NULL" && identifier != "CURRENT_DATE" && identifier != "CURRENT_TIME" && identifier != "CURRENT_TIMESTAMP";
    }

    private ImageDescriptor mappingImageDescriptor(IMapping mapping) {
        switch (mapping.getMappingType()) {
            case 1: {
                return JptJpaUiImages.BASIC;
            }
            case 2: {
                return JptJpaUiImages.ELEMENT_COLLECTION;
            }
            case 3: {
                return JptJpaUiImages.EMBEDDED;
            }
            case 4: {
                return JptJpaUiImages.EMBEDDED_ID;
            }
            case 5: {
                return JptJpaUiImages.ID;
            }
            case 6: {
                return JptJpaUiImages.MANY_TO_MANY;
            }
            case 7: {
                return JptJpaUiImages.MANY_TO_ONE;
            }
            case 8: {
                return JptJpaUiImages.ONE_TO_MANY;
            }
            case 9: {
                return JptJpaUiImages.ONE_TO_ONE;
            }
            case 11: {
                return JptJpaUiImages.VERSION;
            }
        }
        return JptJpaUiImages.TRANSIENT;
    }

    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return jpqlQuery;
    }

    private String partialWord() {
        WordParser wordParser = new WordParser((CharSequence)this.jpqlQuery);
        wordParser.setPosition(this.position);
        return wordParser.partialWord();
    }

    public void sessionEnded() {
        this.queryHelper = null;
        this.clearInformation();
    }

    public void sessionStarted() {
    }

    private boolean shouldMatchFirstCharacterCase() {
        return JpaPreferences.getJpqlIdentifierMatchFirstCharacterCase();
    }

    private boolean shouldUseLowercaseIdentifiers() {
        return JpaPreferences.getJpqlIdentifierLowercase();
    }

    private <I extends Comparable<? super I>> Iterable<I> sort(Iterable<I> iterator) {
        return IterableTools.sort(iterator);
    }

    private Iterable<IEntity> sortByNames(Iterable<IEntity> abstractSchemaTypes) {
        return IterableTools.sort(abstractSchemaTypes, this.buildEntityNameComparator());
    }
}

