/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.util.Comparator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObjectWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSchemaWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPTableWrapper
extends DTPDatabaseObjectWrapper<DTPSchemaWrapper, org.eclipse.datatools.modelbase.sql.tables.Table>
implements Table {
    private DTPColumnWrapper[] columns;
    private DTPColumnWrapper[] primaryKeyColumns;
    private DTPForeignKeyWrapper[] foreignKeys;
    private static final DTPColumnWrapper[] EMPTY_COLUMNS = new DTPColumnWrapper[0];
    private static final DTPForeignKeyWrapper[] EMPTY_FOREIGN_KEYS = new DTPForeignKeyWrapper[0];

    DTPTableWrapper(DTPSchemaWrapper schema, org.eclipse.datatools.modelbase.sql.tables.Table dtpTable) {
        super(schema, dtpTable);
    }

    @Override
    public Iterable<Column> getColumns() {
        return IterableTools.iterable((Object[])this.getColumnArray());
    }

    private Iterable<DTPColumnWrapper> getColumnWrappers() {
        return IterableTools.iterable((Object[])this.getColumnArray());
    }

    private synchronized DTPColumnWrapper[] getColumnArray() {
        if (this.columns == null) {
            this.columns = this.buildColumnArray();
        }
        return this.columns;
    }

    private DTPColumnWrapper[] buildColumnArray() {
        List<org.eclipse.datatools.modelbase.sql.tables.Column> dtpColumns = this.getDTPColumns();
        Object[] result = new DTPColumnWrapper[dtpColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPColumnWrapper(this, dtpColumns.get(i));
        }
        return (DTPColumnWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getDTPColumns() {
        return ((org.eclipse.datatools.modelbase.sql.tables.Table)this.dtpObject).getColumns();
    }

    @Override
    public int getColumnsSize() {
        return this.getColumnArray().length;
    }

    @Override
    public DTPColumnWrapper getColumnNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getColumnWrappers(), name);
    }

    DTPColumnWrapper getColumn(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        return this.wraps(dtpColumn.getTable()) ? this.getColumn_(dtpColumn) : this.getSchema().getColumn(dtpColumn);
    }

    DTPColumnWrapper getColumn_(org.eclipse.datatools.modelbase.sql.tables.Column dtpColumn) {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.getColumnArray();
        int n = dTPColumnWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            if (column.wraps(dtpColumn)) {
                return column;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP column: " + dtpColumn);
    }

    @Override
    public Iterable<String> getSortedColumnIdentifiers() {
        return new TransformationIterable(this.getColumnWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public Column getColumnForIdentifier(String identifier) {
        return this.getDTPDriverAdapter().selectColumnForIdentifier(this.getColumns(), identifier);
    }

    @Override
    public Iterable<Column> getPrimaryKeyColumns() {
        return IterableTools.iterable((Object[])this.getPrimaryKeyColumnArray());
    }

    @Override
    public DTPColumnWrapper getPrimaryKeyColumn() {
        DTPColumnWrapper[] pkColumns = this.getPrimaryKeyColumnArray();
        if (pkColumns.length != 1) {
            throw new IllegalStateException("multiple primary key columns: " + pkColumns.length);
        }
        return pkColumns[0];
    }

    private synchronized DTPColumnWrapper[] getPrimaryKeyColumnArray() {
        if (this.primaryKeyColumns == null) {
            this.primaryKeyColumns = this.buildPrimaryKeyColumnArray();
        }
        return this.primaryKeyColumns;
    }

    private DTPColumnWrapper[] buildPrimaryKeyColumnArray() {
        if (!(this.dtpObject instanceof BaseTable)) {
            return EMPTY_COLUMNS;
        }
        PrimaryKey pk = ((BaseTable)this.dtpObject).getPrimaryKey();
        if (pk == null) {
            return EMPTY_COLUMNS;
        }
        List<org.eclipse.datatools.modelbase.sql.tables.Column> pkColumns = this.getColumns(pk);
        DTPColumnWrapper[] result = new DTPColumnWrapper[pkColumns.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = this.getColumn(pkColumns.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.tables.Column> getColumns(PrimaryKey pk) {
        return pk.getMembers();
    }

    @Override
    public int getPrimaryKeyColumnsSize() {
        return this.getPrimaryKeyColumnArray().length;
    }

    boolean primaryKeyColumnsContains(Column column) {
        return ArrayTools.contains((Object[])this.getPrimaryKeyColumnArray(), (Object)column);
    }

    @Override
    public Iterable<ForeignKey> getForeignKeys() {
        return IterableTools.iterable((Object[])this.getForeignKeyArray());
    }

    private synchronized DTPForeignKeyWrapper[] getForeignKeyArray() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.buildForeignKeyArray();
        }
        return this.foreignKeys;
    }

    private DTPForeignKeyWrapper[] buildForeignKeyArray() {
        if (!(this.dtpObject instanceof BaseTable)) {
            return EMPTY_FOREIGN_KEYS;
        }
        List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> dtpForeignKeys = this.getDTPForeignKeys();
        DTPForeignKeyWrapper[] result = new DTPForeignKeyWrapper[dtpForeignKeys.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPForeignKeyWrapper(this, dtpForeignKeys.get(i));
        }
        return result;
    }

    private List<org.eclipse.datatools.modelbase.sql.constraints.ForeignKey> getDTPForeignKeys() {
        return ((BaseTable)this.dtpObject).getForeignKeys();
    }

    @Override
    public int getForeignKeysSize() {
        return this.getForeignKeyArray().length;
    }

    boolean foreignKeyBaseColumnsContains(Column column) {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.getForeignKeyArray();
        int n = dTPForeignKeyWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper fkWrapper = dTPForeignKeyWrapperArray[n2];
            if (fkWrapper.baseColumnsContains(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isPossibleJoinTable() {
        if (this.getForeignKeyArray().length != 2) {
            return false;
        }
        for (Column column : this.getColumns()) {
            if (this.foreignKeyBaseColumnsContains(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ForeignKey getJoinTableOwningForeignKey() {
        DTPForeignKeyWrapper fk0 = this.getForeignKeyArray()[0];
        String name0 = fk0.getReferencedTable().getName();
        DTPForeignKeyWrapper fk1 = this.getForeignKeyArray()[1];
        String name1 = fk1.getReferencedTable().getName();
        return this.getName().equals(String.valueOf(name1) + '_' + name0) ? fk1 : fk0;
    }

    @Override
    public ForeignKey getJoinTableNonOwningForeignKey() {
        DTPForeignKeyWrapper fk0 = this.getForeignKeyArray()[0];
        DTPForeignKeyWrapper fk1 = this.getForeignKeyArray()[1];
        ForeignKey ofk = this.getJoinTableOwningForeignKey();
        return ofk == fk0 ? fk1 : fk0;
    }

    @Override
    public boolean joinTableNameIsDefault() {
        return this.getName().equals(this.buildDefaultJoinTableName());
    }

    private String buildDefaultJoinTableName() {
        return String.valueOf(this.getJoinTableOwningTable().getName()) + '_' + this.getJoinTableNonOwningTable().getName();
    }

    private Table getJoinTableOwningTable() {
        return this.getJoinTableOwningForeignKey().getReferencedTable();
    }

    private Table getJoinTableNonOwningTable() {
        return this.getJoinTableNonOwningForeignKey().getReferencedTable();
    }

    @Override
    public DTPSchemaWrapper getSchema() {
        return (DTPSchemaWrapper)this.parent;
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().tableChanged(this);
    }

    boolean wraps(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.dtpObject == table;
    }

    DTPTableWrapper getTable(org.eclipse.datatools.modelbase.sql.tables.Table table) {
        return this.wraps(table) ? this : this.getSchema().getTable(table);
    }

    @Override
    synchronized void startListening() {
        if (this.foreignKeys != null) {
            this.startForeignKeys();
        }
        if (this.columns != null) {
            this.startColumns();
        }
        super.startListening();
    }

    private void startForeignKeys() {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.startListening();
            ++n2;
        }
    }

    private void startColumns() {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.foreignKeys != null) {
            this.stopForeignKeys();
        }
        if (this.columns != null) {
            this.stopColumns();
        }
        super.stopListening();
    }

    private void stopForeignKeys() {
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.stopListening();
            ++n2;
        }
    }

    private void stopColumns() {
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.foreignKeys != null) {
            this.clearForeignKeys();
        }
        this.primaryKeyColumns = null;
        if (this.columns != null) {
            this.clearColumns();
        }
    }

    private void clearForeignKeys() {
        this.stopForeignKeys();
        DTPForeignKeyWrapper[] dTPForeignKeyWrapperArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            DTPForeignKeyWrapper foreignKey = dTPForeignKeyWrapperArray[n2];
            foreignKey.clear();
            ++n2;
        }
        this.foreignKeys = null;
    }

    private void clearColumns() {
        this.stopColumns();
        DTPColumnWrapper[] dTPColumnWrapperArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            DTPColumnWrapper column = dTPColumnWrapperArray[n2];
            column.clear();
            ++n2;
        }
        this.columns = null;
    }
}

