/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source.EclipseLinkSourceNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.BaseTypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class EclipseLinkSourceBaseTypeConverterAnnotation
extends EclipseLinkSourceNamedConverterAnnotation
implements BaseTypeConverterAnnotation {
    final DeclarationAnnotationElementAdapter<String> dataTypeDeclarationAdapter = this.buildTypeAdapter(this.getDataTypeElementName());
    final AnnotationElementAdapter<String> dataTypeAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.dataTypeDeclarationAdapter);
    String dataType;
    TextRange dataTypeTextRange;
    String fullyQualifiedDataType;
    boolean fqDataTypeStale = true;
    final DeclarationAnnotationElementAdapter<String> objectTypeDeclarationAdapter = this.buildTypeAdapter(this.getObjectTypeElementName());
    final AnnotationElementAdapter<String> objectTypeAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.objectTypeDeclarationAdapter);
    String objectType;
    TextRange objectTypeTextRange;
    String fullyQualifiedObjectType;
    boolean fqObjectTypeStale = true;

    EclipseLinkSourceBaseTypeConverterAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, elementName, TypeStringExpressionConverter.instance());
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.dataType = this.buildDataType(astAnnotation);
        this.dataTypeTextRange = this.buildDataTypeTextRange(astAnnotation);
        this.objectType = this.buildObjectType(astAnnotation);
        this.objectTypeTextRange = this.buildObjectTypeTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncDataType(this.buildDataType(astAnnotation));
        this.dataTypeTextRange = this.buildDataTypeTextRange(astAnnotation);
        this.syncObjectType(this.buildObjectType(astAnnotation));
        this.objectTypeTextRange = this.buildObjectTypeTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.dataType == null && this.objectType == null;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        if (ObjectTools.notEquals((Object)this.dataType, (Object)dataType)) {
            this.dataType = dataType;
            this.fqDataTypeStale = true;
            this.dataTypeAdapter.setValue((Object)dataType);
        }
    }

    private void syncDataType(String astDataType) {
        if (ObjectTools.notEquals((Object)this.dataType, (Object)astDataType)) {
            this.syncDataType_(astDataType);
        }
    }

    private void syncDataType_(String astDataType) {
        String old = this.dataType;
        this.dataType = astDataType;
        this.fqDataTypeStale = true;
        this.firePropertyChanged("dataType", old, astDataType);
    }

    private String buildDataType(Annotation astAnnotation) {
        return (String)this.dataTypeAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getDataTypeTextRange() {
        return this.dataTypeTextRange;
    }

    private TextRange buildDataTypeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.dataTypeDeclarationAdapter, astAnnotation);
    }

    abstract String getDataTypeElementName();

    @Override
    public String getFullyQualifiedDataType() {
        if (this.fqDataTypeStale) {
            this.fullyQualifiedDataType = this.buildFullyQualifiedDataType();
            this.fqDataTypeStale = false;
        }
        return this.fullyQualifiedDataType;
    }

    private String buildFullyQualifiedDataType() {
        return this.dataType == null ? null : this.buildFullyQualifiedDataType_();
    }

    private String buildFullyQualifiedDataType_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.dataTypeAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        if (ObjectTools.notEquals((Object)this.objectType, (Object)objectType)) {
            this.objectType = objectType;
            this.fqObjectTypeStale = true;
            this.objectTypeAdapter.setValue((Object)objectType);
        }
    }

    private void syncObjectType(String astObjectType) {
        if (ObjectTools.notEquals((Object)this.objectType, (Object)astObjectType)) {
            this.syncObjectType_(astObjectType);
        }
    }

    private void syncObjectType_(String astObjectType) {
        String old = this.objectType;
        this.objectType = astObjectType;
        this.fqObjectTypeStale = true;
        this.firePropertyChanged("objectType", old, astObjectType);
    }

    private String buildObjectType(Annotation astAnnotation) {
        return (String)this.objectTypeAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getObjectTypeTextRange() {
        return this.objectTypeTextRange;
    }

    private TextRange buildObjectTypeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.objectTypeDeclarationAdapter, astAnnotation);
    }

    abstract String getObjectTypeElementName();

    @Override
    public String getFullyQualifiedObjectType() {
        if (this.fqObjectTypeStale) {
            this.fullyQualifiedObjectType = this.buildFullyQualifiedObjectType();
            this.fqObjectTypeStale = false;
        }
        return this.fullyQualifiedObjectType;
    }

    private String buildFullyQualifiedObjectType() {
        return this.objectType == null ? null : this.buildFullyQualifiedObjectType_();
    }

    private String buildFullyQualifiedObjectType_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.objectTypeAdapter.getExpression(this.buildASTRoot()));
    }
}

