/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.exception.ExceptionHandlerAdapter;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JptPlugin
implements BundleActivator {
    private volatile Bundle bundle;
    private ExceptionHandler exceptionHandler;
    private ServiceTracker<DebugOptions, DebugOptions> debugOptionsTracker;
    private DebugTrace debugTrace;
    protected static final String RELATIVE_CONTENT_TYPE_SCOPE = "content";
    public static volatile boolean FlushPreferences = true;
    private static final String LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN = "workspace_preferences_overriden";
    private static final String WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN = "workspace_validation_preferences_overridden";
    private static final String PROBLEM = "problem";
    private static final String PROBLEM_ = "problem.";
    private static final String PROBLEM_ERROR = "error";
    private static final String PROBLEM_WARNING = "warning";
    private static final String PROBLEM_INFO = "info";
    private static final String PROBLEM_IGNORE = "ignore";
    private static final PreferenceSeverityMapping[] PREFERENCE_SEVERITY_MAPPINGS = new PreferenceSeverityMapping[]{new PreferenceSeverityMapping("error", 1), new PreferenceSeverityMapping("warning", 2), new PreferenceSeverityMapping("info", 4), new PreferenceSeverityMapping("ignore", 8), new PreferenceSeverityMapping(null, -1)};
    protected static final String UNKNOWN_PLUGIN_ID = "unknown";
    protected static final String RELATIVE_DEBUG_OPTION_NAME = "debug";
    protected static final Class<?> DEBUG_TRACE_ENTRY_CLASS = JptPlugin.class;

    protected JptPlugin() {
    }

    public void start(BundleContext context) throws Exception {
        this.bundle = context.getBundle();
        this.setInstance(this);
    }

    protected abstract void setInstance(JptPlugin var1);

    public void stop(BundleContext context) throws Exception {
        this.closeDebugOptionsTracker();
    }

    public IContentType getContentType(String contentType) {
        StringBuilder scope = this.getContentTypeScope();
        return scope == null ? null : Platform.getContentTypeManager().getContentType(scope.append(contentType).toString());
    }

    protected StringBuilder getContentTypeScope() {
        String id = this.getPluginID();
        if (id == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(id);
        sb.append('.');
        sb.append(this.getRelativeContentTypeScope());
        sb.append('.');
        return sb;
    }

    protected String getRelativeContentTypeScope() {
        return RELATIVE_CONTENT_TYPE_SCOPE;
    }

    public String getPersistentProperty(IResource resource, String key) {
        QualifiedName qName = this.buildPersistentPropertyQualifiedName(key);
        try {
            return qName == null ? null : resource.getPersistentProperty(qName);
        }
        catch (CoreException ex) {
            this.logError(ex);
            return null;
        }
    }

    public void setPersistentProperty(IResource resource, String key, String value) {
        QualifiedName qName = this.buildPersistentPropertyQualifiedName(key);
        try {
            if (qName != null) {
                resource.setPersistentProperty(qName, value);
            }
        }
        catch (CoreException ex) {
            this.logError(ex);
        }
    }

    public void removePersistentProperties(IResource resource) {
        try {
            this.removePersistentProperties_(resource);
        }
        catch (CoreException ex) {
            this.logError(ex);
        }
    }

    protected void removePersistentProperties_(IResource resource) throws CoreException {
        String id = this.getPersistentPropertyPluginID();
        Map props = resource.getPersistentProperties();
        for (QualifiedName key : props.keySet()) {
            if (!ObjectTools.equals((Object)key.getQualifier(), (Object)id)) continue;
            resource.setPersistentProperty(key, null);
        }
    }

    protected QualifiedName buildPersistentPropertyQualifiedName(String relativeName) {
        String id = this.getPersistentPropertyPluginID();
        return id == null ? null : new QualifiedName(id, relativeName);
    }

    protected String getPersistentPropertyPluginID() {
        return this.getOriginalPluginID();
    }

    public String getPreference(String key) {
        return this.getPreference(key, null);
    }

    public String getPreference(String key, String defaultValue) {
        return this.searchPreferences(key, this.getPreferenceSearchPath(), defaultValue);
    }

    public String getPreference(IProject project, String key) {
        return this.getPreference(project, key, null);
    }

    public String getPreference(IProject project, String key, String defaultValue) {
        return this.searchPreferences(key, this.getPreferenceSearchPath(project), defaultValue);
    }

    public boolean getBooleanPreference(String key) {
        return this.getBooleanPreference(key, false);
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        return this.searchBooleanPreferences(key, this.getPreferenceSearchPath(), defaultValue);
    }

    public boolean getBooleanPreference(IProject project, String key) {
        return this.getBooleanPreference(project, key, false);
    }

    public boolean getBooleanPreference(IProject project, String key, boolean defaultValue) {
        return this.searchBooleanPreferences(key, this.getPreferenceSearchPath(project), defaultValue);
    }

    protected boolean searchBooleanPreferences(String key, IEclipsePreferences[] searchPath, boolean defaultValue) {
        String value = this.searchPreferences(key, searchPath);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getIntPreference(String key) {
        return this.getIntPreference(key, -1);
    }

    public int getIntPreference(String key, int defaultValue) {
        return this.searchIntPreferences(key, this.getPreferenceSearchPath(), defaultValue);
    }

    public int getIntPreference(IProject project, String key) {
        return this.getIntPreference(project, key, -1);
    }

    public int getIntPreference(IProject project, String key, int defaultValue) {
        return this.searchIntPreferences(key, this.getPreferenceSearchPath(project), defaultValue);
    }

    protected int searchIntPreferences(String key, IEclipsePreferences[] searchPath, int defaultValue) {
        String value = this.searchPreferences(key, searchPath);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    protected String searchPreferences(String key, IEclipsePreferences[] searchPath, String defaultValue) {
        String value = this.searchPreferences(key, searchPath);
        return value != null ? value : defaultValue;
    }

    protected String searchPreferences(String key, IEclipsePreferences[] searchPath) {
        IEclipsePreferences[] iEclipsePreferencesArray = searchPath;
        int n = searchPath.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            IEclipsePreferences prefs = iEclipsePreferencesArray[n2];
            if (prefs != null && (value = prefs.get(key, null)) != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    protected IEclipsePreferences[] getPreferenceSearchPath() {
        return new IEclipsePreferences[]{this.getWorkspacePreferences(), this.getDefaultPreferences(), this.getCurrentDefaultPreferences()};
    }

    protected IEclipsePreferences[] getPreferenceSearchPath(IProject project) {
        return (IEclipsePreferences[])ArrayTools.add((Object[])this.getPreferenceSearchPath(), (int)0, (Object)this.getProjectPreferences(project));
    }

    public void setPreference(IProject project, String key, String value) {
        IEclipsePreferences prefs = this.getProjectPreferences(project);
        if (prefs != null) {
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            this.flushPreferences(prefs);
        }
    }

    public void setPreference(String key, String value) {
        IEclipsePreferences prefs = this.getWorkspacePreferences();
        if (prefs != null) {
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            this.flushPreferences(prefs);
        }
    }

    public void setDefaultPreference(String key, String value) {
        IEclipsePreferences prefs = this.getCurrentDefaultPreferences();
        if (prefs != null) {
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            this.flushPreferences(prefs);
        }
    }

    public void setBooleanPreference(IProject project, String key, boolean value) {
        IEclipsePreferences prefs = this.getProjectPreferences(project);
        if (prefs != null) {
            prefs.putBoolean(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void setBooleanPreference(String key, boolean value) {
        IEclipsePreferences prefs = this.getWorkspacePreferences();
        if (prefs != null) {
            prefs.putBoolean(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void setBooleanDefaultPreference(String key, boolean value) {
        IEclipsePreferences prefs = this.getCurrentDefaultPreferences();
        if (prefs != null) {
            prefs.putBoolean(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void setIntPreference(IProject project, String key, int value) {
        IEclipsePreferences prefs = this.getProjectPreferences(project);
        if (prefs != null) {
            prefs.putInt(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void setIntPreference(String key, int value) {
        IEclipsePreferences prefs = this.getWorkspacePreferences();
        if (prefs != null) {
            prefs.putInt(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void setIntDefaultPreference(String key, int value) {
        IEclipsePreferences prefs = this.getCurrentDefaultPreferences();
        if (prefs != null) {
            prefs.putInt(key, value);
            this.flushPreferences(prefs);
        }
    }

    public void removePreference(IProject project, String key) {
        IEclipsePreferences prefs = this.getProjectPreferences(project);
        if (prefs != null) {
            prefs.remove(key);
            this.flushPreferences(prefs);
        }
    }

    public void removePreference(String key) {
        IEclipsePreferences prefs = this.getWorkspacePreferences();
        if (prefs != null) {
            prefs.remove(key);
            this.flushPreferences(prefs);
        }
    }

    public void removePreferences(IProject project) {
        this.removePreferences(this.getProjectPreferences(project));
    }

    public void removePreferences() {
        this.removePreferences(this.getWorkspacePreferences());
    }

    protected void removePreferences(IEclipsePreferences prefs) {
        try {
            if (prefs != null) {
                prefs.removeNode();
            }
        }
        catch (BackingStoreException ex) {
            this.logError(ex);
        }
    }

    protected IEclipsePreferences getProjectPreferences(IProject project) {
        return this.getPreferences((IScopeContext)new ProjectScope(project));
    }

    protected IEclipsePreferences getWorkspacePreferences() {
        return this.getPreferences(InstanceScope.INSTANCE);
    }

    protected IEclipsePreferences getCurrentDefaultPreferences() {
        String qualifier = this.getPluginID();
        return qualifier == null ? null : DefaultScope.INSTANCE.getNode(qualifier);
    }

    protected IEclipsePreferences getDefaultPreferences() {
        return this.getPreferences(DefaultScope.INSTANCE);
    }

    protected IEclipsePreferences getPreferences(IScopeContext context) {
        String qualifier = this.getPreferencesPluginID();
        return qualifier == null ? null : context.getNode(qualifier);
    }

    protected String getPreferencesPluginID() {
        return this.getOriginalPluginID();
    }

    protected void flushPreferences(IEclipsePreferences prefs) {
        if (FlushPreferences) {
            new FlushPreferencesJob(prefs).schedule();
        }
    }

    public boolean getWorkspaceValidationPreferencesOverridden(IProject project) {
        String legacyPref = this.getPreference(project, LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
        if (legacyPref != null) {
            boolean legacyBooleanPref = this.getBooleanPreference(project, LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
            this.setWorkspaceValidationPreferencesOverridden(project, legacyBooleanPref);
            this.removePreference(project, LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
        }
        return this.getBooleanPreference(project, WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
    }

    public void setWorkspaceValidationPreferencesOverridden(IProject project, boolean value) {
        String legacyPref = this.getPreference(project, LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
        if (legacyPref != null) {
            this.removePreference(project, LEGACY_WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN);
        }
        this.setBooleanPreference(project, WORKSPACE_VALIDATION_PREFERENCES_OVERRIDDEN, value);
    }

    public int getValidationMessageSeverity(IProject project, String messageID, int defaultSeverity) {
        int prefSeverity = this.getValidationMessageSeverityPreference(project, messageID);
        return prefSeverity != -1 ? prefSeverity : defaultSeverity;
    }

    public int getValidationMessageSeverityPreference(IProject project, String messageID) {
        return this.convertPreferenceValueToMessageSeverity(this.getValidationMessageSeverityPreference_(project, messageID));
    }

    private String getValidationMessageSeverityPreference_(IProject project, String messageID) {
        return this.getPreference(project, PROBLEM_ + messageID);
    }

    public void setValidationMessageSeverityPreference(IProject project, String messageID, int value) {
        this.setValidationMessageSeverityPreference_(project, messageID, this.convertMessageSeverityToPreferenceValue(value));
    }

    private void setValidationMessageSeverityPreference_(IProject project, String messageID, String value) {
        this.setPreference(project, PROBLEM_ + messageID, value);
    }

    public int getValidationMessageSeverityPreference(String messageID) {
        return this.convertPreferenceValueToMessageSeverity(this.getValidationMessageSeverityPreference_(messageID));
    }

    private String getValidationMessageSeverityPreference_(String messageID) {
        return this.getPreference(PROBLEM_ + messageID);
    }

    public void setValidationMessageSeverityPreference(String messageID, int value) {
        this.setValidationMessageSeverityPreference_(messageID, this.convertMessageSeverityToPreferenceValue(value));
    }

    private void setValidationMessageSeverityPreference_(String messageID, String value) {
        this.setPreference(PROBLEM_ + messageID, value);
    }

    private int convertPreferenceValueToMessageSeverity(String prefSeverity) {
        PreferenceSeverityMapping[] preferenceSeverityMappingArray = PREFERENCE_SEVERITY_MAPPINGS;
        int n = PREFERENCE_SEVERITY_MAPPINGS.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceSeverityMapping mapping = preferenceSeverityMappingArray[n2];
            if (ObjectTools.equals((Object)prefSeverity, (Object)mapping.preferenceValue)) {
                return mapping.validationSeverity;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unknown preference severity: " + prefSeverity);
    }

    private String convertMessageSeverityToPreferenceValue(int severity) {
        PreferenceSeverityMapping[] preferenceSeverityMappingArray = PREFERENCE_SEVERITY_MAPPINGS;
        int n = PREFERENCE_SEVERITY_MAPPINGS.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceSeverityMapping mapping = preferenceSeverityMappingArray[n2];
            if (severity == mapping.validationSeverity) {
                return mapping.preferenceValue;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unknown severity: " + severity);
    }

    public IStatus logError(String message) {
        return this.log(4, message);
    }

    public IStatus log(int severity, String message) {
        return this.log(severity, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public IStatus logError(String message, Object ... args) {
        return this.log(4, message, args);
    }

    public IStatus log(int severity, String message, Object ... args) {
        return this.log(severity, null, message, args);
    }

    public IStatus logError(Throwable throwable) {
        return this.log(4, throwable);
    }

    public IStatus log(int severity, Throwable throwable) {
        return this.log(severity, throwable, throwable.getLocalizedMessage());
    }

    public IStatus logError(Throwable throwable, String message) {
        return this.log(4, throwable, message);
    }

    public IStatus log(int severity, Throwable throwable, String message) {
        return this.log(severity, 0, throwable, message);
    }

    public IStatus logError(Throwable throwable, String message, Object ... args) {
        return this.log(4, throwable, message, args);
    }

    public IStatus log(int severity, Throwable throwable, String message, Object ... args) {
        return this.log(severity, 0, throwable, message, args);
    }

    public IStatus log(int severity, int code, Throwable throwable, String message) {
        return this.log(severity, code, throwable, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public IStatus log(int severity, int code, Throwable throwable, String message, Object ... args) {
        String id;
        if (args.length > 0) {
            message = NLS.bind((String)message, (Object[])args);
        }
        Status status = new Status(severity, (id = this.getPluginID()) != null ? id : UNKNOWN_PLUGIN_ID, code, message, throwable);
        if (id != null) {
            ILog log = this.getLog();
            if (log != null) {
                log.log((IStatus)status);
            } else {
                this.log_((IStatus)status);
            }
        } else {
            this.log_((IStatus)status);
        }
        return status;
    }

    public ILog getLog() {
        Bundle b = this.getBundle();
        return b == null ? null : Platform.getLog((Bundle)b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log_(IStatus status) {
        PrintStream stream = System.out;
        int severity = status.getSeverity();
        if (severity == 4 || severity == 2) {
            stream = System.err;
        }
        PrintStream printStream = stream;
        synchronized (printStream) {
            this.log_(new PrintWriter(stream), status);
        }
    }

    protected void log_(PrintWriter writer, IStatus status) {
        String message;
        writer.print(this.getClass().getName());
        writer.print(':');
        writer.println();
        int severity = status.getSeverity();
        switch (severity) {
            case 8: {
                writer.print("CANCEL");
                break;
            }
            case 4: {
                writer.print("ERROR");
                break;
            }
            case 2: {
                writer.print("WARNING");
                break;
            }
            case 1: {
                writer.print("INFO");
                break;
            }
            case 0: {
                writer.print("OK");
                break;
            }
            default: {
                writer.print("SEVERITY ");
                writer.print(severity);
            }
        }
        int code = status.getCode();
        if (code != 0) {
            writer.print(" (code=");
            writer.print(code);
            writer.print(")");
        }
        if ((message = status.getMessage()) != null) {
            writer.print(": ");
            writer.print(message);
        }
        writer.println();
        Throwable throwable = status.getException();
        if (throwable != null) {
            throwable.printStackTrace(writer);
        }
    }

    public IStatus buildErrorStatus() {
        return this.buildStatus(4);
    }

    public IStatus buildOKStatus() {
        return this.buildStatus(0);
    }

    public IStatus buildStatus(int severity) {
        return this.buildStatus(severity, (String)null);
    }

    public IStatus buildErrorStatus(String message) {
        return this.buildStatus(4, message);
    }

    public IStatus buildWarningStatus(String message) {
        return this.buildStatus(2, message);
    }

    public IStatus buildInfoStatus(String message) {
        return this.buildStatus(1, message);
    }

    public IStatus buildStatus(int severity, String message) {
        return this.buildStatus(severity, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public IStatus buildErrorStatus(String message, Object ... args) {
        return this.buildStatus(4, message, args);
    }

    public IStatus buildWarningStatus(String message, Object ... args) {
        return this.buildStatus(2, message, args);
    }

    public IStatus buildInfoStatus(String message, Object ... args) {
        return this.buildStatus(1, message, args);
    }

    public IStatus buildStatus(int severity, String message, Object ... args) {
        return this.buildStatus(severity, null, message, args);
    }

    public IStatus buildErrorStatus(Throwable throwable) {
        return this.buildStatus(4, throwable);
    }

    public IStatus buildStatus(int severity, Throwable throwable) {
        return this.buildStatus(severity, throwable, throwable.getLocalizedMessage());
    }

    public IStatus buildErrorStatus(Throwable throwable, String message) {
        return this.buildStatus(4, throwable, message);
    }

    public IStatus buildStatus(int severity, Throwable throwable, String message) {
        return this.buildStatus(severity, throwable, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public IStatus buildErrorStatus(Throwable throwable, String message, Object ... args) {
        return this.buildStatus(4, throwable, message, args);
    }

    public IStatus buildStatus(int severity, Throwable throwable, String message, Object ... args) {
        return this.buildStatus(severity, 0, throwable, message, args);
    }

    public IStatus buildStatus(int severity, int code, Throwable throwable, String message) {
        return this.buildStatus(severity, code, throwable, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public IStatus buildStatus(int severity, int code, Throwable throwable, String message, Object ... args) {
        String id;
        if (args.length > 0) {
            message = NLS.bind((String)message, (Object[])args);
        }
        if ((id = this.getPluginID()) == null) {
            id = this.getClass().getName();
        }
        return new Status(severity, id, code, message, throwable);
    }

    public synchronized ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = this.buildExceptionHandler();
        }
        return this.exceptionHandler;
    }

    public ExceptionHandler buildExceptionHandler() {
        return this.buildExceptionHandler(4);
    }

    public ExceptionHandler buildExceptionHandler(int severity) {
        return new PluginExceptionHandler(severity);
    }

    public boolean isDebugEnabled() {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return false;
        }
        StringBuilder option = this.getDebugOptionName();
        return option != null && debugOptions.getBooleanOption(option.toString(), false);
    }

    public void setDebugEnabled(boolean debug) {
        StringBuilder option;
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions != null && (option = this.getDebugOptionName()) != null) {
            if (!debugOptions.isDebugEnabled()) {
                debugOptions.setDebugEnabled(true);
            }
            debugOptions.setOption(option.toString(), Boolean.toString(debug));
        }
    }

    protected StringBuilder getDebugOptionName() {
        String id = this.getPluginID();
        if (id == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(id);
        sb.append('/');
        sb.append(this.getRelativeDebugOptionName());
        return sb;
    }

    protected String getRelativeDebugOptionName() {
        return RELATIVE_DEBUG_OPTION_NAME;
    }

    public boolean getBooleanDebugOption(String option) {
        return this.getBooleanDebugOption(option, false);
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Boolean.parseBoolean(value.trim());
    }

    public void setDebugOption(String option, boolean value) {
        this.setDebugOption(option, Boolean.toString(value));
    }

    public int getIntegerDebugOption(String option) {
        return this.getIntegerDebugOption(option, -1);
    }

    public int getIntegerDebugOption(String option, int defaultValue) {
        String value = this.getDebugOption(option);
        return value == null ? defaultValue : Integer.parseInt(value.trim());
    }

    public void setDebugOption(String option, int value) {
        this.setDebugOption(option, Integer.toString(value));
    }

    public String getDebugOption(String option) {
        return this.getDebugOption(option, null);
    }

    public String getDebugOption(String option, String defaultValue) {
        this.checkDebugOption(option);
        return this.isDebugEnabled() ? this.getDebugOption_(option, defaultValue) : defaultValue;
    }

    protected String getDebugOption_(String option, String defaultValue) {
        String value = this.getDebugOption_(option);
        return value != null ? value : defaultValue;
    }

    protected String getDebugOption_(String option) {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return null;
        }
        StringBuilder scope = this.getDebugOptionScope();
        return scope == null ? null : debugOptions.getOption(scope.append(option).toString());
    }

    public void setDebugOption(String option, String value) {
        this.checkDebugOption(option);
        if (this.isDebugEnabled()) {
            this.setDebugOption_(option, value);
        }
    }

    protected void setDebugOption_(String option, String value) {
        StringBuilder scope;
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions != null && (scope = this.getDebugOptionScope()) != null) {
            debugOptions.setOption(scope.append(option).toString(), value);
        }
    }

    public void removeDebugOption(String option) {
        this.checkDebugOption(option);
        if (this.isDebugEnabled()) {
            this.removeDebugOption_(option);
        }
    }

    protected void removeDebugOption_(String option) {
        StringBuilder scope;
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions != null && (scope = this.getDebugOptionScope()) != null) {
            debugOptions.removeOption(scope.append(option).toString());
        }
    }

    protected DebugOptions getDebugOptions() {
        ServiceTracker<DebugOptions, DebugOptions> tracker = this.getDebugOptionsTracker();
        return tracker == null ? null : (DebugOptions)tracker.getService();
    }

    private synchronized ServiceTracker<DebugOptions, DebugOptions> getDebugOptionsTracker() {
        if (this.debugOptionsTracker == null) {
            this.debugOptionsTracker = this.buildDebugOptionsTracker();
        }
        return this.debugOptionsTracker;
    }

    private ServiceTracker<DebugOptions, DebugOptions> buildDebugOptionsTracker() {
        try {
            return this.buildDebugOptionsTracker_();
        }
        catch (RuntimeException ex) {
            this.logError(ex);
            return null;
        }
    }

    private ServiceTracker<DebugOptions, DebugOptions> buildDebugOptionsTracker_() {
        Bundle b = this.getBundle();
        if (b == null) {
            return null;
        }
        BundleContext bc = b.getBundleContext();
        if (bc == null) {
            return null;
        }
        ServiceTracker tracker = new ServiceTracker(bc, DebugOptions.class, null);
        tracker.open();
        return tracker;
    }

    protected synchronized void closeDebugOptionsTracker() {
        if (this.debugOptionsTracker != null) {
            this.debugOptionsTracker.close();
            this.debugOptionsTracker = null;
            this.debugTrace = null;
        }
    }

    protected StringBuilder getDebugOptionScope() {
        StringBuilder sb = this.getDebugOptionName();
        return sb == null ? null : sb.append('/');
    }

    protected void checkDebugOption(String option) {
        if (StringTools.isBlank((String)option)) {
            throw new IllegalArgumentException("debug option cannot be blank");
        }
    }

    public void trace(String option) {
        this.trace(option, (String)null);
    }

    public void trace(String option, String message) {
        this.trace(option, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public void trace(String option, String message, Object ... args) {
        this.trace(option, null, message, args);
    }

    public void trace(String option, Throwable throwable) {
        this.trace(option, throwable, throwable.getLocalizedMessage());
    }

    public void trace(String option, Throwable throwable, String message) {
        this.trace(option, throwable, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public void trace(String option, Throwable throwable, String message, Object ... args) {
        this.checkDebugOption(option);
        if (this.isDebugEnabled()) {
            this.trace_(option, throwable, message, args);
        }
    }

    protected void trace_(String option, Throwable throwable, String message, Object ... args) {
        DebugTrace trace;
        if (args.length > 0) {
            message = NLS.bind((String)message, (Object[])args);
        }
        if ((trace = this.getDebugTrace()) != null) {
            trace.trace(this.getTraceOptionScope().append(option).toString(), message, throwable);
        }
    }

    public void dumpStackTrace(String option) {
        this.dumpStackTrace(option, null);
    }

    public void dumpStackTrace(String option, String message) {
        this.dumpStackTrace(option, message, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public void dumpStackTrace(String option, String message, Object ... args) {
        this.checkDebugOption(option);
        if (this.isDebugEnabled()) {
            if (message != null) {
                this.trace_(option, null, message, args);
            }
            this.dumpStackTrace_(option);
        }
    }

    protected void dumpStackTrace_(String option) {
        DebugTrace trace = this.getDebugTrace();
        if (trace != null) {
            trace.traceDumpStack(this.getTraceOptionScope().append(option).toString());
        }
    }

    protected StringBuilder getTraceOptionScope() {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(this.getRelativeTraceOptionName());
        sb.append('/');
        return sb;
    }

    protected String getRelativeTraceOptionName() {
        return this.getRelativeDebugOptionName();
    }

    protected synchronized DebugTrace getDebugTrace() {
        if (this.debugTrace == null) {
            this.debugTrace = this.buildDebugTrace();
        }
        return this.debugTrace;
    }

    protected DebugTrace buildDebugTrace() {
        return this.buildDebugTrace(this.getDebugTraceEntryClass());
    }

    protected Class<?> getDebugTraceEntryClass() {
        return DEBUG_TRACE_ENTRY_CLASS;
    }

    protected DebugTrace buildDebugTrace(Class<?> traceEntryClass) {
        DebugOptions debugOptions = this.getDebugOptions();
        if (debugOptions == null) {
            return null;
        }
        String id = this.getPluginID();
        return id == null ? null : debugOptions.newDebugTrace(id, traceEntryClass);
    }

    public Bundle getBundle() {
        return this.bundle != null ? this.bundle : this.getBundle_();
    }

    private Bundle getBundle_() {
        return FrameworkUtil.getBundle(this.getClass());
    }

    public String getPluginID() {
        Bundle b = this.getBundle();
        return b == null ? null : b.getSymbolicName();
    }

    public final String getOriginalPluginID() {
        Bundle b = this.getBundle();
        return b == null ? null : this.getOriginalPluginID_();
    }

    protected String getOriginalPluginID_() {
        return this.getPluginID();
    }

    public boolean isActive() {
        Bundle b = this.getBundle();
        return b != null && b.getState() == 32;
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public QualifiedName buildQualifiedName(String relativeName) {
        String id = this.getPluginID();
        return id == null ? null : new QualifiedName(id, relativeName);
    }

    public IPath getStateLocation() {
        try {
            return this.getStateLocation_();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    protected IPath getStateLocation_() {
        Bundle b = this.getBundle();
        return b == null ? null : Platform.getStateLocation((Bundle)b);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.getBundle());
    }

    protected static class FlushPreferencesJob
    extends Job {
        private final IEclipsePreferences prefs;

        FlushPreferencesJob(IEclipsePreferences prefs) {
            super(NLS.bind((String)JptCommonCoreMessages.PREFERENCES_FLUSH_JOB_NAME, (Object)prefs.absolutePath()));
            this.prefs = prefs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                return JptCommonCorePlugin.instance().logError(ex);
            }
            return Status.OK_STATUS;
        }
    }

    protected class PluginExceptionHandler
    extends ExceptionHandlerAdapter {
        private final int severity;

        protected PluginExceptionHandler(int severity) {
            this.severity = severity;
        }

        public void handleException(Throwable t) {
            JptPlugin.this.log(this.severity, t);
        }
    }

    private static class PreferenceSeverityMapping {
        final String preferenceValue;
        final int validationSeverity;

        PreferenceSeverityMapping(String preferenceValue, int validationSeverity) {
            this.preferenceValue = preferenceValue;
            this.validationSeverity = validationSeverity;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)this.preferenceValue);
        }
    }
}

