/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.SimpleMethodSignature;
import org.eclipse.jpt.common.utility.internal.command.DefaultCommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTMethodAttribute
extends JDTMember
implements MethodAttribute {
    private final JavaType[] parameterTypes;
    protected static final MethodDeclaration[] EMPTY_METHOD_DECLARATION_ARRAY = new MethodDeclaration[0];

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext) {
        return JDTMethodAttribute.newInstance(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandContext, DefaultAnnotationEditFormatter.instance());
    }

    public static JDTMethodAttribute newInstance(Type declaringType, MethodSignature signature, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext, AnnotationEditFormatter annotationEditFormatter) {
        return new JDTMethodAttribute(declaringType, signature, occurrence, compilationUnit, modifySharedDocumentCommandContext, annotationEditFormatter);
    }

    private JDTMethodAttribute(Type declaringType, MethodSignature methodSignature, int occurrence, ICompilationUnit compilationUnit, CommandContext modifySharedDocumentCommandContext, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, methodSignature.getName(), occurrence, compilationUnit, modifySharedDocumentCommandContext, annotationEditFormatter);
        this.parameterTypes = methodSignature.getParameterTypes();
    }

    public JDTMethodAttribute(Type declaringType, String name, String[] parameterTypeNames, int occurrence, ICompilationUnit compilationUnit) {
        this(declaringType, (MethodSignature)new SimpleMethodSignature(name, parameterTypeNames), occurrence, compilationUnit, DefaultCommandContext.instance(), (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    @Override
    protected Type getDeclaringType() {
        return (Type)super.getDeclaringType();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public MethodDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        int count = 0;
        MethodDeclaration[] methodDeclarationArray = this.getDeclaringTypeMethodDeclarations(astRoot);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (this.matches(methodDeclaration) && ++count == this.getOccurrence()) {
                return methodDeclaration;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean matches(MethodSignature signature, int occurrence) {
        return this.matches(signature) && occurrence == this.getOccurrence();
    }

    protected boolean matches(MethodSignature signature) {
        return signature.getName().equals(this.getName()) && Arrays.equals(this.parameterTypes, signature.getParameterTypes());
    }

    protected boolean matches(MethodDeclaration methodDeclaration) {
        return this.matches(ASTTools.buildMethodSignature(methodDeclaration));
    }

    protected static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    @Override
    public boolean matches(String memberName, int occurrence) {
        throw new UnsupportedOperationException("Use #matches(MethodSignature, int).");
    }

    @Override
    public String getAttributeName() {
        return NameTools.convertGetterOrSetterMethodNameToPropertyName((String)this.getName());
    }

    protected TypeDeclaration getDeclaringTypeDeclaration(CompilationUnit astRoot) {
        return this.getDeclaringType().getBodyDeclaration(astRoot);
    }

    protected MethodDeclaration[] getDeclaringTypeMethodDeclarations(CompilationUnit astRoot) {
        TypeDeclaration typeDeclaration = this.getDeclaringTypeDeclaration(astRoot);
        return typeDeclaration == null ? EMPTY_METHOD_DECLARATION_ARRAY : typeDeclaration.getMethods();
    }
}

