/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.XmlReferenceDescriptorWriter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSearchReporter
implements IApiSearchReporter {
    private String fLocation = null;
    private DocumentBuilder parser = null;
    private boolean debug = false;
    private int referenceCount = 0;
    private int illegalCount = 0;
    private int internalCount = 0;

    public XmlSearchReporter(String location, boolean debug) {
        this.fLocation = location;
        this.debug = debug;
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError fce) {
            ApiPlugin.log(fce);
        }
        catch (ParserConfigurationException pce) {
            ApiPlugin.log(pce);
        }
    }

    @Override
    public void reportResults(IApiElement element, IReference[] references) {
        if (references.length == 0) {
            return;
        }
        HashSet<IReferenceDescriptor> writtenReferences = new HashSet<IReferenceDescriptor>();
        XmlReferenceDescriptorWriter writer = new XmlReferenceDescriptorWriter(this.fLocation);
        ArrayList<IReferenceDescriptor> descriptors = new ArrayList<IReferenceDescriptor>(references.length + 1);
        int i = 0;
        while (i < references.length) {
            Reference reference = (Reference)references[i];
            try {
                IReferenceDescriptor descriptor = reference.getReferenceDescriptor();
                descriptors.add(descriptor);
                if (!writtenReferences.contains(descriptor)) {
                    ++this.referenceCount;
                    if ((references[i].getReferenceFlags() & 1) > 0) {
                        ++this.illegalCount;
                    }
                    if (descriptor.getVisibility() == 2) {
                        ++this.internalCount;
                    }
                    writtenReferences.add(descriptor);
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
            ++i;
        }
        writer.writeReferences(descriptors.toArray(new IReferenceDescriptor[descriptors.size()]));
    }

    String getId(IApiComponent component) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(component.getSymbolicName()).append(" ").append('(').append(component.getVersion()).append(')');
        return buffer.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reportNotSearched(IApiElement[] elements) {
        if (elements == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for projects that were not searched...");
            }
            if (!(rootfile = new File(this.fLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "not_searched.xml")).exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("components");
            doc.appendChild(root);
            Element comp = null;
            SkippedComponent component = null;
            int i = 0;
            while (i < elements.length) {
                component = (SkippedComponent)elements[i];
                comp = doc.createElement("component");
                comp.setAttribute("id", component.getComponentId());
                comp.setAttribute("version", component.getVersion());
                comp.setAttribute("details", component.getErrorDetails());
                root.appendChild(comp);
                ++i;
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.write(Util.serializeDocument(doc));
            writer.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (CoreException coreException) {
            if (writer == null) return;
            {
                catch (Throwable throwable) {
                    if (writer == null) throw throwable;
                    try {
                        writer.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {}
    }

    @Override
    public void reportMetadata(IMetadata data) {
        if (data == null) {
            return;
        }
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for projects that were not searched...");
            }
            if (!(rootfile = new File(this.fLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "meta.xml")).exists()) {
                file.createNewFile();
            }
            data.serializeToFile(file);
        }
        catch (FileNotFoundException fnfe) {
            ApiPlugin.log(fnfe);
        }
        catch (IOException ioe) {
            ApiPlugin.log(ioe);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reportCounts() {
        BufferedWriter writer = null;
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for counting total references...");
            }
            if (!(rootfile = new File(this.fLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "counts.xml")).exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("reportedcount");
            doc.appendChild(root);
            root.setAttribute("total", Integer.toString(this.referenceCount));
            root.setAttribute("illegal", Integer.toString(this.illegalCount));
            root.setAttribute("internal", Integer.toString(this.internalCount));
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.write(Util.serializeDocument(doc));
            writer.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException iOException) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException2) {}
            return;
        }
        catch (CoreException coreException) {
            if (writer == null) return;
            {
                catch (Throwable throwable) {
                    if (writer == null) throw throwable;
                    try {
                        writer.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (writer == null) return;
        try {
            writer.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

