/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ListWidgetModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.events.SelectionAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListBoxSelectionBinding<E>
implements ListWidgetModelBinding.SelectionBinding {
    private final ArrayList<E> list;
    private final ModifiableCollectionValueModel<E> selectedItemsModel;
    private final ArrayList<E> selectedItems = new ArrayList();
    private final CollectionChangeListener selectedItemsListener;
    private final List listBox;
    private final SelectionListener listBoxSelectionListener;

    ListBoxSelectionBinding(ArrayList<E> list, ModifiableCollectionValueModel<E> selectedItemsModel, List listBox) {
        if (list == null || selectedItemsModel == null || listBox == null) {
            throw new NullPointerException();
        }
        this.list = list;
        this.selectedItemsModel = selectedItemsModel;
        this.listBox = listBox;
        this.selectedItemsListener = this.buildSelectedItemsListener();
        this.selectedItemsModel.addCollectionChangeListener("values", this.selectedItemsListener);
        this.listBoxSelectionListener = this.buildListBoxSelectionListener();
        this.listBox.addSelectionListener(this.listBoxSelectionListener);
        this.selectedItems.ensureCapacity(this.selectedItemsModel.size());
        CollectionTools.addAll(this.selectedItems, this.selectedItemsModel);
    }

    private CollectionChangeListener buildSelectedItemsListener() {
        return SWTListenerTools.wrap((CollectionChangeListener)new SelectedItemsListener(), (Widget)this.listBox);
    }

    private SelectionListener buildListBoxSelectionListener() {
        return new ListBoxSelectionListener();
    }

    @Override
    public void listChanged() {
        this.setListSelection();
    }

    private void setListSelection() {
        int selectedItemsSize = this.selectedItems.size();
        int[] select = ArrayTools.EMPTY_INT_ARRAY;
        if (selectedItemsSize > 0) {
            select = new int[selectedItemsSize];
            int i = 0;
            for (E item : this.selectedItems) {
                select[i++] = this.indexOf(item);
            }
        }
        int listSize = this.list.size();
        int[] deselect = ArrayTools.EMPTY_INT_ARRAY;
        if (listSize > 0) {
            deselect = ArrayTools.fill((int[])new int[listSize], (int)-1);
            int i = 0;
            int j = 0;
            while (j < listSize) {
                if (!ArrayTools.contains((int[])select, (int)j)) {
                    deselect[i++] = j;
                }
                ++j;
            }
        }
        int[] old = ArrayTools.sort((int[])this.listBox.getSelectionIndices());
        if (!Arrays.equals(select = ArrayTools.sort((int[])select), old)) {
            this.listBox.deselect(deselect);
            this.listBox.select(select);
        }
    }

    @Override
    public void dispose() {
        this.listBox.removeSelectionListener(this.listBoxSelectionListener);
        this.selectedItemsModel.removeCollectionChangeListener("values", this.selectedItemsListener);
        this.selectedItems.clear();
    }

    void selectedItemsAdded(CollectionAddEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsAdded_(event);
        }
    }

    private void selectedItemsAdded_(CollectionAddEvent event) {
        Iterable items = event.getItems();
        this.selectedItems.ensureCapacity(this.selectedItems.size() + event.getItemsSize());
        CollectionTools.addAll(this.selectedItems, (Iterable)items);
        int[] indices = new int[event.getItemsSize()];
        int i = 0;
        for (Object item : items) {
            indices[i++] = this.indexOf(item);
        }
        this.listBox.select(indices);
    }

    void selectedItemsRemoved(CollectionRemoveEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsRemoved_(event);
        }
    }

    private void selectedItemsRemoved_(CollectionRemoveEvent event) {
        Iterable items = event.getItems();
        CollectionTools.removeAll(this.selectedItems, (Iterable)items);
        int[] indices = new int[event.getItemsSize()];
        int i = 0;
        for (Object item : items) {
            indices[i++] = this.indexOf(item);
        }
        this.listBox.deselect(indices);
    }

    void selectedItemsCleared() {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsCleared_();
        }
    }

    private void selectedItemsCleared_() {
        this.selectedItems.clear();
        this.listBox.deselectAll();
    }

    void selectedItemsChanged(CollectionChangeEvent event) {
        if (!this.listBox.isDisposed()) {
            this.selectedItemsChanged_(event);
        }
    }

    private void selectedItemsChanged_(CollectionChangeEvent event) {
        this.selectedItems.clear();
        this.selectedItems.ensureCapacity(event.getCollectionSize());
        Iterable eventCollection = event.getCollection();
        CollectionTools.addAll(this.selectedItems, (Iterable)eventCollection);
        this.setListSelection();
    }

    private int indexOf(E item) {
        int i = 0;
        for (E each : this.list) {
            if (ObjectTools.equals(each, item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void listBoxSelectionChanged() {
        this.selectedItemsModel.setValues(this.getListBoxSelectedItems());
    }

    void listBoxDoubleClicked() {
        this.listBoxSelectionChanged();
    }

    private Iterable<E> getListBoxSelectedItems() {
        ArrayList<E> lbSelectedItems = new ArrayList<E>(this.listBox.getSelectionCount());
        int[] nArray = this.listBox.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectionIndex = nArray[n2];
            lbSelectedItems.add(this.list.get(selectionIndex));
            ++n2;
        }
        return lbSelectedItems;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.selectedItems);
    }

    class ListBoxSelectionListener
    extends SelectionAdapter {
        ListBoxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ListBoxSelectionBinding.this.listBoxSelectionChanged();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            ListBoxSelectionBinding.this.listBoxDoubleClicked();
        }
    }

    class SelectedItemsListener
    extends CollectionChangeAdapter {
        SelectedItemsListener() {
        }

        public void itemsAdded(CollectionAddEvent event) {
            ListBoxSelectionBinding.this.selectedItemsAdded(event);
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            ListBoxSelectionBinding.this.selectedItemsRemoved(event);
        }

        public void collectionCleared(CollectionClearEvent event) {
            ListBoxSelectionBinding.this.selectedItemsCleared();
        }

        public void collectionChanged(CollectionChangeEvent event) {
            ListBoxSelectionBinding.this.selectedItemsChanged(event);
        }
    }
}

