/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ComboTools;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComboPane<T extends Model>
extends Pane<T> {
    protected Combo comboBox;

    protected ComboPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected ComboPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected ComboPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentPane, subjectHolder, enabledModel, parent);
    }

    @Override
    protected boolean addsComposite() {
        return false;
    }

    @Override
    public Control getControl() {
        return this.comboBox;
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.comboBox = this.addEditableCombo(container, this.getHelpId());
        this.comboBox.addModifyListener(this.buildModifyListener());
        ComboTools.handleDefaultValue(this.comboBox);
    }

    protected ModifyListener buildModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComboPane.this.comboBoxModified();
            }
        };
    }

    protected abstract Iterable<String> getValues();

    protected boolean usesDefaultValue() {
        return true;
    }

    protected abstract String getDefaultValue();

    protected abstract String getValue();

    protected abstract void setValue(String var1);

    protected String getHelpId() {
        return null;
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        this.updateSelectedItem();
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateComboBox();
    }

    protected void populateComboBox() {
        this.comboBox.removeAll();
        if (this.usesDefaultValue()) {
            this.comboBox.add(this.buildDefaultValueEntry());
        }
        for (String value : this.getValues()) {
            this.comboBox.add(value);
        }
        this.updateSelectedItem_();
    }

    protected String buildDefaultValueEntry() {
        if (this.getSubject() == null) {
            return JptCommonUiMessages.NONE_SELECTED;
        }
        String defaultValue = this.getDefaultValue();
        return defaultValue == null ? this.buildNullDefaultValueEntry() : this.buildNonNullDefaultValueEntry(defaultValue);
    }

    protected String buildNullDefaultValueEntry() {
        return JptCommonUiMessages.DEFAULT_EMPTY;
    }

    protected String buildNonNullDefaultValueEntry(String defaultValue) {
        return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
    }

    protected void updateSelectedItem() {
        if (this.usesDefaultValue()) {
            String defaultValueEntry = this.buildDefaultValueEntry();
            if (!this.comboBox.getItem(0).equals(defaultValueEntry)) {
                this.comboBox.remove(0);
                this.comboBox.add(defaultValueEntry, 0);
            }
        }
        this.updateSelectedItem_();
    }

    protected void updateSelectedItem_() {
        String value;
        String string = value = this.getSubject() == null ? null : this.getValue();
        if (value == null) {
            if (this.usesDefaultValue()) {
                this.comboBox.select(0);
            } else {
                this.comboBox.setText("");
            }
        } else if (!value.equals(this.comboBox.getText())) {
            this.comboBox.setText(value);
        }
    }

    protected void repopulateComboBox() {
        if (!this.comboBox.isDisposed()) {
            this.repopulate();
        }
    }

    protected void comboBoxModified() {
        if (!this.isPopulating()) {
            this.valueChanged(this.comboBox.getText());
        }
    }

    protected void valueChanged(String newValue) {
        String oldValue;
        Object subject = this.getSubject();
        if (subject == null) {
            if (this.nullSubjectIsNotAllowed()) {
                return;
            }
            oldValue = null;
        } else {
            oldValue = this.getValue();
        }
        if (StringTools.isBlank((String)newValue) || this.valueIsDefault(newValue)) {
            newValue = null;
        }
        if (ObjectTools.notEquals((Object)oldValue, (Object)newValue)) {
            this.setPopulating(true);
            try {
                this.setValue(newValue);
            }
            finally {
                this.setPopulating(false);
            }
        }
    }

    protected boolean nullSubjectIsAllowed() {
        return false;
    }

    protected final boolean nullSubjectIsNotAllowed() {
        return !this.nullSubjectIsAllowed();
    }

    protected boolean valueIsDefault(String value) {
        if (!this.usesDefaultValue()) {
            return false;
        }
        return this.comboBox.getItemCount() > 0 && value.equals(this.comboBox.getItem(0));
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

