/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.wizards.JavaProjectWizardPage;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;

public class SchemaWizardPage
extends WizardPage {
    protected static final String[] browseXSDFilterExtensions = new String[]{".xsd"};
    private final IStructuredSelection initialSelection;
    private final ResourceManager resourceManager;
    private IProject targetProject;
    protected SelectFileOrXMLCatalogIdPanel selectSourcePanel;

    public static IFile getSourceSchemaFromSelection(IStructuredSelection selection) {
        String elementExtension;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IFile && (elementExtension = ((IFile)firstElement).getFileExtension()) != null && browseXSDFilterExtensions[0].endsWith(elementExtension)) {
            return (IFile)firstElement;
        }
        return null;
    }

    SchemaWizardPage(IStructuredSelection selection, ResourceManager resourceManager) {
        super("SchemaWizardPage");
        this.initialSelection = selection;
        this.resourceManager = resourceManager;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        this.selectSourcePanel = new SelectFileOrXMLCatalogIdPanel(composite, this.initialSelection, this.resourceManager);
        this.selectSourcePanel.setLayoutData(new GridData(1808));
        SelectFileOrXMLCatalogIdPanel.PanelListener listener = new SelectFileOrXMLCatalogIdPanel.PanelListener(){

            public void completionStateChanged() {
                SchemaWizardPage.this.selectFileOrXMLCatalogIdPanelChanged();
            }
        };
        this.selectSourcePanel.setListener(listener);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.getSchemaFile() != null) {
                this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)this.getSchemaFile()));
            } else {
                this.updateTargetProject();
                IFile schema = SchemaWizardPage.getSourceSchemaFromSelection(this.initialSelection);
                if (schema != null) {
                    this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)schema));
                } else {
                    this.selectSourcePanel.setSingleFileViewDefaultSelection((ISelection)new StructuredSelection((Object)this.targetProject));
                }
            }
            this.selectSourcePanel.update();
            this.setTitle(JptJaxbUiMessages.SCHEMA_WIZARD_PAGE_TITLE);
            this.setDescription(JptJaxbUiMessages.SCHEMA_WIZARD_PAGE_DESC);
            this.selectSourcePanel.setFilterExtensions(browseXSDFilterExtensions);
        }
        this.selectSourcePanel.setVisibleHelper(visible);
    }

    public boolean isPageComplete() {
        return this.fileOrXmlCatalogEntrySelected() && this.getErrorMessage() == null;
    }

    public IFile getSchemaFile() {
        return this.selectSourcePanel.getFile();
    }

    public String getXMLCatalogId() {
        return this.selectSourcePanel.getXMLCatalogId();
    }

    public String getSchemaLocation() {
        IFile file = this.selectSourcePanel.getFile();
        if (file != null) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false).toString();
        }
        return this.selectSourcePanel.getXMLCatalogId();
    }

    public URI getLocalSchemaURI() {
        IFile file = this.selectSourcePanel.getFile();
        if (file != null) {
            return URI.createFileURI((String)file.getLocation().toString());
        }
        String uri = this.selectSourcePanel.getXMLCatalogURI();
        if (uri != null) {
            return CommonPlugin.asLocalURI((URI)URI.createURI((String)uri));
        }
        return null;
    }

    private void updateTargetProject() {
        IWizardPage previousPage = this.getPreviousPage();
        if (previousPage instanceof JavaProjectWizardPage) {
            this.targetProject = ((JavaProjectWizardPage)previousPage).getJavaProject().getProject();
        } else if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            this.targetProject = this.getProjectFromInitialSelection();
        }
    }

    private IProject getProjectFromInitialSelection() {
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IProject) {
            return (IProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            return ((IResource)firstElement).getProject();
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject().getProject();
        }
        return null;
    }

    private boolean fileOrXmlCatalogEntrySelected() {
        return this.getSchemaFile() != null || this.getXMLCatalogId() != null;
    }

    private String computeErrorMessage() {
        String errorMessage = null;
        URI uri = this.getLocalSchemaURI();
        if (uri != null && !URIHelper.isReadableURI((String)uri.toString(), (boolean)false)) {
            errorMessage = JptJaxbUiMessages.SCHEMA_WIZARD_PAGE_ERROR_URI_CANNOT_BE_LOCATED;
        }
        return errorMessage;
    }

    void selectFileOrXMLCatalogIdPanelChanged() {
        String errorMessage = this.computeErrorMessage();
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.isPageComplete());
    }
}

