/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.jface.OverlayImageDescriptor;
import org.eclipse.jpt.common.ui.internal.jface.PluggableTextTableLabelProvider;
import org.eclipse.jpt.common.ui.internal.jface.ResourceManagerTableLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiImages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;

public abstract class XMLCatalogTableViewer
extends TableViewer {
    protected static String ERROR_STATE_KEY = "errorstatekey";
    protected static final PluggableTextTableLabelProvider.TextTransformer<Object> CATALOG_ENTRY_LABEL_TEXT_TRANSFORMER = new CatalogEntryLabelTextTransformer();
    protected static final ResourceManagerTableLabelProvider.ImageDescriptorTransformer<Object> CATALOG_ENTRY_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER = new CatalogEntryLabelImageDescriptorTransformer();

    protected XMLCatalogTableViewer(Composite parent, String[] columnProperties, ResourceManager resourceManager) {
        super(parent, 65536);
        Table table = this.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < columnProperties.length) {
            TableColumn column = new TableColumn(table, i);
            column.setText(columnProperties[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
            ++i;
        }
        table.setLayout((Layout)layout);
        table.setLinesVisible(false);
        this.setColumnProperties(columnProperties);
        this.setContentProvider((IContentProvider)new CatalogEntryContentProvider());
        this.setLabelProvider(this.buildLabelProvider(resourceManager));
    }

    protected IBaseLabelProvider buildLabelProvider(ResourceManager resourceManager) {
        return new ResourceManagerTableLabelProvider(CATALOG_ENTRY_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER, CATALOG_ENTRY_LABEL_TEXT_TRANSFORMER, resourceManager);
    }

    protected abstract Collection getXMLCatalogEntries();

    public void setFilterExtensions(String[] extensions) {
        this.resetFilters();
        this.addFilter(new XMLCatalogTableViewerFilter(extensions));
    }

    public class CatalogEntryContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            Object[] array = XMLCatalogTableViewer.this.getXMLCatalogEntries().toArray();
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result = 0;
                    if (o1 instanceof ICatalogEntry && o2 instanceof ICatalogEntry) {
                        ICatalogEntry mappingInfo1 = (ICatalogEntry)o1;
                        ICatalogEntry mappingInfo2 = (ICatalogEntry)o2;
                        result = Collator.getInstance().compare(mappingInfo1.getKey(), mappingInfo2.getKey());
                    }
                    return result;
                }
            };
            Arrays.sort(array, comparator);
            return array;
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }

        public void dispose() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CatalogEntryLabelImageDescriptorTransformer
    implements ResourceManagerTableLabelProvider.ImageDescriptorTransformer<Object> {
        protected CatalogEntryLabelImageDescriptorTransformer() {
        }

        public ImageDescriptor transform(Object element, int columnIndex) {
            return element instanceof ICatalogEntry ? this.transform((ICatalogEntry)element, columnIndex) : null;
        }

        protected ImageDescriptor transform(ICatalogEntry catalogEntry, int columnIndex) {
            return columnIndex == 0 ? this.transform(catalogEntry) : null;
        }

        protected ImageDescriptor transform(ICatalogEntry catalogEntry) {
            String uri = catalogEntry.getURI();
            if (uri == null) {
                return null;
            }
            ImageDescriptor base = this.getBaseColumnImageDescriptor(uri);
            return URIHelper.isReadableURI((String)uri, (boolean)false) ? base : this.buildErrorImageDescriptor(base);
        }

        protected ImageDescriptor getBaseColumnImageDescriptor(String uri) {
            if ((uri = uri.toLowerCase()).endsWith("dtd")) {
                return JptJaxbUiImages.DTD_FILE;
            }
            if (uri.endsWith("xsd")) {
                return JptJaxbUiImages.XSD_FILE;
            }
            return JptCommonUiImages.FILE;
        }

        protected ImageDescriptor buildErrorImageDescriptor(ImageDescriptor imageDescriptor) {
            return new OverlayImageDescriptor(imageDescriptor, JptCommonUiImages.ERROR_OVERLAY, 2);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CatalogEntryLabelTextTransformer
    implements PluggableTextTableLabelProvider.TextTransformer<Object> {
        protected CatalogEntryLabelTextTransformer() {
        }

        public String transform(Object element, int columnIndex) {
            return element instanceof ICatalogEntry ? this.transform((ICatalogEntry)element, columnIndex) : null;
        }

        protected String transform(ICatalogEntry catalogEntry, int columnIndex) {
            return columnIndex == 0 ? catalogEntry.getKey() : URIHelper.removePlatformResourceProtocol((String)catalogEntry.getURI());
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    class XMLCatalogTableViewerFilter
    extends ViewerFilter {
        protected String[] extensions;

        public XMLCatalogTableViewerFilter(String[] extensions) {
            this.extensions = extensions;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = false;
            if (element instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)element;
                int i = 0;
                while (i < this.extensions.length) {
                    if (catalogEntry.getURI().endsWith(this.extensions[i])) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
            return result;
        }
    }
}

