/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private final Map<String, Image> imageByUrl = new HashMap<String, Image>();
    private URL base;
    private Image missingImage;
    private boolean disposed = false;

    public Image getImage(String url) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        Image image = this.imageByUrl.get(url);
        if (image == null) {
            try {
                URL location = this.base == null ? new URL(url) : new URL(this.base, url);
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)location);
                image = descriptor.createImage(false);
                if (image == null) {
                    image = this.getMissingImage();
                }
                this.imageByUrl.put(url, image);
            }
            catch (MalformedURLException malformedURLException) {
                image = this.getMissingImage();
                this.imageByUrl.put(url, image);
            }
        }
        return image;
    }

    public void putImage(String url, Image image) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        Image previous = this.imageByUrl.put(url, image);
        if (previous != null && previous != this.missingImage) {
            previous.dispose();
        }
    }

    public Image getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.createFromURL((URL)ImageCache.class.getResource("resources/missing-image.png")).createImage();
        }
        return this.missingImage;
    }

    public void dispose() {
        this.disposed = true;
        for (Image image : this.imageByUrl.values()) {
            if (image == this.missingImage) continue;
            image.dispose();
        }
        this.imageByUrl.clear();
        if (this.missingImage != null) {
            this.missingImage.dispose();
            this.missingImage = null;
        }
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        this.base = base;
    }
}

