/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2014
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();

    public BP2014(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private String getSOAPBindingStyle(Binding binding) {
        String style = null;
        List list = binding.getExtensibilityElements();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof SOAPBinding) {
                style = ((SOAPBinding)list.get(i)).getStyle();
                break;
            }
            ++i;
        }
        if (style == null) {
            style = "document";
        }
        return style;
    }

    private SOAPBody getSOAPBody(List list) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof SOAPBody) {
                return (SOAPBody)list.get(i);
            }
            ++i;
        }
        return null;
    }

    private SOAPOperation getSOAPOperation(List list) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof SOAPOperation) {
                return (SOAPOperation)list.get(i);
            }
            ++i;
        }
        return null;
    }

    private boolean checkRpcLiteral(BindingOperation oper, Binding binding) {
        String style;
        List list = oper.getExtensibilityElements();
        SOAPOperation sop = this.getSOAPOperation(list);
        if (sop == null) {
            return false;
        }
        String string = style = sop.getStyle() == null ? this.getSOAPBindingStyle(binding) : sop.getStyle();
        if (!style.equals("rpc")) {
            return false;
        }
        list = oper.getBindingOutput().getExtensibilityElements();
        SOAPBody body = this.getSOAPBody(list);
        if (body == null) {
            return false;
        }
        String use = body.getUse();
        if (use == null) {
            return false;
        }
        return use.equals("literal");
    }

    public void visit(Operation obj, Object parent, WSDLTraversalContext ctx) {
        Binding[] bindings = this.validator.analyzerContext.getCandidateInfo().getBindings();
        if (obj.getParameterOrdering() == null) {
            this.result = "notApplicable";
            return;
        }
        if (bindings == null || obj == null) {
            this.result = "notApplicable";
            return;
        }
        if (obj.getOutput() == null) {
            this.result = "notApplicable";
            return;
        }
        if (obj.getOutput().getMessage() == null) {
            this.result = "notApplicable";
            return;
        }
        int i = 0;
        while (i < bindings.length) {
            List list = bindings[i].getBindingOperations();
            int j = 0;
            while (j < list.size()) {
                BindingOperation oper = (BindingOperation)list.get(j);
                if (obj.getName() != null && oper.getName() != null) {
                    if (obj.getName().equals(oper.getName())) {
                        if (this.checkRpcLiteral(oper, bindings[i])) {
                            List parts = obj.getParameterOrdering();
                            Output output = null;
                            Message message = null;
                            Map messageParts = null;
                            output = obj.getOutput();
                            if (output != null && (message = output.getMessage()) != null) {
                                messageParts = message.getParts();
                            }
                            if (parts != null && messageParts != null) {
                                int partCount = 0;
                                Iterator iterator = parts.iterator();
                                while (iterator.hasNext()) {
                                    String partName = (String)iterator.next();
                                    if (!messageParts.containsKey(partName)) continue;
                                    ++partCount;
                                }
                                if (partCount == messageParts.size() || partCount == messageParts.size() - 1) {
                                    this.result = "passed";
                                } else {
                                    this.errors.add(obj.getName());
                                    ctx.cancelOperationProcessing();
                                }
                                return;
                            }
                            this.result = parts == null ? "notApplicable" : "passed";
                            return;
                        }
                        this.result = "notApplicable";
                        return;
                    }
                } else {
                    this.result = "notApplicable";
                    return;
                }
                ++j;
            }
            ++i;
        }
        this.result = "notApplicable";
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitOperation(true);
        traversal.ignoreImport();
        traversal.traverse((Operation)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext, entryContext.getEntry().getEntryDetail());
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

