/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class UpstreamConfigComponent {
    private final Composite container;
    private Button configureUpstreamCheck;
    private Button mergeRadio;
    private Button rebaseRadio;
    private List<UpstreamConfigSelectionListener> listeners = new ArrayList<UpstreamConfigSelectionListener>();
    private Group upstreamConfigGroup;

    public UpstreamConfigComponent(Composite parent, int style) {
        this.container = new Composite(parent, style);
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 10).create());
        this.configureUpstreamCheck = new Button(this.container, 32);
        this.configureUpstreamCheck.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.configureUpstreamCheck.setText(UIText.UpstreamConfigComponent_ConfigureUpstreamCheck);
        this.configureUpstreamCheck.setToolTipText(UIText.UpstreamConfigComponent_ConfigureUpstreamToolTip);
        this.configureUpstreamCheck.setSelection(true);
        this.upstreamConfigGroup = new Group(this.container, 16);
        this.upstreamConfigGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(UIUtils.getControlIndent(), 0).create());
        this.upstreamConfigGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.upstreamConfigGroup.setText(UIText.UpstreamConfigComponent_PullGroup);
        this.mergeRadio = new Button((Composite)this.upstreamConfigGroup, 16);
        this.mergeRadio.setText(UIText.UpstreamConfigComponent_MergeRadio);
        this.mergeRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpstreamConfigComponent.this.upstreamConfigSelected();
            }
        });
        this.mergeRadio.setSelection(true);
        this.rebaseRadio = new Button((Composite)this.upstreamConfigGroup, 16);
        this.rebaseRadio.setText(UIText.UpstreamConfigComponent_RebaseRadio);
        this.rebaseRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpstreamConfigComponent.this.upstreamConfigSelected();
            }
        });
        this.configureUpstreamCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpstreamConfigComponent.this.updateEnabled();
                UpstreamConfigComponent.this.upstreamConfigSelected();
            }
        });
    }

    public Composite getContainer() {
        return this.container;
    }

    public void addUpstreamConfigSelectionListener(UpstreamConfigSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void setUpstreamConfig(CreateLocalBranchOperation.UpstreamConfig upstreamConfig) {
        if (upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.NONE) {
            this.configureUpstreamCheck.setSelection(false);
        } else {
            this.configureUpstreamCheck.setSelection(true);
            this.mergeRadio.setSelection(upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.MERGE);
            this.rebaseRadio.setSelection(upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE);
        }
        this.updateEnabled();
    }

    private void upstreamConfigSelected() {
        CreateLocalBranchOperation.UpstreamConfig config = this.getSelectedUpstreamConfig();
        for (UpstreamConfigSelectionListener listener : this.listeners) {
            listener.upstreamConfigSelected(config);
        }
    }

    private CreateLocalBranchOperation.UpstreamConfig getSelectedUpstreamConfig() {
        if (!this.configureUpstreamCheck.getSelection()) {
            return CreateLocalBranchOperation.UpstreamConfig.NONE;
        }
        if (this.mergeRadio.getSelection()) {
            return CreateLocalBranchOperation.UpstreamConfig.MERGE;
        }
        if (this.rebaseRadio.getSelection()) {
            return CreateLocalBranchOperation.UpstreamConfig.REBASE;
        }
        return CreateLocalBranchOperation.UpstreamConfig.NONE;
    }

    private void updateEnabled() {
        boolean enabled = this.configureUpstreamCheck.getSelection();
        this.upstreamConfigGroup.setEnabled(enabled);
        this.mergeRadio.setEnabled(enabled);
        this.rebaseRadio.setEnabled(enabled);
    }

    public static interface UpstreamConfigSelectionListener {
        public void upstreamConfigSelected(CreateLocalBranchOperation.UpstreamConfig var1);
    }
}

