/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model;

import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.tools.model.BaseJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.tools.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbsExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractDoubleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractIdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractModifyStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractRangeVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSchemaNameStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractTripleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AdditionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AggregateFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AllOrAnyExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AndExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ArithmeticFactorStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AvgFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.BadExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.BetweenExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CaseExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CoalesceExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionMemberDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionMemberExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CompoundExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ConcatExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ConstructorExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.CountFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DateTimeStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DeleteClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DeleteStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DerivedPathIdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DerivedPathVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.DivisionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EmptyCollectionComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EncapsulatedIdentificationVariableExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EntityTypeLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EntryExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.EnumTypeStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ExistsExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.FromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.FunctionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.GroupByClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.HavingClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.InExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IndexExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.InputParameterStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.JPQLQueryStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.JoinStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.KeyExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.KeywordExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LengthExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LikeExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LocateExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.LowerExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.MaxFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.MinFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ModExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.MultiplicationExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.NotExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.NullComparisonExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.NullIfExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.NumericLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ObjectExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrderByClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.OrderByItemStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.RangeVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ResultVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleSelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleSelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SimpleStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SizeExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SqrtExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateFieldPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StringLiteralStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SubExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SubstringExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SubtractionExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.SumFunctionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.TreatExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.TrimExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.TypeExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UnknownExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateItemStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpdateStatementStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.UpperExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.ValueExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.WhenClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.WhereClauseStateObject;

public abstract class AbstractActualJPQLQueryFormatter
extends BaseJPQLQueryFormatter {
    protected final boolean exactMatch;

    protected AbstractActualJPQLQueryFormatter(boolean exactMatch) {
        super(IJPQLQueryFormatter.IdentifierStyle.UPPERCASE);
        this.exactMatch = exactMatch;
    }

    protected AbstractActualJPQLQueryFormatter(boolean exactMatch, IJPQLQueryFormatter.IdentifierStyle style) {
        super(style);
        this.exactMatch = exactMatch;
    }

    protected void appendIdentifier(String actualIdentifier, String identifier) {
        if (!this.exactMatch || ExpressionTools.stringIsEmpty(actualIdentifier)) {
            actualIdentifier = this.formatIdentifier(identifier);
        }
        this.writer.append(actualIdentifier);
    }

    public boolean isUsingExactMatch() {
        return this.exactMatch;
    }

    protected boolean shouldOutput(Expression expression) {
        return !this.exactMatch || expression == null;
    }

    protected void toStringAggregateFunction(AggregateFunctionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            AggregateFunction expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append(this.formatIdentifier("("));
            }
            if (stateObject.hasDistinct()) {
                this.appendIdentifier(expression != null ? expression.getActualDistinctIdentifier() : "DISTINCT", "DISTINCT");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterDistinct()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(this.formatIdentifier(")"));
            }
        }
    }

    protected void toStringChildren(ListHolderStateObject<? extends StateObject> stateObject, boolean comma) {
        ListIterator<? extends StateObject> iter = stateObject.items().iterator();
        while (iter.hasNext()) {
            iter.next().accept(this);
            if (!iter.hasNext()) continue;
            this.writer.append(comma ? ", " : " ");
        }
    }

    protected void toStringCompound(CompoundExpressionStateObject stateObject, String identifier) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            CompoundExpression expression = stateObject.getExpression();
            if (stateObject.hasLeft()) {
                stateObject.getLeft().accept(this);
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : identifier, identifier);
            if (this.shouldOutput(expression) || expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            if (stateObject.hasRight()) {
                stateObject.getRight().accept(this);
            }
        }
    }

    protected void toStringDoubleEncapsulated(AbstractDoubleEncapsulatedExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            AbstractDoubleEncapsulatedExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            } else if (expression.hasSpaceAfterIdentifier()) {
                this.writer.append(",");
            }
            if (stateObject.hasFirst()) {
                stateObject.getFirst().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasComma()) {
                this.writer.append(",");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterComma()) {
                this.writer.append(" ");
            }
            if (stateObject.hasSecond()) {
                stateObject.getSecond().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    protected void toStringEncapsulatedIdentificationVariable(EncapsulatedIdentificationVariableExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            EncapsulatedIdentificationVariableExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            if (stateObject.hasIdentificationVariable()) {
                this.writer.append(stateObject.getIdentificationVariable());
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    protected void toStringFromClause(AbstractFromClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            AbstractFromClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "FROM", "FROM");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterFrom()) {
                this.writer.append(" ");
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
        }
    }

    protected void toStringIdentificationVariableDeclaration(AbstractIdentificationVariableDeclarationStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            IdentificationVariableDeclaration expression = stateObject.getExpression();
            stateObject.getRangeVariableDeclaration().accept(this);
            if (stateObject.hasItems()) {
                if (this.shouldOutput(expression) || expression.hasSpace()) {
                    this.writer.append(" ");
                }
                this.toStringChildren(stateObject, false);
            }
        }
    }

    protected void toStringModifyStatement(AbstractModifyStatementStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            stateObject.getModifyClause().accept(this);
            if (stateObject.hasWhereClause()) {
                this.writer.append(" ");
                stateObject.getWhereClause().accept(this);
            }
        }
    }

    protected void toStringPathExpression(AbstractPathExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            stateObject.toText(this.writer);
        }
    }

    protected void toStringRangeVariableDeclaration(AbstractRangeVariableDeclarationStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            RangeVariableDeclaration expression = stateObject.getExpression();
            stateObject.getRootStateObject().accept(this);
            if (this.exactMatch && expression != null && expression.hasSpaceAfterRootObject()) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                if (!this.exactMatch || expression == null) {
                    this.writer.append(" ");
                }
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
            }
            if (this.exactMatch && expression != null && expression.hasSpaceAfterAs()) {
                this.writer.append(" ");
            }
            if (stateObject.hasIdentificationVariable() && !stateObject.isIdentificationVariableVirtual()) {
                if (!this.exactMatch || expression == null) {
                    this.writer.append(" ");
                }
                this.writer.append(stateObject.getIdentificationVariable());
            }
        }
    }

    protected boolean toStringSelectStatement(AbstractSelectStatementStateObject stateObject) {
        AbstractSelectStatement expression = stateObject.getExpression();
        boolean spaceAdded = false;
        stateObject.getSelectClause().accept(this);
        if (this.shouldOutput(expression) || expression.hasSpaceAfterSelect() || stateObject.getSelectClause().hasSelectItem()) {
            this.writer.append(" ");
        }
        stateObject.getFromClause().accept(this);
        if (this.exactMatch && expression != null && expression.hasSpaceAfterFrom() || stateObject.hasWhereClause()) {
            this.writer.append(" ");
            spaceAdded = true;
        }
        if (stateObject.hasWhereClause()) {
            stateObject.getWhereClause().accept(this);
            spaceAdded = false;
        }
        if ((this.exactMatch && expression != null && expression.hasSpaceAfterWhere() || stateObject.hasGroupByClause()) && !spaceAdded) {
            this.writer.append(" ");
            spaceAdded = true;
        }
        if (stateObject.hasGroupByClause()) {
            stateObject.getGroupByClause().accept(this);
            spaceAdded = false;
        }
        if ((this.exactMatch && expression != null && expression.hasSpaceAfterGroupBy() || stateObject.hasHavingClause()) && !spaceAdded) {
            this.writer.append(" ");
            spaceAdded = true;
        }
        if (stateObject.hasHavingClause()) {
            stateObject.getHavingClause().accept(this);
            spaceAdded = true;
        }
        return spaceAdded;
    }

    protected void toStringSimpleStateObject(SimpleStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else if (stateObject.hasText()) {
            this.writer.append(stateObject.getText());
        }
    }

    protected void toStringSingleEncapsulated(AbstractSingleEncapsulatedExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            AbstractSingleEncapsulatedExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    protected void toStringTripleEncapsulated(AbstractTripleEncapsulatedExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            AbstractTripleEncapsulatedExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            if (stateObject.hasFirst()) {
                stateObject.getFirst().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasFirstComma()) {
                this.writer.append(",");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterFirstComma()) {
                this.writer.append(" ");
            }
            if (stateObject.hasSecond()) {
                stateObject.getSecond().accept(this);
            }
            if (stateObject.hasThird()) {
                if (this.shouldOutput(expression) || expression.hasSecondComma()) {
                    this.writer.append(",");
                }
                if (this.shouldOutput(expression) || expression.hasSpaceAfterSecondComma()) {
                    this.writer.append(" ");
                }
                stateObject.getThird().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(AbsExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(AbstractSchemaNameStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(AdditionExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "+");
    }

    @Override
    public void visit(AllOrAnyExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(AndExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "AND");
    }

    @Override
    public void visit(ArithmeticFactorStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            this.writer.append(stateObject.getArithmeticSign());
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
        }
    }

    @Override
    public void visit(AvgFunctionStateObject stateObject) {
        this.toStringAggregateFunction(stateObject);
    }

    @Override
    public void visit(BadExpressionStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(BetweenExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            BetweenExpression expression = stateObject.getExpression();
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
                this.writer.append(" ");
            }
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualBetweenIdentifier() : "BETWEEN", "BETWEEN");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterBetween()) {
                this.writer.append(" ");
            }
            if (stateObject.hasLowerBound()) {
                stateObject.getLowerBound().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterLowerBound()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasAnd()) {
                this.appendIdentifier(expression != null ? expression.getActualAndIdentifier() : "AND", "AND");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterAnd()) {
                this.writer.append(" ");
            }
            if (stateObject.hasUpperBound()) {
                stateObject.getUpperBound().accept(this);
            }
        }
    }

    @Override
    public void visit(CaseExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            CaseExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualCaseIdentifier() : "CASE", "CASE");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterCase()) {
                this.writer.append(" ");
            }
            if (stateObject.hasCaseOperand()) {
                stateObject.getCaseOperand().accept(this);
                if (this.shouldOutput(expression) || expression.hasSpaceAfterCaseOperand()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, false);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterWhenClauses()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasElse()) {
                this.appendIdentifier(expression != null ? expression.getActualElseIdentifier() : "ELSE", "ELSE");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterElse()) {
                this.writer.append(" ");
            }
            if (stateObject.hasElse()) {
                stateObject.getElse().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterElseExpression()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasEnd()) {
                this.appendIdentifier(expression != null ? expression.getActualEndIdentifier() : "END", "END");
            }
        }
    }

    @Override
    public void visit(CoalesceExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            CoalesceExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "COALESCE", "COALESCE");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            } else if (expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            this.toStringChildren(stateObject, true);
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(CollectionMemberDeclarationStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            CollectionMemberDeclaration expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualInIdentifier() : "IN", "IN");
            if (!stateObject.isDerived() && (this.shouldOutput(expression) || expression.hasLeftParenthesis())) {
                this.writer.append("(");
            } else if (stateObject.isDerived() && (this.shouldOutput(expression) || expression.hasSpaceAfterIn())) {
                this.writer.append(" ");
            }
            stateObject.getCollectionValuedPath().accept(this);
            if (!stateObject.isDerived() && (this.shouldOutput(expression) || expression.hasRightParenthesis())) {
                this.writer.append(")");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterRightParenthesis()) {
                    this.writer.append(" ");
                }
            } else if (stateObject.isDerived() && stateObject.hasAs() && (this.shouldOutput(expression) || expression.hasSpaceAfterRightParenthesis())) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterAs()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasIdentificationVariable()) {
                stateObject.getIdentificationVariable().accept(this);
            }
        }
    }

    @Override
    public void visit(CollectionMemberExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            CollectionMemberExpression expression = stateObject.getExpression();
            if (stateObject.hasEntityStateObject()) {
                stateObject.getEntityStateObject().accept(this);
                this.writer.append(" ");
            }
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualMemberIdentifier() : "MEMBER", "MEMBER");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterMember()) {
                this.writer.append(" ");
            }
            if (stateObject.hasOf()) {
                this.appendIdentifier(expression != null ? expression.getActualOfIdentifier() : "OF", "OF");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterOf()) {
                    this.writer.append(" ");
                }
            }
            stateObject.getCollectionValuedPath().accept(this);
        }
    }

    @Override
    public void visit(CollectionValuedPathExpressionStateObject stateObject) {
        this.toStringPathExpression(stateObject);
    }

    @Override
    public void visit(ComparisonExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, stateObject.getIdentifier());
    }

    @Override
    public void visit(ConcatExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            ConcatExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "CONCAT", "CONCAT");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            this.toStringChildren(stateObject, true);
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(ConstructorExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            ConstructorExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "NEW", "NEW");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterNew()) {
                this.writer.append(" ");
            }
            this.writer.append(stateObject.getClassName());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            this.toStringChildren(stateObject, true);
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(CountFunctionStateObject stateObject) {
        this.toStringAggregateFunction(stateObject);
    }

    @Override
    public void visit(DateTimeStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            DateTime expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getText(), stateObject.getText());
        }
    }

    @Override
    public void visit(DeleteClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            DeleteClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualDeleteIdentifier() : "DELETE", "DELETE");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterDelete()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasFrom()) {
                this.appendIdentifier(expression != null ? expression.getActualFromIdentifier() : "FROM", "FROM");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterFrom()) {
                this.writer.append(" ");
            }
            stateObject.getRangeVariableDeclaration().accept(this);
        }
    }

    @Override
    public void visit(DeleteStatementStateObject stateObject) {
        this.toStringModifyStatement(stateObject);
    }

    @Override
    public void visit(DerivedPathIdentificationVariableDeclarationStateObject stateObject) {
        this.toStringIdentificationVariableDeclaration(stateObject);
    }

    @Override
    public void visit(DerivedPathVariableDeclarationStateObject stateObject) {
        this.toStringRangeVariableDeclaration(stateObject);
    }

    @Override
    public void visit(DivisionExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "/");
    }

    @Override
    public void visit(EmptyCollectionComparisonExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            EmptyCollectionComparisonExpression expression = stateObject.getExpression();
            stateObject.getStateObject().accept(this);
            this.writer.append(" ");
            this.appendIdentifier(expression != null ? expression.getActualIsIdentifier() : "IS", "IS");
            this.writer.append(" ");
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualEmptyIdentifier() : "EMPTY", "EMPTY");
        }
    }

    @Override
    public void visit(EntityTypeLiteralStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(EntryExpressionStateObject stateObject) {
        this.toStringEncapsulatedIdentificationVariable(stateObject);
    }

    @Override
    public void visit(EnumTypeStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(ExistsExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            String actualIdentifier;
            ExistsExpression expression = stateObject.getExpression();
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            String string = actualIdentifier = expression != null ? expression.getActualIdentifier() : null;
            if (actualIdentifier != null && actualIdentifier.startsWith("NOT")) {
                actualIdentifier = actualIdentifier.substring(4);
            }
            this.appendIdentifier(actualIdentifier, "EXISTS");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append(this.formatIdentifier("("));
            }
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(this.formatIdentifier(")"));
            }
        }
    }

    @Override
    public void visit(FromClauseStateObject stateObject) {
        this.toStringFromClause(stateObject);
    }

    @Override
    public void visit(FunctionExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            FunctionExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "FUNC", "FUNC");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            } else if (this.exactMatch && expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            if (stateObject.hasFunctionName()) {
                this.writer.append(stateObject.getQuotedFunctionName());
                if (this.shouldOutput(expression) || expression.hasComma()) {
                    this.writer.append(",");
                }
                if (this.shouldOutput(expression) || expression.hasSpaceAfterComma()) {
                    this.writer.append(" ");
                }
            }
            this.toStringChildren(stateObject, true);
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(GroupByClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            GroupByClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "GROUP BY", "GROUP BY");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterGroupBy()) {
                this.writer.append(" ");
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
        }
    }

    @Override
    public void visit(HavingClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            HavingClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "HAVING", "HAVING");
            if (this.exactMatch && expression != null && expression.hasSpaceAfterIdentifier() || stateObject.hasConditional()) {
                this.writer.append(" ");
            }
            if (stateObject.hasConditional()) {
                stateObject.getConditional().accept(this);
            }
        }
    }

    @Override
    public void visit(IdentificationVariableDeclarationStateObject stateObject) {
        this.toStringIdentificationVariableDeclaration(stateObject);
    }

    @Override
    public void visit(IdentificationVariableStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(IndexExpressionStateObject stateObject) {
        this.toStringEncapsulatedIdentificationVariable(stateObject);
    }

    @Override
    public void visit(InExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            InExpression expression = stateObject.getExpression();
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
                this.writer.append(" ");
            }
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualInIdentifier() : "IN", "IN");
            if (!stateObject.isSingleInputParameter()) {
                this.writer.append("(");
            } else if (this.shouldOutput(expression) || expression.hasSpaceAfterIn()) {
                this.writer.append(" ");
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
            if (!stateObject.isSingleInputParameter()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(InputParameterStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(JoinStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            Join expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getJoinType(), stateObject.getJoinType());
            if (this.shouldOutput(expression) || expression.hasSpaceAfterJoin()) {
                this.writer.append(" ");
            }
            stateObject.getJoinAssociationPathStateObject().accept(this);
            if (stateObject.hasFetch()) {
                if (expression.hasAs()) {
                    this.writer.append(" ");
                }
            } else if (this.shouldOutput(expression) || expression.hasSpaceAfterJoinAssociation()) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterAs()) {
                    this.writer.append(" ");
                }
            }
            stateObject.getIdentificationVariableStateObject().accept(this);
        }
    }

    @Override
    public void visit(JPQLQueryStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else if (stateObject.hasQueryStatement()) {
            stateObject.getQueryStatement().accept(this);
        }
    }

    @Override
    public void visit(KeyExpressionStateObject stateObject) {
        this.toStringEncapsulatedIdentificationVariable(stateObject);
    }

    @Override
    public void visit(KeywordExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            KeywordExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getText(), stateObject.getText());
        }
    }

    @Override
    public void visit(LengthExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(LikeExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            LikeExpression expression = stateObject.getExpression();
            if (stateObject.hasStringStateObject()) {
                stateObject.getStringStateObject().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterStringExpression()) {
                this.writer.append(" ");
            }
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualLikeIdentifier() : "LIKE", "LIKE");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterLike()) {
                this.writer.append(" ");
            }
            if (stateObject.hasPatternValue()) {
                stateObject.getPatternValue().accept(this);
            }
            if (this.exactMatch && expression != null && expression.hasSpaceAfterPatternValue()) {
                this.writer.append(" ");
            }
            if (stateObject.hasEscapeCharacter()) {
                if (!this.exactMatch) {
                    this.writer.append(" ");
                }
                this.appendIdentifier(expression != null ? expression.getActualEscapeIdentifier() : "ESCAPE", "ESCAPE");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterEscape()) {
                    this.writer.append(" ");
                }
                this.writer.append(stateObject.getEscapeCharacter());
            }
        }
    }

    @Override
    public void visit(LocateExpressionStateObject stateObject) {
        this.toStringTripleEncapsulated(stateObject);
    }

    @Override
    public void visit(LowerExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(MaxFunctionStateObject stateObject) {
        this.toStringAggregateFunction(stateObject);
    }

    @Override
    public void visit(MinFunctionStateObject stateObject) {
        this.toStringAggregateFunction(stateObject);
    }

    @Override
    public void visit(ModExpressionStateObject stateObject) {
        this.toStringDoubleEncapsulated(stateObject);
    }

    @Override
    public void visit(MultiplicationExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "*");
    }

    @Override
    public void visit(NotExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            NotExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "NOT", "NOT");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterNot()) {
                this.writer.append(" ");
            }
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
        }
    }

    @Override
    public void visit(NullComparisonExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            NullComparisonExpression expression = stateObject.getExpression();
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualIsIdentifier() : "IS", "IS");
            this.writer.append(" ");
            if (stateObject.hasNot()) {
                this.appendIdentifier(expression != null ? expression.getActualNotIdentifier() : "NOT", "NOT");
                this.writer.append(" ");
            }
            this.appendIdentifier(expression != null ? expression.getActualNullIdentifier() : "NULL", "NULL");
        }
    }

    @Override
    public void visit(NullIfExpressionStateObject stateObject) {
        this.toStringDoubleEncapsulated(stateObject);
    }

    @Override
    public void visit(NumericLiteralStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(ObjectExpressionStateObject stateObject) {
        this.toStringEncapsulatedIdentificationVariable(stateObject);
    }

    @Override
    public void visit(OrderByClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            OrderByClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "ORDER BY", "ORDER BY");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
        }
    }

    @Override
    public void visit(OrderByItemStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            OrderByItem expression = stateObject.getExpression();
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (!stateObject.isDefault()) {
                String actualOrdering;
                if (this.shouldOutput(expression) || expression.hasSpaceAfterExpression()) {
                    this.writer.append(" ");
                }
                String ordering = stateObject.getOrdering().name();
                String string = actualOrdering = expression != null ? expression.getActualOrdering() : null;
                if (!ordering.equalsIgnoreCase(actualOrdering)) {
                    actualOrdering = ordering;
                }
                this.appendIdentifier(actualOrdering, ordering);
            }
        }
    }

    @Override
    public void visit(OrExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "OR");
    }

    @Override
    public void visit(RangeVariableDeclarationStateObject stateObject) {
        this.toStringRangeVariableDeclaration(stateObject);
    }

    @Override
    public void visit(ResultVariableStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            ResultVariable expression = stateObject.getExpression();
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (this.exactMatch && expression != null && expression.hasSelectExpression()) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                if (!this.exactMatch || expression == null) {
                    this.writer.append(" ");
                }
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
            }
            if (this.exactMatch && expression != null && expression.hasSpaceAfterAs()) {
                this.writer.append(" ");
            }
            if (stateObject.hasResultVariable()) {
                if (!this.exactMatch || expression == null) {
                    this.writer.append(" ");
                }
                this.writer.append(stateObject.getResultVariable());
            }
        }
    }

    @Override
    public void visit(SelectClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            SelectClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "SELECT", "SELECT");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterSelect()) {
                this.writer.append(" ");
            }
            if (stateObject.hasDistinct()) {
                this.appendIdentifier(expression != null ? expression.getActualDistinctIdentifier() : "DISTINCT", "DISTINCT");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterDistinct()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
        }
    }

    @Override
    public void visit(SelectStatementStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            boolean endWithSpace = this.toStringSelectStatement(stateObject);
            SelectStatement expression = stateObject.getExpression();
            if ((this.exactMatch && expression != null && expression.hasSpaceBeforeOrderBy() || stateObject.hasOrderByClause()) && !endWithSpace) {
                this.writer.append(" ");
            }
            if (stateObject.hasOrderByClause()) {
                stateObject.getOrderByClause().accept(this);
            }
        }
    }

    @Override
    public void visit(SimpleFromClauseStateObject stateObject) {
        this.toStringFromClause(stateObject);
    }

    @Override
    public void visit(SimpleSelectClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            SimpleSelectClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "SELECT", "SELECT");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterSelect()) {
                this.writer.append(" ");
            }
            if (stateObject.hasDistinct()) {
                this.appendIdentifier(expression != null ? expression.getActualDistinctIdentifier() : "DISTINCT", "DISTINCT");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterDistinct()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasSelectItem()) {
                stateObject.getSelectItem().accept(this);
            }
        }
    }

    @Override
    public void visit(SimpleSelectStatementStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            this.toStringSelectStatement(stateObject);
        }
    }

    @Override
    public void visit(SizeExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(SqrtExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(StateFieldPathExpressionStateObject stateObject) {
        this.toStringPathExpression(stateObject);
    }

    @Override
    public void visit(StringLiteralStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(SubExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(SubstringExpressionStateObject stateObject) {
        this.toStringTripleEncapsulated(stateObject);
    }

    @Override
    public void visit(SubtractionExpressionStateObject stateObject) {
        this.toStringCompound(stateObject, "-");
    }

    @Override
    public void visit(SumFunctionStateObject stateObject) {
        this.toStringAggregateFunction(stateObject);
    }

    @Override
    public void visit(TreatExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            TreatExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "TREAT", "TREAT");
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            }
            stateObject.getJoinAssociationPathStateObject().accept(this);
            if (this.shouldOutput(expression) || expression.hasSpaceAfterCollectionValuedPathExpression()) {
                this.writer.append(" ");
            }
            if (stateObject.hasAs()) {
                this.appendIdentifier(expression != null ? expression.getActualAsIdentifier() : "AS", "AS");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterAs()) {
                    this.writer.append(" ");
                }
            }
            this.writer.append(stateObject.getEntityTypeName());
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(TrimExpressionStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            TrimExpression expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : stateObject.getIdentifier(), stateObject.getIdentifier());
            if (this.shouldOutput(expression) || expression.hasLeftParenthesis()) {
                this.writer.append("(");
            } else if (expression != null && expression.hasSpaceAfterIdentifier()) {
                this.writer.append(" ");
            }
            if (stateObject.hasSpecification()) {
                String actualSpecification;
                String specification = stateObject.getSpecification().name();
                String string = actualSpecification = expression != null ? expression.getActualSpecificationIdentifier() : null;
                if (!specification.equalsIgnoreCase(actualSpecification)) {
                    actualSpecification = specification;
                }
                this.appendIdentifier(actualSpecification, specification);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterSpecification()) {
                this.writer.append(" ");
            }
            if (stateObject.hasTrimCharacter()) {
                stateObject.getTrimCharacter().accept(this);
                if (this.shouldOutput(expression) || expression.hasSpaceAfterTrimCharacter()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasSpecification() || stateObject.hasTrimCharacter()) {
                this.appendIdentifier(expression != null ? expression.getActualFromIdentifier() : "FROM", "FROM");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterFrom()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasStateObject()) {
                stateObject.getStateObject().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasRightParenthesis()) {
                this.writer.append(")");
            }
        }
    }

    @Override
    public void visit(TypeExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(UnknownExpressionStateObject stateObject) {
        this.toStringSimpleStateObject(stateObject);
    }

    @Override
    public void visit(UpdateClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            UpdateClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualUpdateIdentifier() : "UPDATE", "UPDATE");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterUpdate()) {
                this.writer.append(" ");
            }
            stateObject.getRangeVariableDeclaration().accept(this);
            if (this.shouldOutput(expression) || expression.hasSpaceAfterRangeVariableDeclaration()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasSet()) {
                this.appendIdentifier(expression != null ? expression.getActualSetIdentifier() : "SET", "SET");
                if (this.shouldOutput(expression) || expression.hasSpaceAfterSet()) {
                    this.writer.append(" ");
                }
            }
            if (stateObject.hasItems()) {
                this.toStringChildren(stateObject, true);
            }
        }
    }

    @Override
    public void visit(UpdateItemStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            UpdateItem expression = stateObject.getExpression();
            stateObject.getStateFieldPath().accept(this);
            if (this.shouldOutput(expression) || expression.hasSpaceAfterStateFieldPathExpression()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasEqualSign()) {
                this.writer.append("=");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterEqualSign()) {
                this.writer.append(" ");
            }
            if (stateObject.hasNewValue()) {
                stateObject.getNewValue().accept(this);
            }
        }
    }

    @Override
    public void visit(UpdateStatementStateObject stateObject) {
        this.toStringModifyStatement(stateObject);
    }

    @Override
    public void visit(UpperExpressionStateObject stateObject) {
        this.toStringSingleEncapsulated(stateObject);
    }

    @Override
    public void visit(ValueExpressionStateObject stateObject) {
        this.toStringEncapsulatedIdentificationVariable(stateObject);
    }

    @Override
    public void visit(WhenClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            WhenClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualWhenIdentifier() : "WHEN", "WHEN");
            if (this.shouldOutput(expression) || expression.hasSpaceAfterWhen()) {
                this.writer.append(" ");
            }
            if (stateObject.hasConditional()) {
                stateObject.getConditional().accept(this);
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterWhenExpression()) {
                this.writer.append(" ");
            }
            if (this.shouldOutput(expression) || expression.hasThen()) {
                this.appendIdentifier(expression != null ? expression.getActualThenIdentifier() : "THEN", "THEN");
            }
            if (this.shouldOutput(expression) || expression.hasSpaceAfterThen()) {
                this.writer.append(" ");
            }
            if (stateObject.hasThen()) {
                stateObject.getThen().accept(this);
            }
        }
    }

    @Override
    public void visit(WhereClauseStateObject stateObject) {
        if (stateObject.isDecorated()) {
            this.toText(stateObject);
        } else {
            WhereClause expression = stateObject.getExpression();
            this.appendIdentifier(expression != null ? expression.getActualIdentifier() : "WHERE", "WHERE");
            if (this.exactMatch && expression != null && expression.hasSpaceAfterIdentifier() || stateObject.hasConditional()) {
                this.writer.append(" ");
            }
            if (stateObject.hasConditional()) {
                stateObject.getConditional().accept(this);
            }
        }
    }
}

