/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.Logger;

public class FileContentCache {
    static final boolean DEBUG = false;
    static FileContentCache instance = new FileContentCache();
    private LinkedHashMap fContentMap = new LimitedHashMap();

    public static FileContentCache getInstance() {
        return instance;
    }

    private FileContentCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        LinkedHashMap linkedHashMap = this.fContentMap;
        synchronized (linkedHashMap) {
            Iterator iterator = this.fContentMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getValue() == null || ((Reference)entry.getValue()).get() != null) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContents(IPath filePath) {
        IDocument document;
        ITextFileBuffer existingBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(filePath, LocationKind.NORMALIZE);
        if (existingBuffer != null && (document = existingBuffer.getDocument()) != null) {
            return document.get();
        }
        CacheEntry entry = null;
        Object o = this.fContentMap.get(filePath);
        if (o instanceof Reference) {
            entry = (CacheEntry)((Reference)o).get();
        }
        if (entry == null || entry.isStale()) {
            entry = new CacheEntry(filePath);
            LinkedHashMap linkedHashMap = this.fContentMap;
            synchronized (linkedHashMap) {
                this.fContentMap.put(filePath, new SoftReference<CacheEntry>(entry));
            }
        }
        this.cleanup();
        return entry.contents;
    }

    private static class CacheEntry {
        String contents;
        long modificationStamp = -1L;
        IPath contentPath;

        CacheEntry(IPath path) {
            this.contentPath = path;
            this.modificationStamp = this.getModificationStamp(path);
            this.contents = this.readContents(path);
        }

        private IFile getFile(IPath path) {
            if (path.segmentCount() > 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
            return null;
        }

        boolean isStale() {
            if (this.modificationStamp == -1L) {
                return true;
            }
            long newStamp = this.getModificationStamp(this.contentPath);
            return newStamp > this.modificationStamp;
        }

        private String detectCharset(String name, byte[] contents) throws IOException {
            IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((InputStream)new ByteArrayInputStream(contents), name, new QualifiedName[]{IContentDescription.CHARSET});
            if (description != null) {
                String charset = description.getCharset();
                if (charset == null && description.getContentType() != null) {
                    charset = description.getContentType().getDefaultCharset();
                }
                if (charset != null) {
                    return charset;
                }
            }
            return ResourcesPlugin.getEncoding();
        }

        private long getModificationStamp(IPath filePath) {
            IFile f = this.getFile(filePath);
            if (f != null && f.isAccessible()) {
                return f.getModificationStamp();
            }
            File file = filePath.toFile();
            if (file.exists()) {
                return file.lastModified();
            }
            return -1L;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String readContents(IPath filePath) {
            is = null;
            try {
                try {
                    f = this.getFile(filePath);
                    is = f != null && f.isAccessible() != false ? f.getContents() : new FileInputStream(filePath.toFile());
                    store = new ByteArrayOutputStream();
                    readBuffer = new byte[8092];
                    n = is.read(readBuffer);
                    while (true) {
                        if (n <= 0) {
                            bytes = store.toByteArray();
                            charset = this.detectCharset(filePath.lastSegment(), bytes);
                            buffer = ByteBuffer.wrap(bytes);
                            try {
                                charBuffer = Charset.forName(charset).decode(buffer);
                                var13_12 = charBuffer.toString();
                                ** break;
                            }
                            catch (IllegalCharsetNameException v0) {
                                var13_13 = new String(bytes, charset);
                                var11_16 = null;
                                try {
                                    if (is == null) return var13_13;
                                    is.close();
                                    return var13_13;
                                }
                                catch (Exception v1) {}
                                return var13_13;
                            }
                            catch (UnsupportedCharsetException v2) {
                                var13_14 = new String(bytes, charset);
                                var11_17 = null;
                                try {}
                                catch (Exception v3) {}
                                if (is == null) return var13_14;
                                is.close();
                                return var13_14;
                                return var13_14;
                            }
                        }
                        store.write(readBuffer, 0, n);
                        n = is.read(readBuffer);
                    }
lbl42:
                    // 1 sources

                    var11_15 = null;
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    ** GOTO lbl-1000
                }
                catch (Exception v4) {
                    ** GOTO lbl-1000
                }
            }
            catch (Throwable var12_20) {
                var11_18 = null;
                try {}
                catch (Exception v5) {}
                if (is == null) throw var12_20;
                is.close();
                throw var12_20;
                throw var12_20;
            }
            try {}
            catch (Exception v6) {}
            if (is == null) return var13_12;
            is.close();
            return var13_12;
            return var13_12;
lbl-1000:
            // 2 sources

            {
                var11_19 = null;
            }
            try {}
            catch (Exception v7) {
                return null;
            }
            if (is == null) return null;
            is.close();
            return null;
        }
    }

    static class LimitedHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        LimitedHashMap() {
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 25;
        }
    }
}

