/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.Messages;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.HtmlParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.xml.sax.InputSource;

public class HtmlToMarkupTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    protected File file;
    protected String outputFilenameFormat = "$1.$2";
    protected boolean overwrite = true;

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.1"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToHtmlTask.2"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.3"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.4"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.5"), this.file));
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.11"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.12"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processFile(MarkupLanguage markupLanguage, File folder, File source) {
        File outputFile;
        String name;
        this.log(MessageFormat.format(Messages.getString("MarkupToHtmlTask.14"), source), 3);
        if (this.isValidate()) {
            this.log(MessageFormat.format(Messages.getString("HtmlToMarkupTask.1"), source), 1);
        }
        if ((name = source.getName()).lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(outputFile = this.computeTargetFile(markupLanguage, source, name)).exists() || this.overwrite || outputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.16"), outputFile, e.getMessage()), (Throwable)e);
            }
            try {
                InputStreamReader input;
                BufferedInputStream in;
                DocumentBuilder builder = markupLanguage.createDocumentBuilder((Writer)writer);
                try {
                    in = new BufferedInputStream(new FileInputStream(source));
                    input = this.getSourceEncoding() == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, this.getSourceEncoding());
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.cannotReadSource"), source, e.getMessage()), (Throwable)e);
                }
                try {
                    try {
                        new HtmlParser().parse(new InputSource(input), builder);
                    }
                    catch (Exception e) {
                        throw new BuildException(MessageFormat.format(Messages.getString("HtmlToMarkupTask.failedToProcessContent"), source, e.getMessage()), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {
                        throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.cannotReadSource"), source, e.getMessage()), (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.cannotReadSource"), source, e.getMessage()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.17"), outputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToHtmlTask.17"), outputFile, e.getMessage()), (Throwable)e);
            }
        }
    }

    private File computeTargetFile(MarkupLanguage markupLanguage, File source, String name) {
        return new File(source.getParentFile(), this.outputFilenameFormat.replace("$1", name).replace("$2", markupLanguage.getName().toLowerCase()));
    }

    public String getOutputFilenameFormat() {
        return this.outputFilenameFormat;
    }

    public void setOutputFilenameFormat(String outputFilenameFormat) {
        this.outputFilenameFormat = outputFilenameFormat;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }
}

