/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesGroupKey;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private JavaScriptUnit fRoot;
    private Name fSelectedNode;
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();
    private boolean fTargetIsStaticMethodImport;

    public OccurrencesFinder(IBinding target) {
        super(true);
        this.fTarget = target;
    }

    public OccurrencesFinder() {
        super(true);
    }

    @Override
    public String initialize(JavaScriptUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(JavaScriptUnit root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (Name)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return SearchMessages.OccurrencesFinder_no_binding;
        }
        this.fTarget = this.getBindingDeclaration(this.fTarget);
        this.fTargetIsStaticMethodImport = OccurrencesFinder.isStaticImport(this.fSelectedNode.getParent());
        return null;
    }

    @Override
    public List perform() {
        this.fRoot.accept((ASTVisitor)this);
        return this.fUsages;
    }

    @Override
    public void collectOccurrenceMatches(IJavaScriptElement element, IDocument document, Collection resultingMatches) {
        boolean isVariable = this.fTarget instanceof IVariableBinding;
        HashMap<Integer, OccurrencesGroupKey> lineToGroup = new HashMap<Integer, OccurrencesGroupKey>();
        for (ASTNode node : this.fUsages) {
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                boolean isWriteAccess = this.fWriteUsages.contains(node);
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                OccurrencesGroupKey groupKey = (OccurrencesGroupKey)lineToGroup.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new OccurrencesGroupKey(element, line, lineContents, isWriteAccess, isVariable);
                    lineToGroup.put(lineInteger, groupKey);
                } else if (isWriteAccess) {
                    groupKey.setWriteAccess(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedNode);
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            SimpleName name = node.getName();
            return !this.match((Name)name, this.fUsages, name.resolveBinding());
        }
        if (binding instanceof IFunctionBinding && OccurrencesFinder.isStaticImport((ASTNode)node)) {
            SimpleName name = node.getName();
            return !this.matchStaticImport((Name)name, this.fUsages, (IFunctionBinding)binding);
        }
        return !this.match((Name)node, this.fUsages, binding);
    }

    private static boolean isStaticImport(ASTNode node) {
        if (!(node instanceof QualifiedName)) {
            return false;
        }
        ASTNode parent = ((QualifiedName)node).getParent();
        return parent instanceof ImportDeclaration && ((ImportDeclaration)parent).isStatic();
    }

    public boolean visit(FunctionInvocation node) {
        if (this.fTargetIsStaticMethodImport) {
            return !this.matchStaticImport((Name)node.getName(), this.fUsages, node.resolveMethodBinding());
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(ClassInstanceCreation node) {
        Type type = node.getType();
        if (type != null) {
            if (type instanceof SimpleType) {
                Name name = ((SimpleType)type).getName();
                if (name instanceof QualifiedName) {
                    name = ((QualifiedName)name).getName();
                }
                this.match(name, this.fUsages, (IBinding)node.resolveConstructorBinding());
            }
        } else {
            Expression member = node.getMember();
            if (member instanceof SimpleName) {
                SimpleName name = (SimpleName)member;
                this.match((Name)name, this.fUsages, (IBinding)node.resolveConstructorBinding());
            }
        }
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        SimpleName name = this.getSimpleName(lhs);
        if (name != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        lhs.accept((ASTVisitor)this);
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getParent().getNodeType() == 23 || node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        Expression operand;
        SimpleName name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getSimpleName(operand = node.getOperand())) != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        SimpleName name = this.getSimpleName(operand);
        if (name != null) {
            this.match((Name)name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    private boolean match(Name node, List result, IBinding binding) {
        if (binding != null && Bindings.equals(this.getBindingDeclaration(binding), this.fTarget)) {
            result.add(node);
            return true;
        }
        return false;
    }

    private boolean matchStaticImport(Name node, List result, IFunctionBinding binding) {
        if (binding == null || node == null || !(this.fTarget instanceof IFunctionBinding) || !Modifier.isStatic((int)binding.getModifiers())) {
            return false;
        }
        IFunctionBinding targetMethodBinding = (IFunctionBinding)this.fTarget;
        if ((this.fTargetIsStaticMethodImport || Modifier.isStatic((int)targetMethodBinding.getModifiers())) && targetMethodBinding.getDeclaringClass().getTypeDeclaration() == binding.getDeclaringClass().getTypeDeclaration() && node.getFullyQualifiedName().equals(targetMethodBinding.getName())) {
            result.add(node);
            return true;
        }
        return false;
    }

    private SimpleName getSimpleName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }

    private IBinding getBindingDeclaration(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 4: {
                return ((IFunctionBinding)binding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
        }
        return binding;
    }
}

