/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class ClassPathDetector
implements IResourceProxyVisitor {
    private HashMap fSourceFolders = new HashMap();
    private IProject fProject;
    private IIncludePathEntry[] fResultClasspath;
    private IProgressMonitor fMonitor;

    public ClassPathDetector(IProject project, IProgressMonitor monitor) throws CoreException {
        this.fProject = project;
        this.fResultClasspath = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.detectClasspath(monitor);
    }

    private void detectClasspath(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClassPathDetector_operation_description, 4);
            this.fMonitor = monitor;
            this.fProject.accept((IResourceProxyVisitor)this, 0);
            monitor.worked(1);
            ArrayList<IIncludePathEntry> cpEntries = new ArrayList<IIncludePathEntry>();
            this.detectSourceFolders(cpEntries);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
            if (cpEntries.isEmpty()) {
                return;
            }
            IIncludePathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
            int i = 0;
            while (i < jreEntries.length) {
                cpEntries.add(jreEntries[i]);
                ++i;
            }
            IIncludePathEntry[] entries = cpEntries.toArray(new IIncludePathEntry[cpEntries.size()]);
            if (!JavaScriptConventions.validateClasspath((IJavaScriptProject)JavaScriptCore.create((IProject)this.fProject), (IIncludePathEntry[])entries).isOK()) {
                return;
            }
            this.fResultClasspath = entries;
        }
        finally {
            monitor.done();
        }
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<IIncludePathEntry> res = new ArrayList<IIncludePathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        for (IPath path : sourceFolderSet) {
            ArrayList<IPath> excluded = new ArrayList<IPath>();
            for (IPath other : sourceFolderSet) {
                if (path.equals((Object)other) || !path.isPrefixOf(other)) continue;
                IPath pathToExclude = other.removeFirstSegments(path.segmentCount()).addTrailingSeparator();
                excluded.add(pathToExclude);
            }
            IPath[] excludedPaths = excluded.toArray(new IPath[excluded.size()]);
            IIncludePathEntry entry = JavaScriptCore.newSourceEntry((IPath)path, (IPath[])excludedPaths);
            res.add(entry);
        }
        Collections.sort(res, new CPSorter());
        resEntries.addAll(res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitCompilationUnit(IFile file) {
        IJavaScriptUnit cu = JavaScriptCore.createCompilationUnitFrom((IFile)file);
        if (cu == null) return;
        IJavaScriptUnit workingCopy = null;
        try {
            workingCopy = cu.getWorkingCopy(null);
            IPath relPath = this.getPackagePath(workingCopy.getSource());
            IPath packPath = file.getParent().getFullPath();
            String cuName = file.getName();
            if (relPath == null) {
                this.addToMap(this.fSourceFolders, packPath, (IPath)new Path(cuName));
            } else {
                IPath folderPath = this.getFolderPath(packPath, relPath);
                if (folderPath != null) {
                    this.addToMap(this.fSourceFolders, folderPath, relPath.append(cuName));
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            if (workingCopy == null) return;
            try {
                workingCopy.discardWorkingCopy();
                return;
            }
            catch (JavaScriptModelException javaScriptModelException2) {}
            return;
        }
        catch (InvalidInputException invalidInputException) {
            try {
                if (workingCopy == null) return;
            }
            catch (Throwable throwable) {
                if (workingCopy == null) throw throwable;
                try {
                    workingCopy.discardWorkingCopy();
                    throw throwable;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
                throw throwable;
            }
            try {
                workingCopy.discardWorkingCopy();
                return;
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            return;
        }
        if (workingCopy == null) return;
        try {
            workingCopy.discardWorkingCopy();
            return;
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    private IPath getPackagePath(String source) throws InvalidInputException {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(0, source.length() - 1);
        int tok = scanner.getNextToken();
        if (tok != 214) {
            return null;
        }
        Path res = Path.EMPTY;
        do {
            if ((tok = scanner.getNextToken()) != 5) {
                return res;
            }
            res = res.append(new String(scanner.getCurrentTokenSource()));
        } while ((tok = scanner.getNextToken()) == 6);
        return res;
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    private boolean isValidCUName(String name) {
        return !JavaScriptConventions.validateCompilationUnitName((String)name).matches(4);
    }

    public boolean visit(IResourceProxy proxy) {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            if (this.isValidCUName(name)) {
                this.visitCompilationUnit((IFile)proxy.requestResource());
            }
            return false;
        }
        return true;
    }

    public IIncludePathEntry[] getClasspath() {
        if (this.fResultClasspath == null) {
            return new IIncludePathEntry[0];
        }
        return this.fResultClasspath;
    }

    private static class CPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private CPSorter() {
        }

        public int compare(Object o1, Object o2) {
            IIncludePathEntry e1 = (IIncludePathEntry)o1;
            IIncludePathEntry e2 = (IIncludePathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

