/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.filters.LibraryFilter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;

public class DialogPackageExplorer
implements IMenuListener,
ISelectionProvider,
IPostSelectionProvider,
ISetSelectionTarget {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IJavaScriptProject fCurrJProject = null;
    private PackageContentProvider fContentProvider;

    public Control createControl(Composite parent) {
        this.fPackageViewer = new TreeViewer(parent, 2);
        this.fPackageViewer.setComparer(WorkingSetModel.COMPARER);
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setComparator((ViewerComparator)new ExtendedJavaElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(element)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(element, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(element));
                }
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fActionGroup == null) {
            return;
        }
        JavaScriptPlugin.createStandardGroups(manager);
        this.fActionGroup.fillContextMenu(manager);
    }

    public void setContentProvider() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = new PackageContentProvider();
        this.fContentProvider.setIsFlatLayout(true);
        PackageLabelProvider labelProvider = new PackageLabelProvider(36421324767274L, 3);
        this.fPackageViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(labelProvider, false));
    }

    public void setInput(IJavaScriptProject project) {
        IJavaScriptProject oldProject = this.fCurrJProject;
        this.fCurrJProject = project;
        if (this.fContentProvider != null) {
            this.fContentProvider.inputChanged((Viewer)this.fPackageViewer, oldProject, this.fCurrJProject);
        }
        this.fPackageViewer.setInput((Object)new Object[0]);
        ArrayList<IJavaScriptProject> selectedElements = new ArrayList<IJavaScriptProject>();
        selectedElements.add(this.fCurrJProject);
        this.setSelection(selectedElements);
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
        this.fPackageViewer = null;
    }

    public void setSelection(final List elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DialogPackageExplorer.this.fPackageViewer.refresh();
                    StructuredSelection selection = new StructuredSelection(elements);
                    DialogPackageExplorer.this.fPackageViewer.setSelection((ISelection)selection, true);
                    DialogPackageExplorer.this.fPackageViewer.getTree().setFocus();
                    if (elements.size() == 1 && elements.get(0) instanceof IJavaScriptProject) {
                        DialogPackageExplorer.this.fPackageViewer.expandToLevel(elements.get(0), 1);
                    }
                }
            }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
    }

    public ISelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(((StructuredSelection)selection).toList());
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.addPostSelectionChangedListener(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPackageViewer.removePostSelectionChangedListener(listener);
    }

    public void selectReveal(ISelection selection) {
        this.setSelection(selection);
    }

    private final class ExtendedJavaElementSorter
    extends JavaScriptElementComparator {
        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CPListElementAttribute) {
                return -1;
            }
            if (e2 instanceof CPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class PackageContentProvider
    extends PackageExplorerContentProvider {
        public PackageContentProvider() {
            super(false);
        }

        @Override
        public Object[] getElements(Object element) {
            if (DialogPackageExplorer.this.fCurrJProject == null || !DialogPackageExplorer.this.fCurrJProject.exists()) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private PackageFilter() {
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            if (!(element instanceof IFile)) break block10;
                            IFile file = (IFile)element;
                            if (file.getName().equals(".jsdtscope") || file.getName().equals(".project")) {
                                return false;
                            }
                        }
                        if (!(element instanceof IPackageFragmentRoot)) break block11;
                        IIncludePathEntry cpe = ((IPackageFragmentRoot)element).getRawIncludepathEntry();
                        if (cpe == null || cpe.getEntryKind() == 5 || cpe.getEntryKind() == 1 || cpe.getEntryKind() == 4) {
                            return false;
                        }
                    }
                    if (!(element instanceof PackageFragmentRootContainer)) break block12;
                    return false;
                }
                if (!(element instanceof IPackageFragment)) break block13;
                IPackageFragment fragment = (IPackageFragment)element;
                if (fragment.isDefaultPackage() && !fragment.hasChildren()) {
                    return false;
                }
            }
            try {
                IFolder folder;
                if (element instanceof IFolder && (folder = (IFolder)element).getName().startsWith(".")) {
                    return false;
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
            return super.select(viewer, parentElement, element);
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        public PackageLabelProvider(long textFlags, int imageFlags) {
            super(textFlags, imageFlags);
        }

        @Override
        public String getText(Object element) {
            if (element instanceof CPListElementAttribute) {
                return null;
            }
            String text = super.getText(element);
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaScriptProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    IIncludePathEntry entry = root2.getRawIncludepathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if (element instanceof IJavaScriptProject && (project = (IJavaScriptProject)element).exists() && project.isOnIncludepath((IJavaScriptElement)project) && ClasspathModifier.filtersSet(root = project.findPackageFragmentRoot(project.getPath()))) {
                    IIncludePathEntry entry = root.getRawIncludepathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, text);
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
            return text;
        }

        @Override
        public Color getForeground(Object element) {
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaScriptProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    return this.getBlueColor();
                }
                if (element instanceof IJavaScriptProject && (project = (IJavaScriptProject)element).exists() && project.isOnIncludepath((IJavaScriptElement)project) && (root = project.findPackageFragmentRoot(project.getPath())) != null && ClasspathModifier.filtersSet(root)) {
                    return this.getBlueColor();
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }
    }
}

