/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.ui.operations.ISystemRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SystemProgressDialogRunnableContext
implements ISystemRunnableContext {
    private Shell shell;
    private IRunnableContext runnableContext;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;

    public SystemProgressDialogRunnableContext(Shell shell) {
        this.shell = shell;
    }

    public boolean isPostponeBuild() {
        return this.postponeBuild;
    }

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setRunnableContext(IRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }

    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getRunnableContext().run(true, true, this.wrapRunnable(runnable));
    }

    private IRunnableContext getRunnableContext() {
        if (this.runnableContext == null) {
            return new IRunnableContext(){

                public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                    IProgressService manager = PlatformUI.getWorkbench().getProgressService();
                    manager.busyCursorWhile(runnable);
                }
            };
        }
        return this.runnableContext;
    }

    private IRunnableWithProgress wrapRunnable(final IRunnableWithProgress runnable) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (SystemProgressDialogRunnableContext.this.schedulingRule == null && !SystemProgressDialogRunnableContext.this.postponeBuild) {
                        runnable.run(monitor);
                    } else {
                        final Exception[] exception = new Exception[1];
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor pm) throws CoreException {
                                try {
                                    runnable.run(pm);
                                }
                                catch (InvocationTargetException e) {
                                    exception[0] = e;
                                }
                                catch (InterruptedException e) {
                                    exception[0] = e;
                                }
                            }
                        }, SystemProgressDialogRunnableContext.this.schedulingRule, 0, monitor);
                        if (exception[0] != null) {
                            if (exception[0] instanceof InvocationTargetException) {
                                throw (InvocationTargetException)exception[0];
                            }
                            if (exception[0] instanceof InterruptedException) {
                                throw (InterruptedException)exception[0];
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }
}

