/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.io.PrintStream;
import org.eclipse.tm.internal.terminal.emulator.IVT100EmulatorBackend;
import org.eclipse.tm.terminal.model.Style;

public class VT100BackendTraceDecorator
implements IVT100EmulatorBackend {
    final IVT100EmulatorBackend fBackend;
    final PrintStream fWriter;

    public VT100BackendTraceDecorator(IVT100EmulatorBackend backend, PrintStream out) {
        this.fBackend = backend;
        this.fWriter = out;
    }

    public void appendString(String buffer) {
        this.fWriter.println("appendString(\"" + buffer + "\")");
        this.fBackend.appendString(buffer);
    }

    public void clearAll() {
        this.fWriter.println("clearAll()");
        this.fBackend.clearAll();
    }

    public void deleteCharacters(int n) {
        this.fWriter.println("deleteCharacters(" + n + ")");
        this.fBackend.deleteCharacters(n);
    }

    public void deleteLines(int n) {
        this.fWriter.println("deleteLines(" + n + ")");
        this.fBackend.deleteLines(n);
    }

    public void eraseAll() {
        this.fWriter.println("eraseAll()");
        this.fBackend.eraseAll();
    }

    public void eraseLine() {
        this.fWriter.println("eraseLine()");
        this.fBackend.eraseLine();
    }

    public void eraseLineToCursor() {
        this.fWriter.println("eraseLineToCursor()");
        this.fBackend.eraseLineToCursor();
    }

    public void eraseLineToEnd() {
        this.fWriter.println("eraseLineToEnd()");
        this.fBackend.eraseLineToEnd();
    }

    public void eraseToCursor() {
        this.fWriter.println("eraseToCursor()");
        this.fBackend.eraseToCursor();
    }

    public void eraseToEndOfScreen() {
        this.fWriter.println("eraseToEndOfScreen()");
        this.fBackend.eraseToEndOfScreen();
    }

    public int getColumns() {
        return this.fBackend.getColumns();
    }

    public int getCursorColumn() {
        return this.fBackend.getCursorColumn();
    }

    public int getCursorLine() {
        return this.fBackend.getCursorLine();
    }

    public Style getDefaultStyle() {
        return this.fBackend.getDefaultStyle();
    }

    public int getLines() {
        return this.fBackend.getLines();
    }

    public Style getStyle() {
        return this.fBackend.getStyle();
    }

    public void insertCharacters(int charactersToInsert) {
        this.fWriter.println("insertCharacters(" + charactersToInsert + ")");
        this.fBackend.insertCharacters(charactersToInsert);
    }

    public void insertLines(int n) {
        this.fWriter.println("insertLines(" + n + ")");
        this.fBackend.insertLines(n);
    }

    public void processNewline() {
        this.fWriter.println("processNewline()");
        this.fBackend.processNewline();
    }

    public void setCursor(int targetLine, int targetColumn) {
        this.fWriter.println("setCursor(" + targetLine + ", " + targetColumn + ")");
        this.fBackend.setCursor(targetLine, targetColumn);
    }

    public void setCursorColumn(int targetColumn) {
        this.fWriter.println("setCursorColumn(" + targetColumn + ")");
        this.fBackend.setCursorColumn(targetColumn);
    }

    public void setCursorLine(int targetLine) {
        this.fWriter.println("setCursorLine(" + targetLine + ")");
        this.fBackend.setCursorLine(targetLine);
    }

    public void setDefaultStyle(Style defaultStyle) {
        this.fWriter.println("setDefaultStyle(" + defaultStyle + ")");
        this.fBackend.setDefaultStyle(defaultStyle);
    }

    public void setDimensions(int lines, int cols) {
        this.fWriter.println("setDimensions(" + lines + "," + cols + ")");
        this.fBackend.setDimensions(lines, cols);
    }

    public void setStyle(Style style) {
        this.fWriter.println("setStyle(" + style + ")");
        this.fBackend.setStyle(style);
    }

    public void setVT100LineWrapping(boolean enable) {
        this.fWriter.println("setVT100LineWrapping(" + enable + ")");
        this.fBackend.setVT100LineWrapping(enable);
    }

    public boolean isVT100LineWrapping() {
        return this.fBackend.isVT100LineWrapping();
    }

    public void setInsertMode(boolean enable) {
        this.fWriter.println("setInsertMode(" + enable + ")");
        this.fBackend.setInsertMode(enable);
    }

    public void setScrollRegion(int top, int bottom) {
        this.fWriter.println("setScrollRegion(" + top + ',' + bottom + ")");
        this.fBackend.setScrollRegion(top, bottom);
    }

    public void scrollUp(int lines) {
        this.fWriter.println("scrollUp(" + lines + ")");
        this.fBackend.scrollUp(lines);
    }

    public void scrollDown(int lines) {
        this.fWriter.println("scrollDown(" + lines + ")");
        this.fBackend.scrollDown(lines);
    }
}

