/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.ITextCanvasModelListener;
import org.eclipse.tm.terminal.model.ITerminalTextDataReadOnly;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;

public abstract class AbstractTextCanvasModel
implements ITextCanvasModel {
    protected List fListeners = new ArrayList();
    private int fCursorLine;
    private int fCursorColumn;
    private boolean fShowCursor;
    private long fCursorTime;
    private boolean fCursorIsEnabled;
    private final ITerminalTextDataSnapshot fSnapshot;
    private int fLines;
    private int fSelectionStartLine = -1;
    private int fSeletionEndLine;
    private int fSelectionStartCoumn;
    private int fSelectionEndColumn;
    private ITerminalTextDataSnapshot fSelectionSnapshot;
    private String fCurrentSelection = "";
    private final Point fSelectionAnchor = new Point(0, 0);
    boolean fInUpdate;
    private int fCols;

    public AbstractTextCanvasModel(ITerminalTextDataSnapshot snapshot) {
        this.fSnapshot = snapshot;
        this.fLines = this.fSnapshot.getHeight();
    }

    public void addCellCanvasModelListener(ITextCanvasModelListener listener) {
        this.fListeners.add(listener);
    }

    public void removeCellCanvasModelListener(ITextCanvasModelListener listener) {
        this.fListeners.remove(listener);
    }

    protected void fireCellRangeChanged(int x, int y, int width, int height) {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.rangeChanged(x, y, width, height);
        }
    }

    protected void fireDimensionsChanged(int width, int height) {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.dimensionsChanged(width, height);
        }
    }

    protected void fireTerminalDataChanged() {
        for (ITextCanvasModelListener listener : this.fListeners) {
            listener.terminalDataChanged();
        }
    }

    public ITerminalTextDataReadOnly getTerminalText() {
        return this.fSnapshot;
    }

    protected ITerminalTextDataSnapshot getSnapshot() {
        return this.fSnapshot;
    }

    protected void updateSnapshot() {
        if (!this.fInUpdate && this.fSnapshot.isOutOfDate()) {
            this.fInUpdate = true;
            try {
                int y;
                this.fSnapshot.updateSnapshot(false);
                if (this.fSnapshot.hasTerminalChanged()) {
                    this.fireTerminalDataChanged();
                }
                if (this.fLines != this.fSnapshot.getHeight() || this.fCols != this.fSnapshot.getWidth()) {
                    this.fireDimensionsChanged(this.fSnapshot.getWidth(), this.fSnapshot.getHeight());
                    this.fLines = this.fSnapshot.getHeight();
                    this.fCols = this.fSnapshot.getWidth();
                }
                if ((y = this.fSnapshot.getFirstChangedLine()) < Integer.MAX_VALUE) {
                    int height = this.fSnapshot.getLastChangedLine() - y + 1;
                    this.fireCellRangeChanged(0, y, this.fSnapshot.getWidth(), height);
                }
            }
            finally {
                this.fInUpdate = false;
            }
        }
    }

    public void update() {
        this.updateSnapshot();
        this.updateSelection();
        this.updateCursor();
    }

    public int getCursorColumn() {
        return this.fCursorColumn;
    }

    public int getCursorLine() {
        return this.fCursorLine;
    }

    public boolean isCursorOn() {
        return this.fShowCursor && this.fCursorIsEnabled;
    }

    protected void updateCursor() {
        if (!this.fCursorIsEnabled) {
            return;
        }
        int cursorLine = this.getSnapshot().getCursorLine();
        int cursorColumn = this.getSnapshot().getCursorColumn();
        if (cursorLine >= this.getSnapshot().getHeight()) {
            cursorLine = this.getSnapshot().getHeight() - 1;
            cursorColumn = this.getSnapshot().getWidth() - 1;
        }
        if (this.fCursorLine != cursorLine || this.fCursorColumn != cursorColumn) {
            this.fShowCursor = false;
            int col = this.fCursorColumn;
            int width = 2;
            if (col > 0) {
                --col;
                ++width;
            }
            this.fireCellRangeChanged(col, this.fCursorLine, width, 1);
            this.fShowCursor = true;
            this.fCursorTime = System.currentTimeMillis();
            this.fCursorLine = cursorLine;
            this.fCursorColumn = cursorColumn;
            this.fireCellRangeChanged(this.fCursorColumn, this.fCursorLine, 1, 1);
        } else {
            long t = System.currentTimeMillis();
            if (t - this.fCursorTime > 500L) {
                this.fShowCursor = !this.fShowCursor;
                this.fCursorTime = t;
                int col = this.fCursorColumn;
                int width = 2;
                if (col > 0) {
                    --col;
                    ++width;
                }
                this.fireCellRangeChanged(col, this.fCursorLine, width, 1);
            }
        }
    }

    public void setVisibleRectangle(int startLine, int startCol, int height, int width) {
        this.fSnapshot.setInterestWindow(Math.max(0, startLine), Math.max(1, height));
        this.update();
    }

    protected void showCursor(boolean show) {
        this.fShowCursor = true;
    }

    public void setCursorEnabled(boolean visible) {
        this.fCursorTime = System.currentTimeMillis();
        this.fShowCursor = visible;
        this.fCursorIsEnabled = visible;
        this.fireCellRangeChanged(this.fCursorColumn, this.fCursorLine, 1, 1);
    }

    public boolean isCursorEnabled() {
        return this.fCursorIsEnabled;
    }

    public Point getSelectionEnd() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionEndColumn, this.fSeletionEndLine);
    }

    public Point getSelectionStart() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionStartCoumn, this.fSelectionStartLine);
    }

    public Point getSelectionAnchor() {
        if (this.fSelectionStartLine < 0) {
            return null;
        }
        return new Point(this.fSelectionAnchor.x, this.fSelectionAnchor.y);
    }

    public void setSelectionAnchor(Point anchor) {
        this.fSelectionAnchor.x = anchor.x;
        this.fSelectionAnchor.y = anchor.y;
    }

    public void setSelection(int startLine, int endLine, int startColumn, int endColumn) {
        this.doSetSelection(startLine, endLine, startColumn, endColumn);
        this.fCurrentSelection = this.extractSelectedText();
    }

    private void doSetSelection(int startLine, int endLine, int startColumn, int endColumn) {
        int changedEnd;
        int changedStart;
        assert (startLine < 0 || startLine <= endLine);
        if (startLine >= 0) {
            if (this.fSelectionSnapshot == null) {
                this.fSelectionSnapshot = this.fSnapshot.getTerminalTextData().makeSnapshot();
                this.fSelectionSnapshot.updateSnapshot(true);
            }
        } else if (this.fSelectionSnapshot != null) {
            this.fSelectionSnapshot.detach();
            this.fSelectionSnapshot = null;
        }
        int oldStart = this.fSelectionStartLine;
        int oldEnd = this.fSeletionEndLine;
        this.fSelectionStartLine = startLine;
        this.fSeletionEndLine = endLine;
        this.fSelectionStartCoumn = startColumn;
        this.fSelectionEndColumn = endColumn;
        if (this.fSelectionSnapshot != null) {
            this.fSelectionSnapshot.setInterestWindow(0, this.fSelectionSnapshot.getHeight());
        }
        if (oldStart < 0) {
            changedStart = this.fSelectionStartLine;
            changedEnd = this.fSeletionEndLine;
        } else if (this.fSelectionStartLine < 0) {
            changedStart = oldStart;
            changedEnd = oldEnd;
        } else {
            changedStart = Math.min(oldStart, this.fSelectionStartLine);
            changedEnd = Math.max(oldEnd, this.fSeletionEndLine);
        }
        if (changedStart >= 0) {
            this.fireCellRangeChanged(0, changedStart, this.fSnapshot.getWidth(), changedEnd - changedStart + 1);
        }
    }

    public boolean hasLineSelection(int line) {
        if (this.fSelectionStartLine < 0) {
            return false;
        }
        return line >= this.fSelectionStartLine && line <= this.fSeletionEndLine;
    }

    public String getSelectedText() {
        return this.fCurrentSelection;
    }

    private String extractSelectedText() {
        if (this.fSelectionStartLine < 0 || this.fSelectionStartCoumn < 0 || this.fSelectionSnapshot == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int line = this.fSelectionStartLine;
        while (line <= this.fSeletionEndLine) {
            String text;
            char[] chars = this.fSelectionSnapshot.getChars(line);
            if (chars != null) {
                text = new String(chars);
                if (line == this.fSeletionEndLine && this.fSelectionEndColumn >= 0) {
                    text = text.substring(0, Math.min(this.fSelectionEndColumn + 1, text.length()));
                }
                if (line == this.fSelectionStartLine) {
                    text = text.substring(Math.min(this.fSelectionStartCoumn, text.length()));
                }
                int i = text.length() - 1;
                while (i >= 0 && text.charAt(i) == '\u0000') {
                    --i;
                }
                text = text.substring(0, i + 1);
                text = text.replace('\u0000', ' ');
            } else {
                text = "";
            }
            buffer.append(text);
            if (line < this.fSeletionEndLine && !this.fSelectionSnapshot.isWrappedLine(line)) {
                buffer.append('\n');
            }
            ++line;
        }
        return buffer.toString();
    }

    private void updateSelection() {
        if (this.fSelectionSnapshot != null && this.fSelectionSnapshot.isOutOfDate()) {
            this.fSelectionSnapshot.updateSnapshot(true);
            if (this.fSelectionSnapshot != null && this.fSelectionStartLine >= 0 && this.fSelectionSnapshot.getScrollWindowSize() > 0) {
                int start = this.fSelectionStartLine + this.fSelectionSnapshot.getScrollWindowShift();
                int end = this.fSeletionEndLine + this.fSelectionSnapshot.getScrollWindowShift();
                if (start < 0) {
                    start = end >= 0 ? 0 : -1;
                }
                this.doSetSelection(start, end, this.fSelectionStartCoumn, this.fSelectionEndColumn);
            }
            if (this.fCurrentSelection.length() > 0 && this.fSelectionSnapshot != null && this.fSelectionSnapshot.getFirstChangedLine() <= this.fSeletionEndLine && this.fSelectionSnapshot.getLastChangedLine() >= this.fSelectionStartLine && !this.fCurrentSelection.equals(this.extractSelectedText())) {
                this.setSelection(-1, -1, -1, -1);
            }
            if (this.fSelectionSnapshot != null) {
                this.fSelectionSnapshot.setInterestWindow(0, this.fSelectionSnapshot.getHeight());
            }
        }
    }
}

