/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateFactory;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class WindowStateInfo
implements IWindowStateInfo {
    public static final String CURRENT_VERSION = "1.0";
    private HashMap _controlStateInfoMap = new HashMap();
    private String _version;
    private int _height = -1;
    private int _width = -1;

    @Override
    public IControlStateInfo get(int controlType) {
        return (IControlStateInfo)this._controlStateInfoMap.get(new Integer(controlType));
    }

    @Override
    public void put(int controlType, IControlStateInfo controlStateInfo) {
        this._controlStateInfoMap.put(new Integer(controlType), controlStateInfo);
    }

    @Override
    public void remove(int controlType) {
        this._controlStateInfoMap.remove(new Integer(controlType));
    }

    @Override
    public IControlStateInfo[] getcontrolStateInfos() {
        Set entries = this._controlStateInfoMap.entrySet();
        return entries.toArray(new IControlStateInfo[entries.size()]);
    }

    @Override
    public String getVersion() {
        if (this._version != null) {
            return this._version;
        }
        return CURRENT_VERSION;
    }

    @Override
    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public void setHeight(int height) {
        this._height = height;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public void setWidth(int width) {
        this._width = width;
    }

    @Override
    public String encode() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"SQLQueryBuilder");
        SQLBuilderWindowStateInput windowStateInput = new SQLBuilderWindowStateInput(this);
        SQLBuilderWindowStateFactory.saveState((IMemento)memento, windowStateInput);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public static IWindowStateInfo decode(String code) {
        StringReader reader = new StringReader(code);
        XMLMemento memento = null;
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
        SQLBuilderWindowStateFactory factory = new SQLBuilderWindowStateFactory();
        IAdaptable element = factory.createElement((IMemento)memento);
        SQLBuilderWindowStateInput windowStateInput = (SQLBuilderWindowStateInput)element;
        return windowStateInput.getWindowStateInfo();
    }
}

