/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResourceRunnable
implements IRunnableWithProgress,
Callable<Object> {
    protected ResourceProvider resourceProvider;
    protected String resourceUrl;
    protected CatalogItem catalogItem;
    private final IProgressMonitor cancellationMonitor;

    public AbstractResourceRunnable(IProgressMonitor cancellationMonitor, CatalogItem catalogItem, ResourceProvider resourceProvider, String resourceUrl) {
        this.catalogItem = catalogItem;
        this.cancellationMonitor = cancellationMonitor;
        this.resourceProvider = resourceProvider;
        this.resourceUrl = resourceUrl;
    }

    @Override
    public Object call() throws Exception {
        this.run((IProgressMonitor)new NullProgressMonitor(){

            public boolean isCanceled() {
                return AbstractResourceRunnable.this.cancellationMonitor.isCanceled();
            }
        });
        return this;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            URL imageUrl = URLUtil.toURL((String)this.resourceUrl);
            InputStream in = TransportFactory.createTransport().stream(imageUrl.toURI(), monitor);
            try {
                this.resourceProvider.putResource(this.resourceUrl, in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (URISyntaxException e) {
            MarketplaceClientUi.log(2, Messages.AbstractResourceRunnable_badUri, this.catalogItem.getName(), this.catalogItem.getId(), this.resourceUrl, e);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof OperationCanceledException)) {
                MarketplaceClientUi.log(2, Messages.AbstractResourceRunnable_downloadError, this.catalogItem.getName(), this.catalogItem.getId(), this.resourceUrl, e);
            }
        }
        catch (CoreException e) {
            MarketplaceClientUi.log(2, Messages.AbstractResourceRunnable_downloadError, new Object[]{this.catalogItem.getName(), this.catalogItem.getId(), this.resourceUrl, e});
        }
        if (this.resourceProvider.containsResource(this.resourceUrl)) {
            this.resourceRetrieved();
        }
    }

    protected abstract void resourceRetrieved();
}

