/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.utils.StyleCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StyleComboDialogField
extends DialogFieldBase
implements ISupportTextValue {
    private static final int WIDTH_HINT = 10;
    private String _text = "";
    private int _selectionIndex;
    private String[] _items = new String[0];
    private StyleCombo _comboControl;
    private ModifyListener _modifyListener;
    private int _flags;
    private boolean _pending = false;
    private Map _entryMap;
    private String _defaultValue;

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
        if (this._comboControl != null && !this._comboControl.isDisposed()) {
            this._comboControl.setDefaultValue(this._defaultValue);
        }
    }

    public StyleComboDialogField(int flags) {
        this._flags = flags;
        this._selectionIndex = -1;
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)StyleComboDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)StyleComboDialogField.gridDataForLabel(1));
        StyleCombo combo = this.getComboControl(toolkit, parent);
        combo.setLayoutData(StyleComboDialogField.gridDataForCombo(nColumns - 2));
        return new Control[]{requiredLabel, label, combo};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = 10;
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this._comboControl)) {
            this._comboControl.setFocus();
        }
        return true;
    }

    public StyleCombo getComboControl(FormToolkit toolkit, Composite parent) {
        if (this._comboControl == null || this._comboControl.isDisposed()) {
            this.assertCompositeNotNull(parent);
            this._modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StyleComboDialogField.this.doModifyText(e);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StyleComboDialogField.this.doSelectionChanged(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    StyleComboDialogField.this.handleDefaultSelection(e);
                }
            };
            if (toolkit != null) {
                this._comboControl = new StyleCombo(parent, this._flags);
                final FormColors colors = new FormColors(parent.getDisplay());
                parent.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent event) {
                        Composite composite = (Composite)event.widget;
                        Control[] children = composite.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            Control c = children[i];
                            if (c instanceof StyleCombo && c.isVisible()) {
                                Rectangle b = c.getBounds();
                                GC gc = event.gc;
                                gc.setForeground(colors.getBorderColor());
                                gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                            }
                            ++i;
                        }
                    }
                });
                parent.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        colors.dispose();
                    }
                });
                toolkit.adapt((Composite)this._comboControl);
            } else {
                this._comboControl = new StyleCombo(parent, this._flags | 0x800);
                this._comboControl.setBackground(Display.getCurrent().getSystemColor(25));
            }
            this._comboControl.setItems(this._items);
            this._comboControl.setDefaultValue(this._defaultValue);
            if (this._selectionIndex != -1) {
                this._comboControl.select(this._selectionIndex);
            } else {
                this._comboControl.setText(this._text);
            }
            this._comboControl.setFont(parent.getFont());
            this._comboControl.addModifyListener(this._modifyListener);
            this._comboControl.addSelectionListener(selectionListener);
            this._comboControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    StyleComboDialogField.this.doFocusLost(e);
                }
            });
            this._comboControl.setEnabled(this.isEnabled());
            this._comboControl.setToolTipText(this.getToolTip());
        }
        return this._comboControl;
    }

    protected void handleDefaultSelection(SelectionEvent e) {
        if (this._pending) {
            this._pending = false;
            this.dialogFieldApplied();
        }
    }

    protected void doFocusLost(FocusEvent e) {
        if (this._pending) {
            this._pending = false;
            this.dialogFieldApplied();
        }
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this._comboControl)) {
            this._text = this.getEntryKey(this._comboControl.getText());
            this._selectionIndex = this._comboControl.getSelectionIndex();
        }
        this._pending = true;
        this.dialogFieldChanged();
    }

    private void doSelectionChanged(SelectionEvent e) {
        if (this.isOkToUse((Control)this._comboControl)) {
            this._items = this._comboControl.getItems();
            this._text = this.getEntryKey(this._comboControl.getText());
            this._selectionIndex = this._comboControl.getSelectionIndex();
        }
        this._pending = false;
        this.dialogFieldChangedAndApplied();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this._comboControl)) {
            this._comboControl.setEnabled(this.isEnabled());
        }
    }

    public void setItems(String[] items) {
        this._items = items;
        if (this.isOkToUse((Control)this._comboControl)) {
            this._comboControl.setItems(items);
        }
        this._pending = false;
    }

    public void setEntryMap(Map map) {
        this._entryMap = map;
        if (this._entryMap == null) {
            this._entryMap = new TreeMap();
        }
        Map.Entry[] entries = this._entryMap.entrySet().toArray(new Map.Entry[0]);
        String[] items = new String[entries.length];
        int i = 0;
        while (i < entries.length) {
            items[i] = entries[i].getValue().toString();
            ++i;
        }
        this.setItems(items);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this.setTextWithoutUpdate(text);
        this._pending = false;
        this.dialogFieldChangedAndApplied();
    }

    public void selectItem(int index) {
        if (this.isOkToUse((Control)this._comboControl)) {
            this._comboControl.select(index);
        } else if (index >= 0 && index < this._items.length) {
            this._text = this.getEntryKey(this._items[index]);
            this._selectionIndex = index;
        }
        this.dialogFieldChangedAndApplied();
    }

    public int getSelectionIndex() {
        return this._selectionIndex;
    }

    public void setTextWithoutUpdate(String text) {
        this._pending = false;
        if (text == null) {
            text = "";
        }
        this._text = text;
        if (this.isOkToUse((Control)this._comboControl)) {
            this._comboControl.removeModifyListener(this._modifyListener);
            this._comboControl.setText(this.getEntryValue(text));
            this._comboControl.addModifyListener(this._modifyListener);
        }
    }

    private String getEntryValue(String key) {
        if (this._entryMap == null || !this._entryMap.containsKey(key)) {
            return key;
        }
        return this._entryMap.get(key).toString();
    }

    private String getEntryKey(String value) {
        if (this._entryMap == null || !this._entryMap.containsValue(value)) {
            return value;
        }
        Map.Entry[] entries = this._entryMap.entrySet().toArray(new Map.Entry[0]);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getValue() == value || value != null && value.equals(entries[i].getValue())) {
                return entries[i].getKey().toString();
            }
            ++i;
        }
        return value;
    }

    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this._comboControl, true);
    }
}

