/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jpa.internal.configurators;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.ResourceCleaner;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.facets.FacetDetectorManager;
import org.eclipse.m2e.wtp.jpa.PlatformIdentifierManager;
import org.eclipse.m2e.wtp.jpa.internal.MavenJpaActivator;
import org.eclipse.m2e.wtp.jpa.internal.configurators.MavenResourceLocator;
import org.eclipse.m2e.wtp.jpa.internal.util.JptUtils;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JpaProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String JPA_NO_OP_LIBRARY_PROVIDER = "jpa-no-op-library-provider";
    private static final String M2E_JPA_ACTIVATION_PROPERTY = "m2e.jpa.activation";
    static final String PERSISTENCE_XML_KEY = "persistencexml";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (!this.canConfigure(request.getMavenProjectFacade(), monitor)) {
            return;
        }
        IProject project = request.getProject();
        MavenProject mavenProject = request.getMavenProject();
        IFile persistenceXml = this.getPersistenceXml(project);
        if (persistenceXml == null || !persistenceXml.exists()) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        if (facetedProject != null) {
            ProjectUtils.refreshHierarchy((File)mavenProject.getBasedir(), (int)2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ResourceCleaner cleaner = new ResourceCleaner(facetedProject.getProject());
            this.addFoldersToClean(cleaner, request.getMavenProjectFacade());
            try {
                this.configureFacets(facetedProject, request.getMavenProjectFacade(), persistenceXml, monitor);
            }
            finally {
                cleaner.cleanUp();
            }
        }
    }

    private IFile getPersistenceXml(IProject project) {
        MavenResourceLocator resourceLocator = new MavenResourceLocator();
        IPath path = resourceLocator.getWorkspacePath(project, (IPath)new Path("META-INF/persistence.xml"));
        IFile persistenceXml = null;
        if (path != null) {
            persistenceXml = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return persistenceXml;
    }

    private void configureFacets(IFacetedProject facetedProject, IMavenProjectFacade mavenProjectFacade, IFile persistenceXml, IProgressMonitor monitor) throws CoreException {
        persistenceXml.refreshLocal(0, null);
        PersistenceXmlResourceProvider provider = PersistenceXmlResourceProvider.getXmlResourceProvider((IFile)persistenceXml);
        JptXmlResource jpaXmlResource = provider.getXmlResource();
        Map<String, JptXmlResource> context = Collections.singletonMap(PERSISTENCE_XML_KEY, jpaXmlResource);
        FacetDetectorManager facetDetectorManager = FacetDetectorManager.getInstance();
        IProjectFacetVersion version = facetDetectorManager.findFacetVersion(mavenProjectFacade, JpaProject.FACET.getId(), context, monitor);
        if (version == null) {
            return;
        }
        JpaPlatform.Config platform = this.getPlatform(jpaXmlResource, version);
        IDataModel dataModel = this.getDataModel(facetedProject, version, platform);
        LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
        this.installJavaFacet(actions, facetedProject.getProject(), facetedProject);
        actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, version, (Object)dataModel));
        facetedProject.modify(actions, monitor);
    }

    private JpaPlatform.Config getPlatform(JptXmlResource persistenceXml, IProjectFacetVersion facetVersion) {
        XmlPersistenceUnit xmlPersistenceUnit = JptUtils.getFirstXmlPersistenceUnit(persistenceXml);
        if (xmlPersistenceUnit == null) {
            return null;
        }
        PlatformIdentifierManager identifierManager = MavenJpaActivator.getDefault().getPlatformIdentifierManager();
        String platformType = identifierManager.identify(xmlPersistenceUnit);
        JpaPlatformManager platformManager = this.getPlatformManager();
        if (platformType != null) {
            for (JpaPlatform.Config platform : platformManager.getJpaPlatformConfigs(facetVersion)) {
                if (!platform.getId().contains(platformType)) continue;
                return platform;
            }
        }
        return null;
    }

    private JpaPlatformManager getPlatformManager() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        JpaWorkspace jpaWorkspace = (JpaWorkspace)workspace.getAdapter(JpaWorkspace.class);
        return jpaWorkspace.getJpaPlatformManager();
    }

    private IDataModel getDataModel(IFacetedProject facetedProject, IProjectFacetVersion version, JpaPlatform.Config platformConfig) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)version.getVersionString());
        dm.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)platformConfig);
        dm.setProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", (Object)true);
        LibraryInstallDelegate libraryInstallDelegate = this.getNoOpLibraryProvider(facetedProject, version);
        dm.setProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryInstallDelegate);
        return dm;
    }

    private boolean canConfigure(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        boolean enabled = this.isConfigurationEnabled(facade, monitor);
        if (!enabled) {
            return false;
        }
        IProject project = facade.getProject();
        if (!project.hasNature("org.eclipse.jdt.core.javanature") || project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && !ModuleCoreNature.componentResourceExists((IProject)project)) {
            return false;
        }
        IFacetedProject fProj = ProjectFacetsManager.create((IProject)project);
        return fProj == null || !fProj.hasProjectFacet(JpaProject.FACET);
    }

    private boolean isConfigurationEnabled(IMavenProjectFacade facade, IProgressMonitor monitor) throws CoreException {
        if (WTPProjectsUtil.isM2eWtpDisabled((IMavenProjectFacade)facade, (IProgressMonitor)monitor)) {
            return false;
        }
        Object pomActivationValue = facade.getMavenProject(monitor).getProperties().get(M2E_JPA_ACTIVATION_PROPERTY);
        boolean enabled = pomActivationValue == null ? MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().isEnabled(this.getId()) : Boolean.parseBoolean(pomActivationValue.toString());
        return enabled;
    }

    private LibraryInstallDelegate getNoOpLibraryProvider(IFacetedProject facetedProject, IProjectFacetVersion facetVersion) {
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)facetedProject, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)JPA_NO_OP_LIBRARY_PROVIDER);
        libraryDelegate.setLibraryProvider(provider);
        return libraryDelegate;
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }

    private void installJavaFacet(Set<IFacetedProject.Action> actions, IProject project, IFacetedProject facetedProject) {
        IProjectFacetVersion javaFv = JavaFacet.FACET.getVersion(JavaFacetUtil.getCompilerLevel((IProject)project));
        if (!facetedProject.hasProjectFacet(JavaFacet.FACET)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, javaFv, null));
        } else if (!facetedProject.hasProjectFacet(javaFv)) {
            actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, javaFv, null));
        }
    }

    protected void addFoldersToClean(ResourceCleaner fileCleaner, IMavenProjectFacade facade) {
        IPath p;
        IPath[] iPathArray = facade.getCompileSourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/persistence.xml")});
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/orm.xml")});
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/persistence.xml")});
                fileCleaner.addFiles(new IPath[]{p.append("META-INF/orm.xml")});
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestCompileSourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
        iPathArray = facade.getTestResourceLocations();
        n = iPathArray.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            if (p != null) {
                fileCleaner.addFolder(p);
            }
            ++n2;
        }
    }
}

