/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.context.tasks.ui.ActiveContextExternalizationParticipant;
import org.eclipse.mylyn.internal.context.tasks.ui.ContextMementoMigrator;
import org.eclipse.mylyn.internal.context.tasks.ui.ContextStatePersistenceHandler;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStore;
import org.eclipse.mylyn.internal.context.ui.ContextPopulationStrategy;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.IContextUiConstants;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.context.RetrieveLatestContextDialog;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskMigrator;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ContextTasksStartupHandler
implements IContextUiStartup {
    private static final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void preTaskDeactivated(ITask task) {
            ContextUiPlugin.getEditorStateParticipant().setEnabled(!TaskMigrator.isActive());
        }

        public void preTaskActivated(ITask task) {
            ContextUiPlugin.getEditorStateParticipant().setEnabled(!TaskMigrator.isActive());
        }

        public void taskActivated(ITask task) {
            if (CoreUtil.TEST_MODE) {
                return;
            }
            boolean hasLocalContext = ContextCore.getContextManager().hasContext(task.getHandleIdentifier());
            if (!hasLocalContext && AttachmentUtil.hasContextAttachment((ITask)task)) {
                RetrieveLatestContextDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (ITask)task);
            }
        }
    };
    private final ContextPopulationStrategy contextPopulationStrategy = new ContextPopulationStrategy();
    private final ContextActivationListener contextActivationListener = new ContextActivationListener();

    public void lazyStartup() {
        ExternalizationManager externalizationManager = TasksUiPlugin.getExternalizationManager();
        ActiveContextExternalizationParticipant activeContextExternalizationParticipant = new ActiveContextExternalizationParticipant(externalizationManager);
        externalizationManager.addParticipant((IExternalizationParticipant)activeContextExternalizationParticipant);
        activeContextExternalizationParticipant.registerListeners();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                        ContextMementoMigrator migrator = new ContextMementoMigrator(ContextUiPlugin.getDefault().getStateManager());
                        migrator.setDeleteOldDataEnabled(true);
                        IStatus status = migrator.migrateContextMementos(progress);
                        if (!status.isOK()) {
                            StatusHandler.log((IStatus)status);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Unexpected error migrating context state", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {}
        TasksUi.getTaskActivityManager().addActivationListener(TASK_ACTIVATION_LISTENER);
        ContextUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.mylyn.ide.ui.expansion.auto.manage".equals(event.getProperty())) {
                    ContextTasksStartupHandler.this.updateAutoManageExpansionPreference();
                }
            }
        });
        this.updateAutoManageExpansionPreference();
        ContextCore.getContextManager().addListener((AbstractContextListener)this.contextActivationListener);
    }

    private void updateAutoManageExpansionPreference() {
        boolean value = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.expansion.auto.manage");
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.auto.expand", value);
    }

    void contextActivated(ContextChangeEvent event) {
        ITask task;
        if (this.contextPopulationStrategy.isDisabled()) {
            return;
        }
        if (event.getContext().getAllElements().isEmpty() && (task = TasksUi.getRepositoryModel().getTask(event.getContextHandle())) != null) {
            try {
                TaskData taskData = TasksUiPlugin.getTaskDataManager().hasTaskData(task) ? TasksUiPlugin.getTaskDataManager().getWorkingCopy(task, false).getLocalData() : null;
                IInteractionContext context = event.getContext();
                TaskContentAdapter input = new TaskContentAdapter(taskData, task);
                this.contextPopulationStrategy.populateContext(context, (IAdaptable)input);
            }
            catch (CoreException e) {
                ContextUiPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private class ContextActivationListener
    extends AbstractContextListener {
        private ContextActivationListener() {
        }

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case PRE_ACTIVATED: {
                    ContextTasksStartupHandler.this.contextActivated(event);
                    break;
                }
                case ACTIVATED: {
                    this.getStateHandler().activated(event.getContext());
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showActionSet(IContextUiConstants.ID_CONTEXT_UI_ACTION_SET);
                    break;
                }
                case DEACTIVATED: {
                    this.getStateHandler().deactivated(event.getContext());
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideActionSet(IContextUiConstants.ID_CONTEXT_UI_ACTION_SET);
                    break;
                }
                case CLEARED: {
                    this.getStateHandler().clear(event.getContextHandle(), event.isActiveContext());
                }
            }
        }

        private ContextStatePersistenceHandler getStateHandler() {
            return ((TaskContextStore)TasksUiPlugin.getContextStore()).getStateHandler();
        }
    }

    final class TaskContentAdapter
    implements IAdaptable {
        private final TaskData taskData;
        private final ITask task;

        TaskContentAdapter(TaskData taskData, ITask task) {
            this.taskData = taskData;
            this.task = task;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == ITask.class) {
                return this.task;
            }
            if (adapter == TaskData.class) {
                return this.taskData;
            }
            if (adapter == String.class) {
                String description;
                if (this.taskData != null) {
                    String description2;
                    TaskAttribute attribute = this.taskData.getRoot().getMappedAttribute("task.common.description");
                    if (attribute != null && (description2 = attribute.getValue()) != null && description2.length() > 0) {
                        return description2;
                    }
                    attribute = this.taskData.getRoot().getMappedAttribute("task.common.comment.new");
                    if (attribute != null && (description2 = attribute.getValue()) != null && description2.length() > 0) {
                        return description2;
                    }
                }
                if (this.task instanceof AbstractTask && (description = ((AbstractTask)this.task).getNotes()) != null && description.length() > 0) {
                    return description;
                }
            }
            return null;
        }
    }
}

