/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.TemplateOption;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringOption
extends TemplateOption {
    private Text text;
    private Label labelControl;
    private boolean ignoreListener;
    private int fStyle = 2052;
    private static final int F_DEFAULT_STYLE = 2052;

    public StringOption(BaseOptionTemplateSection section, String name, String label) {
        super(section, name, label);
        this.setRequired(true);
    }

    public void setReadOnly(boolean readOnly) {
        this.fStyle = readOnly ? 2060 : 2052;
    }

    public String getText() {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    public void setText(String newText) {
        this.setValue(newText);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (this.text != null) {
            this.ignoreListener = true;
            String textValue = this.getText();
            this.text.setText(textValue != null ? textValue : "");
            this.ignoreListener = false;
        }
    }

    @Override
    public void createControl(Composite parent, int span) {
        this.labelControl = this.createLabel(parent, 1);
        this.labelControl.setEnabled(this.isEnabled());
        this.text = new Text(parent, this.fStyle);
        if (this.getValue() != null) {
            this.text.setText(this.getValue().toString());
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = span - 1;
        this.text.setLayoutData((Object)gd);
        this.text.setEnabled(this.isEnabled());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringOption.this.ignoreListener) {
                    return;
                }
                StringOption.super.setValue(StringOption.this.text.getText());
                StringOption.this.getSection().validateOptions(StringOption.this);
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().toString().length() == 0;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.labelControl != null) {
            this.labelControl.setEnabled(enabled);
            this.text.setEnabled(enabled);
        }
    }
}

